/*
 * Decompiled with CFR 0.152.
 */
package me.darksnakex.villagerfollow.mobchip.ai.schedule;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import me.darksnakex.villagerfollow.mobchip.ai.schedule.Activity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Schedule {
    private final Map<Integer, Activity> timeline;

    private Schedule(Map<Integer, Activity> timeline) {
        this.timeline = timeline;
    }

    public static Builder builder() {
        return new Builder();
    }

    public int size() {
        return this.timeline.size();
    }

    public boolean contains(int key) {
        return this.timeline.containsKey(key);
    }

    public boolean contains(@NotNull Activity value) {
        return this.timeline.containsValue((Object)value);
    }

    @Nullable
    public Activity get(int key) {
        return this.timeline.get(key);
    }

    @NotNull
    public Set<Integer> keySet() {
        return this.timeline.keySet();
    }

    @NotNull
    public Collection<Activity> values() {
        return this.timeline.values();
    }

    @NotNull
    public Set<Map.Entry<Integer, Activity>> entrySet() {
        return this.timeline.entrySet();
    }

    public static final class Builder {
        private final Map<Integer, Activity> map = new HashMap<Integer, Activity>();

        private Builder() {
        }

        public Builder addActivity(int time, @NotNull Activity activity) throws IllegalArgumentException {
            if (time < 0 || time > 24000) {
                throw new IllegalArgumentException("Time must be between 0 and 24000");
            }
            if (activity == null) {
                throw new IllegalArgumentException("Activity cannot be null");
            }
            this.map.put(time, activity);
            return this;
        }

        @NotNull
        public Map<Integer, Activity> getTimeline() {
            return this.map;
        }

        @NotNull
        public Schedule build() throws IllegalArgumentException {
            if (this.map.isEmpty()) {
                throw new IllegalArgumentException("Timeline cannot be empty");
            }
            return new Schedule(this.map);
        }
    }
}

