/*
 * Decompiled with CFR 0.152.
 */
package me.darksnakex.villagerfollow.mobchip.bosses;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import me.darksnakex.villagerfollow.mobchip.bosses.Boss;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Mob;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Minion<T extends Mob> {
    private final Class<T> entityClazz;
    private double health;
    private final Map<EquipmentSlot, ItemStack> equipment;
    private final Map<AttributeInstance, Double> attributes;

    public Minion(@NotNull Class<T> clazz, double health, @Nullable Map<EquipmentSlot, ItemStack> equipment, @Nullable Map<AttributeInstance, Double> attributes) throws IllegalArgumentException {
        if (clazz == null) {
            throw new IllegalArgumentException("Class type cannot be null");
        }
        if (health <= 0.0) {
            throw new IllegalArgumentException("Health cannot be less than or equal to 0");
        }
        this.entityClazz = clazz;
        this.health = health;
        this.attributes = attributes != null ? attributes : new HashMap<AttributeInstance, Double>();
        this.equipment = equipment != null ? equipment : new EnumMap<EquipmentSlot, ItemStack>(EquipmentSlot.class);
    }

    public Minion(@NotNull Class<T> clazz, double health, @Nullable Map<EquipmentSlot, ItemStack> equipment) throws IllegalArgumentException {
        this(clazz, health, equipment, null);
    }

    public Minion(@NotNull Class<T> clazz, double health) throws IllegalArgumentException {
        this(clazz, health, null);
    }

    public Minion(@NotNull Class<T> clazz) throws IllegalArgumentException {
        this(clazz, 20.0);
    }

    public Class<T> getEntityClass() {
        return this.entityClazz;
    }

    @Nullable
    public T spawn(@Nullable Location loc) {
        if (loc == null) {
            return null;
        }
        Mob mob = (Mob)loc.getWorld().spawn(loc, this.entityClazz);
        mob.setHealth(this.health);
        mob.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(this.health);
        for (EquipmentSlot s : this.equipment.keySet()) {
            switch (s) {
                case HAND: {
                    mob.getEquipment().setItemInMainHand(this.equipment.get(s));
                    break;
                }
                case OFF_HAND: {
                    mob.getEquipment().setItemInOffHand(this.equipment.get(s));
                    break;
                }
                case FEET: {
                    mob.getEquipment().setBoots(this.equipment.get(s));
                    break;
                }
                case LEGS: {
                    mob.getEquipment().setLeggings(this.equipment.get(s));
                    break;
                }
                case CHEST: {
                    mob.getEquipment().setChestplate(this.equipment.get(s));
                    break;
                }
                case HEAD: {
                    mob.getEquipment().setHelmet(this.equipment.get(s));
                }
            }
        }
        for (AttributeInstance a : this.attributes.keySet()) {
            a.setBaseValue(this.attributes.get(a).doubleValue());
        }
        return (T)mob;
    }

    @Nullable
    public T spawn(@Nullable Boss<?> b) {
        if (b == null) {
            return null;
        }
        if (b.getMob() == null) {
            return null;
        }
        return this.spawn(b.getMob().getLocation());
    }

    @Nullable
    public T spawn(@Nullable Entity en) {
        if (en == null) {
            return null;
        }
        return this.spawn(en.getLocation());
    }

    @NotNull
    public Map<AttributeInstance, Double> getAttributes() {
        return this.attributes;
    }

    public double getHealth() {
        return this.health;
    }

    public void setHealth(double health) {
        this.health = health;
    }

    public void addAttribute(@NotNull AttributeInstance inst, double value) {
        this.attributes.put(inst, value);
    }

    public void removeAttribute(@NotNull AttributeInstance inst) {
        this.attributes.remove(inst);
    }

    @NotNull
    public Map<EquipmentSlot, ItemStack> getEquipment() {
        return this.equipment;
    }

    public void setItem(@NotNull EquipmentSlot slot, @Nullable ItemStack item) {
        if (item == null) {
            return;
        }
        this.equipment.put(slot, item);
    }

    public void setHelmet(@Nullable ItemStack item) {
        this.setItem(EquipmentSlot.HEAD, item);
    }

    public void setChestplate(@Nullable ItemStack item) {
        this.setItem(EquipmentSlot.CHEST, item);
    }

    public void setLeggings(@Nullable ItemStack item) {
        this.setItem(EquipmentSlot.LEGS, item);
    }

    public void setBoots(@Nullable ItemStack item) {
        this.setItem(EquipmentSlot.FEET, item);
    }

    public void setMainhand(@Nullable ItemStack item) {
        this.setItem(EquipmentSlot.HAND, item);
    }

    public void setOffhand(@Nullable ItemStack item) {
        this.setItem(EquipmentSlot.OFF_HAND, item);
    }
}

