/*
 * Decompiled with CFR 0.152.
 */
package me.darksnakex.villagerfollow.mobchip.bukkit;

import java.lang.reflect.Constructor;
import me.darksnakex.villagerfollow.mobchip.DragonBrain;
import me.darksnakex.villagerfollow.mobchip.EntityBody;
import me.darksnakex.villagerfollow.mobchip.EntityBrain;
import me.darksnakex.villagerfollow.mobchip.abstraction.ChipUtil;
import me.darksnakex.villagerfollow.mobchip.ai.EntityAI;
import me.darksnakex.villagerfollow.mobchip.ai.attribute.Attribute;
import me.darksnakex.villagerfollow.mobchip.ai.attribute.AttributeInstance;
import me.darksnakex.villagerfollow.mobchip.ai.behavior.AllayBehavior;
import me.darksnakex.villagerfollow.mobchip.ai.behavior.AxolotlBehavior;
import me.darksnakex.villagerfollow.mobchip.ai.behavior.CamelBehavior;
import me.darksnakex.villagerfollow.mobchip.ai.behavior.DragonBehavior;
import me.darksnakex.villagerfollow.mobchip.ai.behavior.EntityBehavior;
import me.darksnakex.villagerfollow.mobchip.ai.behavior.FrogBehavior;
import me.darksnakex.villagerfollow.mobchip.ai.behavior.PiglinBehavior;
import me.darksnakex.villagerfollow.mobchip.ai.behavior.WardenBehavior;
import me.darksnakex.villagerfollow.mobchip.ai.controller.EntityController;
import me.darksnakex.villagerfollow.mobchip.ai.memories.EntityMemory;
import me.darksnakex.villagerfollow.mobchip.ai.memories.Memory;
import me.darksnakex.villagerfollow.mobchip.ai.memories.MemoryStatus;
import me.darksnakex.villagerfollow.mobchip.ai.navigation.EntityNavigation;
import me.darksnakex.villagerfollow.mobchip.ai.schedule.EntityScheduleManager;
import me.darksnakex.villagerfollow.mobchip.ai.sensing.EntitySenses;
import me.darksnakex.villagerfollow.mobchip.ai.sensing.Sensor;
import me.darksnakex.villagerfollow.mobchip.bukkit.BukkitAI;
import me.darksnakex.villagerfollow.mobchip.bukkit.BukkitCreatureBehavior;
import me.darksnakex.villagerfollow.mobchip.bukkit.BukkitDragonBrain;
import me.darksnakex.villagerfollow.mobchip.bukkit.BukkitEntityBehavior;
import me.darksnakex.villagerfollow.mobchip.bukkit.BukkitVillagerBehavior;
import me.darksnakex.villagerfollow.mobchip.bukkit.BukkitVillagerBrain;
import me.darksnakex.villagerfollow.mobchip.bukkit.events.RestrictionSetEvent;
import me.darksnakex.villagerfollow.mobchip.bukkit.events.memory.MemoryChangeEvent;
import me.darksnakex.villagerfollow.mobchip.combat.EntityCombatTracker;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Creature;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Villager;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BukkitBrain
implements EntityBrain {
    private static final String BUKKIT_PACKAGE = BukkitBrain.class.getPackage().getName() + ".";
    final Mob m;
    static final ChipUtil w = ChipUtil.getWrapper();

    BukkitBrain(@NotNull Mob m) {
        this.m = m;
    }

    @Nullable
    public static EntityBrain getBrain(@Nullable Mob m) {
        if (m == null) {
            return null;
        }
        if (m instanceof Villager) {
            return new BukkitVillagerBrain((Villager)m);
        }
        return new BukkitBrain(m);
    }

    @Nullable
    public static DragonBrain getBrain(@Nullable EnderDragon d) {
        if (d == null) {
            return null;
        }
        return new BukkitDragonBrain(d);
    }

    public static void registerSensor(@NotNull Sensor<?> sensor) throws IllegalArgumentException {
        if (BukkitBrain.isSensorRegistered(sensor.getKey())) {
            throw new IllegalArgumentException("Sensor is already registered with key: " + sensor.getKey());
        }
        w.registerSensor(sensor);
    }

    public static boolean isSensorRegistered(@NotNull Sensor<?> sensor) {
        return BukkitBrain.isSensorRegistered(sensor.getKey());
    }

    public static boolean isSensorRegistered(@NotNull NamespacedKey key) {
        return w.existsSensor(key);
    }

    @Nullable
    public static Sensor<?> getRegisteredSensor(@NotNull NamespacedKey key) {
        if (!BukkitBrain.isSensorRegistered(key)) {
            return null;
        }
        return w.getSensor(key);
    }

    @Override
    @NotNull
    public EntityAI getGoalAI() {
        return new BukkitAI(this.m, false);
    }

    @Override
    @NotNull
    public AttributeInstance getAttributeInstance(@NotNull Attribute a) {
        return w.getAttributeInstance(this.m, a);
    }

    @Override
    @NotNull
    public EntityAI getTargetAI() {
        return new BukkitAI(this.m, true);
    }

    @Override
    @NotNull
    public EntityNavigation createNavigation() {
        return w.getNavigation(this.m);
    }

    @Override
    @NotNull
    public EntityController getController() {
        return w.getController(this.m);
    }

    @Override
    @NotNull
    public EntityScheduleManager getScheduleManager() {
        return w.getManager(this.m);
    }

    @Override
    public EntityBehavior getBehaviors() {
        try {
            Constructor<EntityBehavior> constr = null;
            Class entityClass = this.m.getType().getEntityClass();
            switch (this.m.getType().name().toLowerCase()) {
                case "frog": {
                    Class<FrogBehavior> frog = Class.forName(BUKKIT_PACKAGE + "BukkitFrogBehavior").asSubclass(FrogBehavior.class);
                    constr = frog.getDeclaredConstructor(entityClass);
                    break;
                }
                case "warden": {
                    Class<WardenBehavior> warden = Class.forName(BUKKIT_PACKAGE + "BukkitWardenBehavior").asSubclass(WardenBehavior.class);
                    constr = warden.getDeclaredConstructor(entityClass);
                    break;
                }
                case "ender_dragon": {
                    Class<DragonBehavior> dragon = Class.forName(BUKKIT_PACKAGE + "BukkitDragonBehavior").asSubclass(DragonBehavior.class);
                    constr = dragon.getDeclaredConstructor(entityClass);
                    break;
                }
                case "axolotl": {
                    Class<AxolotlBehavior> axolotl = Class.forName(BUKKIT_PACKAGE + "BukkitAxolotlBehavior").asSubclass(AxolotlBehavior.class);
                    constr = axolotl.getDeclaredConstructor(entityClass);
                    break;
                }
                case "piglin": {
                    Class<PiglinBehavior> piglin = Class.forName(BUKKIT_PACKAGE + "BukkitPiglinBehavior").asSubclass(PiglinBehavior.class);
                    constr = piglin.getDeclaredConstructor(entityClass);
                    break;
                }
                case "allay": {
                    Class<AllayBehavior> allay = Class.forName(BUKKIT_PACKAGE + "BukkitAllayBehavior").asSubclass(AllayBehavior.class);
                    constr = allay.getDeclaredConstructor(entityClass);
                    break;
                }
                case "camel": {
                    Class<CamelBehavior> camel = Class.forName(BUKKIT_PACKAGE + "BukkitCamelBehavior").asSubclass(CamelBehavior.class);
                    constr = camel.getDeclaredConstructor(entityClass);
                    break;
                }
            }
            constr.setAccessible(true);
            return (EntityBehavior)constr.newInstance(this.m);
        }
        catch (ClassNotFoundException | NoSuchMethodException constr) {
        }
        catch (Exception e) {
            ChipUtil.printStackTrace(e);
        }
        if (this.m instanceof Villager) {
            return new BukkitVillagerBehavior((Villager)this.m);
        }
        if (this.m instanceof Creature) {
            return new BukkitCreatureBehavior((Creature)this.m);
        }
        return new BukkitEntityBehavior(this.m);
    }

    @Override
    @NotNull
    public EntityBody getBody() {
        return w.getBody(this.m);
    }

    @Override
    @NotNull
    public EntityCombatTracker getCombatTracker() {
        return w.getCombatTracker(this.m);
    }

    @Override
    @NotNull
    public EntitySenses getSenses() {
        return w.getSenses(this.m);
    }

    @Override
    public <T> void setMemory(@NotNull Memory<T> memory, @Nullable T value) throws IllegalArgumentException {
        if (value == null) {
            this.removeMemory(memory);
        }
        T old = this.getMemory(memory);
        w.setMemory(this.m, memory, value);
        MemoryChangeEvent event = new MemoryChangeEvent(this, (EntityMemory)memory, old, value);
        Bukkit.getPluginManager().callEvent((Event)event);
    }

    @Override
    public <T> void setMemory(@NotNull Memory<T> memory, @Nullable T value, long expire) throws IllegalArgumentException {
        if (value == null) {
            this.removeMemory(memory);
        }
        T old = this.getMemory(memory);
        w.setMemory(this.m, memory, value, expire);
        MemoryChangeEvent event = new MemoryChangeEvent(this, (EntityMemory)memory, old, value);
        Bukkit.getPluginManager().callEvent((Event)event);
    }

    @Override
    @Nullable
    public <T> T getMemory(@NotNull Memory<T> memory) {
        return w.getMemory(this.m, memory);
    }

    @Override
    public long getExpiration(@NotNull Memory<?> memory) {
        return w.getExpiry(this.m, memory);
    }

    @Override
    public boolean containsMemory(@NotNull Memory<?> memory) {
        return w.contains(this.m, memory);
    }

    @Override
    public void removeMemory(@NotNull Memory<?> memory) {
        w.removeMemory(this.m, memory);
    }

    @Override
    public MemoryStatus getMemoryStatus(@NotNull Memory<?> memory) {
        return w.getMemoryStatus(this.m, memory);
    }

    @Override
    public boolean isInRestriction() {
        return w.isRestricted(this.m);
    }

    @Override
    public void setRestrictionArea(Location center, int radius) {
        RestrictionSetEvent event = new RestrictionSetEvent(this, this.getRestrictionArea(), center, this.getRestrictionRadius(), radius);
        Bukkit.getPluginManager().callEvent((Event)event);
        Location newCenter = event.getNewCenter();
        int newRadius = event.getNewRadius();
        w.restrictTo(this.m, newCenter.getX(), newCenter.getY(), newCenter.getZ(), newRadius);
    }

    @Override
    public void clearRestrictionArea() {
        w.clearRestriction(this.m);
    }

    @Override
    public Location getRestrictionArea() {
        return w.getRestriction(this.m);
    }

    @Override
    public boolean hasRestriction() {
        return w.hasRestriction(this.m);
    }

    @Override
    public int getRestrictionRadius() {
        return w.getRestrictionRadius(this.m);
    }

    @Override
    public boolean canSee(@Nullable Entity en) {
        return w.canSee(this.m, en);
    }

    @Override
    @NotNull
    public Mob getEntity() {
        return this.m;
    }
}

