/*
 * Decompiled with CFR 0.152.
 */
package me.darksnakex.villagerfollow.mobchip.bukkit;

import java.util.function.Predicate;
import me.darksnakex.villagerfollow.mobchip.abstraction.ChipUtil;
import me.darksnakex.villagerfollow.mobchip.ai.behavior.BehaviorResult;
import me.darksnakex.villagerfollow.mobchip.ai.behavior.EntityBehavior;
import me.darksnakex.villagerfollow.mobchip.ai.memories.Memory;
import org.bukkit.entity.Mob;
import org.jetbrains.annotations.NotNull;

class BukkitEntityBehavior
implements EntityBehavior {
    private final Mob m;
    static final ChipUtil wrapper = ChipUtil.getWrapper();

    BukkitEntityBehavior(Mob m) {
        this.m = m;
    }

    static void notNull(Object o, String message) {
        if (o == null) {
            throw new IllegalArgumentException(message);
        }
    }

    BehaviorResult run(String behaviorName, Object ... args) {
        return wrapper.runBehavior(this.m, behaviorName, args);
    }

    @Override
    @NotNull
    public BehaviorResult backupIfClose(int min, float speedMod) {
        return this.run("BehaviorRetreat", min, Float.valueOf(speedMod));
    }

    @Override
    @NotNull
    public BehaviorResult passiveIf(@NotNull Memory<?> memory, int durationTicks) throws IllegalArgumentException {
        BukkitEntityBehavior.notNull(memory, "Memory cannot be null");
        return this.run("BehaviorPacify", memory, durationTicks);
    }

    @Override
    @NotNull
    public BehaviorResult eraseIf(@NotNull Predicate<Mob> function, @NotNull Memory<?> memory) throws IllegalArgumentException {
        BukkitEntityBehavior.notNull(function, "Function cannot be null");
        BukkitEntityBehavior.notNull(memory, "Memory cannot be null");
        return this.run("BehaviorRemoveMemory", function, memory);
    }

    @Override
    @NotNull
    public BehaviorResult moveToWantedItem(int minDist, float speedMod, boolean requireTarget) {
        return this.run("BehaviorFindAdmirableItem", Float.valueOf(speedMod), requireTarget, minDist);
    }

    @Override
    @NotNull
    public BehaviorResult jumpOnBed(float speedMod) {
        return this.run("BehaviorBedJump", Float.valueOf(speedMod));
    }

    @Override
    @NotNull
    public BehaviorResult meleeAttack(int cooldown) {
        return this.run("BehaviorAttack", cooldown);
    }

    @Override
    @NotNull
    public BehaviorResult wakeUp() {
        return this.run("BehaviorWake", new Object[0]);
    }

    @Override
    @NotNull
    public BehaviorResult ringBell() {
        return this.run("BehaviorBellRing", new Object[0]);
    }

    @Override
    @NotNull
    public BehaviorResult reactToBell() {
        return this.run("BehaviorBellAlert", new Object[0]);
    }

    @Override
    @NotNull
    public BehaviorResult interactWithDoor() {
        return this.run("BehaviorInteractDoor", new Object[0]);
    }

    @Override
    @NotNull
    public BehaviorResult sleep() {
        return this.run("BehaviorSleep", new Object[0]);
    }

    @Override
    @NotNull
    public BehaviorResult socializeAtBell() {
        return this.run("BehaviorBell", new Object[0]);
    }
}

