/*
 * Decompiled with CFR 0.152.
 */
package me.darksnakex.villagerfollow.interactions;

import java.util.Objects;
import me.darksnakex.villagerfollow.VillagerFollow;
import me.darksnakex.villagerfollow.interactions.VillagerInteraction;
import me.darksnakex.villagerfollow.interactions.VillagerInteractionHandEmerald;
import org.bukkit.EntityEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class VillagerInteractionDropEmerald
implements Listener {
    private static VillagerFollow plugin;
    private static BukkitTask task;

    public VillagerInteractionDropEmerald(VillagerFollow plugin) {
        VillagerInteractionDropEmerald.plugin = plugin;
    }

    public static void onPluginReload2() {
        if (task != null) {
            task.cancel();
            task = null;
        }
    }

    @EventHandler
    private static void villagerFollowsEmerald(PlayerDropItemEvent event) {
        final FileConfiguration config = plugin.getConfig();
        if (Objects.equals(config.getString("Config.villager-allow-goto-emerald"), "true") && Objects.equals(config.getString("Config.villager-follow"), "true")) {
            final Location playerLocation = event.getPlayer().getLocation();
            VillagerInteractionHandEmerald.radius = config.getDouble("Config.villager-follow-radius");
            final double velocidad = config.getDouble("Config.villager-follow-speed");
            if (task == null || task.isCancelled()) {
                task = new BukkitRunnable(){

                    public void run() {
                        for (Entity entity : playerLocation.getWorld().getEntities()) {
                            if (!entity.getType().equals((Object)EntityType.VILLAGER) || entity.hasMetadata("paid")) continue;
                            Villager villager = (Villager)entity;
                            Location villagerLocation = villager.getLocation();
                            for (Entity itemEntity : villagerLocation.getWorld().getNearbyEntities(villagerLocation, VillagerInteractionHandEmerald.radius, VillagerInteractionHandEmerald.radius, VillagerInteractionHandEmerald.radius)) {
                                if (!(itemEntity instanceof Item) || ((Item)itemEntity).getItemStack().getType() != Material.EMERALD) continue;
                                double distance = villagerLocation.distance(itemEntity.getLocation());
                                if (distance <= VillagerInteractionHandEmerald.radius) {
                                    VillagerInteraction.followThing(villager, itemEntity.getLocation(), velocidad);
                                }
                                if (!(distance <= 2.0) || !Objects.equals(config.getString("Config.villager-allow-catch-emerald"), "true")) continue;
                                ItemStack esmeralda = new ItemStack(Material.EMERALD, 1);
                                villager.getEquipment().setItemInMainHand(esmeralda);
                                itemEntity.remove();
                                if (!Objects.equals(config.getString("Config.villager-allow-catch-emerald-heal"), "true")) continue;
                                villager.setHealth(20.0);
                                villager.playEffect(EntityEffect.VILLAGER_HEART);
                            }
                        }
                    }
                }.runTaskTimer((Plugin)plugin, 0L, 20L);
            }
        }
    }
}

