/*
 * Decompiled with CFR 0.152.
 */
package me.darksnakex.villagerfollow.mobchip.ai.attribute;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import me.darksnakex.villagerfollow.mobchip.abstraction.ChipUtil;
import me.darksnakex.villagerfollow.mobchip.ai.attribute.Attribute;
import org.bukkit.NamespacedKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EntityAttribute
implements Attribute {
    private static final ChipUtil wrapper = ChipUtil.getWrapper();
    public static final Attribute GENERIC_MAX_HEALTH = wrapper.getDefaultAttribute("generic.max_health");
    public static final Attribute GENERIC_FOLLOW_RANGE = wrapper.getDefaultAttribute("generic.follow_range");
    public static final Attribute GENERIC_KNOCKBACK_RESISTANCE = wrapper.getDefaultAttribute("generic.knockback_resistance");
    public static final Attribute GENERIC_MOVEMENT_SPEED = wrapper.getDefaultAttribute("generic.movement_speed");
    public static final Attribute GENERIC_FLYING_SPEED = wrapper.getDefaultAttribute("generic.flying_speed");
    public static final Attribute GENERIC_ATTACK_DAMAGE = wrapper.getDefaultAttribute("generic.attack_damage");
    public static final Attribute GENERIC_ATTACK_SPEED = wrapper.getDefaultAttribute("generic.attack_speed");
    public static final Attribute GENERIC_ARMOR = wrapper.getDefaultAttribute("generic.armor");
    public static final Attribute GENERIC_ARMOR_TOUGHNESS = wrapper.getDefaultAttribute("generic.armor_toughness");
    public static final Attribute GENERIC_ATTACK_KNOCKBACK = wrapper.getDefaultAttribute("generic.attack_knockback");
    public static final Attribute GENERIC_LUCK = wrapper.getDefaultAttribute("generic.luck");
    public static final Attribute ZOMBIE_SPAWN_REINFORCEMENTS = wrapper.getDefaultAttribute("zombie.spawn_reinforcements");
    public static final Attribute HORSE_JUMP_STRENGTH = wrapper.getDefaultAttribute("horse.jump_strength");
    public static final Attribute MAX_ABSORPTION = wrapper.getDefaultAttribute("generic.max_absorption");
    public static final Attribute GRAVITY = wrapper.getDefaultAttribute("generic.gravity");
    public static final Attribute SCALE = wrapper.getDefaultAttribute("generic.scale");
    public static final Attribute STEP_HEIGHT = wrapper.getDefaultAttribute("generic.step_height");
    public static final Attribute SAFE_FALL_DISTANCE = wrapper.getDefaultAttribute("generic.safe_fall_distance");
    public static final Attribute FALL_DAMAGE_MULTIPLIER = wrapper.getDefaultAttribute("generic.fall_damage_multiplier");
    public static final Attribute BLOCK_INTERACTION_RANGE = wrapper.getDefaultAttribute("player.block_interaction_range");
    public static final Attribute ENTITY_INTERACTION_RANGE = wrapper.getDefaultAttribute("player.entity_interaction_range");
    public static final Attribute BLOCK_BREAK_SPEED = wrapper.getDefaultAttribute("player.block_break_speed");
    private Attribute handle;

    @Nullable
    public static Attribute fromBukkit(@Nullable org.bukkit.attribute.Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        return new EntityAttribute(attribute);
    }

    private EntityAttribute(Attribute handle) {
        this.handle = handle;
    }

    private EntityAttribute(org.bukkit.attribute.Attribute bukkit) {
        try {
            for (Field f : EntityAttribute.class.getDeclaredFields()) {
                if (!Modifier.isStatic(f.getModifiers()) || !Modifier.isFinal(f.getModifiers()) || !f.getName().equals(bukkit.name())) continue;
                f.setAccessible(true);
                this.handle = (Attribute)f.get(null);
                return;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public double getMinValue() {
        return this.handle.getMinValue();
    }

    @Override
    public double getMaxValue() {
        return this.handle.getMaxValue();
    }

    @Override
    public double getDefaultValue() {
        return this.handle.getDefaultValue();
    }

    @NotNull
    public NamespacedKey getKey() {
        return this.handle.getKey();
    }

    @Override
    public boolean isClientSide() {
        return this.handle.isClientSide();
    }

    @Nullable
    public static EntityAttribute getAttribute(@Nullable NamespacedKey key) {
        if (key == null) {
            return null;
        }
        if (!wrapper.existsAttribute(key)) {
            return null;
        }
        return new EntityAttribute(wrapper.getAttribute(key));
    }

    public static boolean exists(@Nullable NamespacedKey key) {
        return EntityAttribute.getAttribute(key) != null;
    }

    public static final class Builder {
        private NamespacedKey key;
        private double minValue = 1.0;
        private double defaultValue = 1.0;
        private double maxValue = 1024.0;
        private boolean clientSide = true;

        private Builder() {
        }

        public Builder setKey(@NotNull NamespacedKey key) {
            this.key = key;
            return this;
        }

        public Builder setMinValue(double minValue) {
            this.minValue = minValue;
            return this;
        }

        public Builder setDefaultValue(double defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder setMaxValue(double maxValue) {
            this.maxValue = maxValue;
            return this;
        }

        public Builder setClientSide(boolean clientSide) {
            this.clientSide = clientSide;
            return this;
        }

        public EntityAttribute build() throws IllegalArgumentException, UnsupportedOperationException {
            if (this.minValue < 0.0 || this.maxValue < 0.0 || this.defaultValue < 0.0) {
                throw new IllegalArgumentException("Values cannot be negative");
            }
            if (this.minValue > this.maxValue) {
                throw new IllegalArgumentException("Minimum must be less than maximum");
            }
            if (this.defaultValue < this.minValue || this.defaultValue > this.maxValue) {
                throw new IllegalArgumentException("Default value must be between minimum and maximum");
            }
            if (this.key == null) {
                throw new IllegalArgumentException("Key cannot be null");
            }
            if (wrapper.existsAttribute(this.key)) {
                throw new UnsupportedOperationException("Attribute already exists");
            }
            return new EntityAttribute(wrapper.registerAttribute(this.key, this.minValue, this.defaultValue, this.maxValue, this.clientSide));
        }
    }
}

