/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.aether.entity.living;

import com.matthewperiut.accessoryapi.api.BossLivingEntity;
import com.matthewperiut.aether.achievement.AetherAchievements;
import com.matthewperiut.aether.block.AetherBlocks;
import com.matthewperiut.aether.entity.AetherEntities;
import com.matthewperiut.aether.entity.living.EntityFireMinion;
import com.matthewperiut.aether.entity.projectile.EntityFiroBall;
import com.matthewperiut.aether.item.AetherItems;
import com.matthewperiut.aether.mixin.access.EntityAccessor;
import com.matthewperiut.aether.util.NameGen;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_127;
import net.minecraft.class_15;
import net.minecraft.class_17;
import net.minecraft.class_18;
import net.minecraft.class_189;
import net.minecraft.class_25;
import net.minecraft.class_31;
import net.minecraft.class_511;
import net.minecraft.class_54;
import net.minecraft.class_57;
import net.minecraft.class_69;
import net.minecraft.class_8;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.modificationstation.stationapi.api.server.entity.MobSpawnDataProvider;
import net.modificationstation.stationapi.api.util.Identifier;
import net.modificationstation.stationapi.api.util.SideUtil;

public class EntityFireMonster
extends class_511
implements BossLivingEntity,
MobSpawnDataProvider {
    public int wideness;
    public int orgX;
    public int orgY;
    public int orgZ;
    public int motionTimer;
    public int entCount;
    public int flameCount;
    public int ballCount;
    public int chatLog;
    public int chatCount;
    public int hurtness;
    public int direction;
    public double rotary;
    public double speedness;
    public class_57 target;
    public boolean gotTarget;
    public String bossName;
    public static final float jimz = 57.295773f;
    public boolean isBoss;
    int areaOfEffect = 50;

    public EntityFireMonster(class_18 world) {
        super(world);
        this.field_1019 = "aether:stationapi/textures/mobs/firemonster.png";
        this.method_1321(2.25f, 2.5f);
        this.field_1642 = true;
        this.orgX = class_189.method_645((double)this.field_1600);
        this.orgY = class_189.method_645((double)this.field_1610.field_130) + 1;
        this.orgZ = class_189.method_645((double)this.field_1602);
        this.wideness = 10;
        this.field_1036 = 50;
        this.speedness = 0.5 - (double)this.field_1036 / 70.0 * 0.2;
        this.direction = 0;
        this.entCount = this.field_1644.nextInt(6);
        this.bossName = NameGen.gen();
    }

    public EntityFireMonster(class_18 world, int x, int y, int z, int rad, int dir) {
        super(world);
        this.field_1019 = "aether:stationapi/textures/mobs/firemonster.png";
        this.method_1321(2.25f, 2.5f);
        this.method_1340((double)x + 0.5, y, (double)z + 0.5);
        this.wideness = rad - 2;
        this.orgX = x;
        this.orgY = y;
        this.orgZ = z;
        this.field_1642 = true;
        this.rotary = (double)this.field_1644.nextFloat() * 360.0;
        this.field_1036 = 50;
        this.speedness = 0.5 - (double)this.field_1036 / 70.0 * 0.2;
        this.direction = dir;
        this.entCount = this.field_1644.nextInt(6);
        this.bossName = NameGen.gen();
    }

    public boolean method_940() {
        return false;
    }

    public void method_1370() {
        super.method_1370();
        if (this.field_1036 > 0) {
            double a = this.field_1644.nextFloat() - 0.5f;
            double b = this.field_1644.nextFloat();
            double c = this.field_1644.nextFloat() - 0.5f;
            double d = this.field_1600 + a * b;
            double e = this.field_1610.field_130 + b - 0.5;
            double f = this.field_1602 + c * b;
            this.field_1596.method_178("flame", d, e, f, 0.0, (double)-0.075f, 0.0);
            ++this.entCount;
            if (this.entCount >= 3) {
                this.burnEntities();
                this.evapWater();
                this.entCount = 0;
            }
            if (this.hurtness > 0) {
                --this.hurtness;
                if (this.hurtness == 0) {
                    this.field_1019 = "aether:stationapi/textures/mobs/firemonster.png";
                }
            }
        }
        if (this.chatCount > 0) {
            --this.chatCount;
        }
    }

    protected class_57 findPlayerToAttack() {
        class_54 entityplayer = this.field_1596.method_186((class_57)this, 32.0);
        return entityplayer != null && this.method_928((class_57)entityplayer) ? entityplayer : null;
    }

    public void method_910() {
        super.method_910();
        if (this.gotTarget && this.target == null) {
            this.target = this.findPlayerToAttack();
            this.gotTarget = false;
        }
        if (this.target == null) {
            this.method_1340((double)this.orgX + 0.5, this.orgY, (double)this.orgZ + 0.5);
            this.setDoor(0);
        } else {
            this.field_1012 = this.field_1606;
            this.method_1340(this.field_1600, this.orgY, this.field_1602);
            this.field_1604 = 0.0;
            boolean pool = false;
            if (this.field_1603 > 0.0 && (int)Math.floor(this.field_1600) > this.orgX + this.wideness) {
                this.rotary = 360.0 - this.rotary;
                pool = true;
            } else if (this.field_1603 < 0.0 && (int)Math.floor(this.field_1600) < this.orgX - this.wideness) {
                this.rotary = 360.0 - this.rotary;
                pool = true;
            }
            if (this.field_1605 > 0.0 && (int)Math.floor(this.field_1602) > this.orgZ + this.wideness) {
                this.rotary = 180.0 - this.rotary;
                pool = true;
            } else if (this.field_1605 < 0.0 && (int)Math.floor(this.field_1602) < this.orgZ - this.wideness) {
                this.rotary = 180.0 - this.rotary;
                pool = true;
            }
            if (this.rotary > 360.0) {
                this.rotary -= 360.0;
            } else if (this.rotary < 0.0) {
                this.rotary += 360.0;
            }
            if (this.target != null) {
                this.method_924(this.target, 20.0f, 20.0f);
            }
            double crazy = this.rotary / 57.295772552490234;
            this.field_1603 = Math.sin(crazy) * this.speedness;
            this.field_1605 = Math.cos(crazy) * this.speedness;
            ++this.motionTimer;
            if (this.motionTimer >= 20 || pool) {
                this.motionTimer = 0;
                if (this.field_1644.nextInt(3) == 0) {
                    this.rotary += (double)(this.field_1644.nextFloat() - this.field_1644.nextFloat()) * 60.0;
                }
            }
            ++this.flameCount;
            if (this.flameCount == 40 && this.field_1644.nextInt(2) == 0) {
                this.poopFire();
            } else if (this.flameCount >= 55 + this.field_1036 / 2 && this.target != null && this.target instanceof class_127) {
                this.makeFireBall(1);
                this.flameCount = 0;
            }
            if (this.target != null && this.target.field_1630) {
                this.method_1340((double)this.orgX + 0.5, this.orgY, (double)this.orgZ + 0.5);
                this.field_1603 = 0.0;
                this.field_1604 = 0.0;
                this.field_1605 = 0.0;
                this.target = null;
                this.chatLine("\u00a7cSuch is the fate of a being who opposes the might of the sun.");
                this.setDoor(0);
                this.isBoss = false;
                this.gotTarget = false;
            }
        }
    }

    public void burnEntities() {
        List list = this.field_1596.method_211((class_57)this, this.field_1610.method_93(0.0, 4.0, 0.0));
        for (int j = 0; j < list.size(); ++j) {
            class_57 entity1 = (class_57)list.get(j);
            if (!(entity1 instanceof class_127)) continue;
            class_127 living = (class_127)entity1;
            if (((EntityAccessor)entity1).isImmuneToFire()) continue;
            entity1.method_1355((class_57)this, 10);
            entity1.field_1647 = 300;
        }
    }

    public void evapWater() {
        int x = class_189.method_645((double)this.field_1600);
        int z = class_189.method_645((double)this.field_1602);
        for (int i = 0; i < 8; ++i) {
            int b = this.orgY - 2 + i;
            if (this.field_1596.method_1779(x, b, z) != class_15.field_985) continue;
            this.field_1596.method_229(x, b, z, 0);
            this.field_1596.method_150((double)((float)x + 0.5f), (double)((float)b + 0.5f), (double)((float)z + 0.5f), "random.fizz", 0.5f, 2.6f + (this.field_1644.nextFloat() - this.field_1644.nextFloat()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                this.field_1596.method_178("largesmoke", (double)x + Math.random(), (double)b + 0.75, (double)z + Math.random(), 0.0, 0.0, 0.0);
            }
        }
    }

    public void makeFireBall(int shots) {
        this.field_1596.method_191((class_57)this, "mob.ghast.fireball", 5.0f, (this.field_1644.nextFloat() - this.field_1644.nextFloat()) * 0.2f + 1.0f);
        boolean flag = false;
        ++this.ballCount;
        if (this.ballCount >= 3 + this.field_1644.nextInt(3)) {
            flag = true;
            this.ballCount = 0;
        }
        for (int i = 0; i < shots; ++i) {
            EntityFiroBall e1 = new EntityFiroBall(this.field_1596, this.field_1600 - this.field_1603 / 2.0, this.field_1601, this.field_1602 - this.field_1605 / 2.0, flag);
            this.field_1596.method_210((class_57)e1);
        }
    }

    public void poopFire() {
        int z;
        int b;
        int x = class_189.method_645((double)this.field_1600);
        if (AetherBlocks.isGood(this.field_1596.method_1776(x, b = this.orgY - 2, z = class_189.method_645((double)this.field_1602)), this.field_1596.method_1778(x, b, z))) {
            this.field_1596.method_229(x, b, z, class_17.field_1892.field_1915);
        }
    }

    public void method_1368(class_8 nbttagcompound) {
        super.method_1368(nbttagcompound);
        nbttagcompound.method_1020("OriginX", (short)this.orgX);
        nbttagcompound.method_1020("OriginY", (short)this.orgY);
        nbttagcompound.method_1020("OriginZ", (short)this.orgZ);
        nbttagcompound.method_1020("Wideness", (short)this.wideness);
        nbttagcompound.method_1020("FlameCount", (short)this.flameCount);
        nbttagcompound.method_1020("BallCount", (short)this.ballCount);
        nbttagcompound.method_1020("ChatLog", (short)this.chatLog);
        nbttagcompound.method_1014("Rotary", (float)this.rotary);
        this.gotTarget = this.target != null;
        nbttagcompound.method_1021("GotTarget", this.gotTarget);
        nbttagcompound.method_1021("IsCurrentBoss", this.isBoss);
        nbttagcompound.method_1019("BossName", this.bossName);
    }

    public void method_1363(class_8 nbttagcompound) {
        super.method_1363(nbttagcompound);
        this.orgX = nbttagcompound.method_1026("OriginX");
        this.orgY = nbttagcompound.method_1026("OriginY");
        this.orgZ = nbttagcompound.method_1026("OriginZ");
        this.wideness = nbttagcompound.method_1026("Wideness");
        this.flameCount = nbttagcompound.method_1026("FlameCount");
        this.ballCount = nbttagcompound.method_1026("BallCount");
        this.chatLog = nbttagcompound.method_1026("ChatLog");
        this.rotary = nbttagcompound.method_1029("Rotary");
        this.gotTarget = nbttagcompound.method_1035("GotTarget");
        this.speedness = 0.5 - (double)this.field_1036 / 70.0 * 0.2;
        if (nbttagcompound.method_1035("IsCurrentBoss")) {
            this.isBoss = true;
        }
        this.bossName = nbttagcompound.method_1031("BossName");
    }

    public void chatLine(String s) {
        SideUtil.run(() -> this.chatLineClient(s), () -> this.chatLineServer(s));
    }

    @Environment(value=EnvType.CLIENT)
    public void chatLineClient(String s) {
        Minecraft mc = (Minecraft)FabricLoader.getInstance().getGameInstance();
        mc.field_2820.method_1949(s);
    }

    @Environment(value=EnvType.SERVER)
    public void chatLineServer(String s) {
        MinecraftServer mc = (MinecraftServer)FabricLoader.getInstance().getGameInstance();
        List playersNearby = this.field_1596.method_175(class_54.class, class_25.method_87((double)(this.field_1600 - (double)this.areaOfEffect), (double)(this.field_1601 - (double)this.areaOfEffect), (double)(this.field_1602 - (double)this.areaOfEffect), (double)(this.field_1600 + (double)this.areaOfEffect), (double)(this.field_1601 + (double)this.areaOfEffect), (double)(this.field_1602 + (double)this.areaOfEffect)));
        for (class_54 player : playersNearby) {
            ((class_69)player).method_490(s);
        }
    }

    public boolean chatWithMe() {
        if (this.chatCount <= 0) {
            if (this.chatLog == 0) {
                this.chatLine("\u00a7cYou are certainly a brave soul to have entered this chamber.");
                this.chatLog = 1;
                this.chatCount = 100;
            } else if (this.chatLog == 1) {
                this.chatLine("\u00a7cBegone human, you serve no purpose here.");
                this.chatLog = 2;
                this.chatCount = 100;
            } else if (this.chatLog == 2) {
                this.chatLine("\u00a7cYour presence annoys me. Do you not fear my burning aura?");
                this.chatLog = 3;
                this.chatCount = 100;
            } else if (this.chatLog == 3) {
                this.chatLine("\u00a7cI have nothing to offer you, fool. Leave me at peace.");
                this.chatLog = 4;
                this.chatCount = 100;
            } else if (this.chatLog == 4) {
                this.chatLine("\u00a7cPerhaps you are ignorant. Do you wish to know who I am?");
                this.chatLog = 5;
                this.chatCount = 100;
            } else if (this.chatLog == 5) {
                this.chatLine("\u00a7cI am a sun spirit, embodiment of Aether's eternal daylight.");
                this.chatLine("\u00a7cAs long as I am alive, the sun will never set on this world.");
                this.chatLog = 6;
                this.chatCount = 100;
            } else if (this.chatLog == 6) {
                this.chatLine("\u00a7cMy body burns with the anger of a thousand beasts.");
                this.chatLine("\u00a7cNo man, hero, or villain can harm me. You are no exception.");
                this.chatLog = 7;
                this.chatCount = 100;
            } else if (this.chatLog == 7) {
                this.chatLine("\u00a7cYou wish to challenge the might of the sun? You are mad.");
                this.chatLine("\u00a7cDo not further insult me or you will feel my wrath.");
                this.chatLog = 8;
                this.chatCount = 100;
            } else if (this.chatLog == 8) {
                this.chatLine("\u00a7cThis is your final warning. Leave now, or prepare to burn.");
                this.chatLog = 9;
                this.chatCount = 100;
            } else {
                if (this.chatLog == 9) {
                    this.chatLine("\u00a76As you wish, your death will be slow and agonizing.");
                    this.chatLog = 10;
                    this.isBoss = true;
                    return true;
                }
                if (this.chatLog == 10 && this.target == null) {
                    this.chatLine("\u00a7cDid your previous death not satisfy your curiosity, human?");
                    this.chatLog = 9;
                    this.chatCount = 100;
                }
            }
        }
        return false;
    }

    public boolean method_1323(class_54 ep) {
        if (this.chatWithMe()) {
            this.rotary = 57.295772552490234 * Math.atan2(this.field_1600 - ep.field_1600, this.field_1602 - ep.field_1602);
            this.target = ep;
            this.setDoor(AetherBlocks.LockedDungeonStone.field_1915);
            return true;
        }
        return false;
    }

    public void method_1322(double d, double d1, double d2) {
    }

    public void method_925(class_57 entity, int i, double d, double d1) {
    }

    public boolean method_1355(class_57 e, int i) {
        if (e != null && e instanceof EntityFiroBall) {
            this.speedness = 0.5 - (double)this.field_1036 / 70.0 * 0.2;
            boolean flag = super.method_1355(e, i);
            if (flag) {
                this.hurtness = 15;
                this.field_1019 = "aether:stationapi/textures/mobs/firemonsterHurt.png";
                EntityFireMinion minion = new EntityFireMinion(this.field_1596);
                minion.method_1341(this.field_1600, this.field_1601, this.field_1602, this.field_1606, 0.0f);
                this.field_1596.method_210((class_57)minion);
                this.field_1596.method_210((class_57)minion);
                this.field_1596.method_210((class_57)minion);
                if (this.field_1036 <= 0) {
                    this.isBoss = false;
                    this.chatLine("\u00a7bSuch bitter cold... is this the feeling... of pain?");
                    this.setDoor(0);
                    this.unlockTreasure();
                }
            }
            return flag;
        }
        return false;
    }

    protected void method_933() {
        this.method_1327(new class_31(AetherItems.Key, 1, 2), 0.0f);
    }

    private void setDoor(int ID) {
        if (this.direction / 2 == 0) {
            for (int y = this.orgY - 1; y < this.orgY + 2; ++y) {
                for (int z = this.orgZ - 1; z < this.orgZ + 2; ++z) {
                    this.field_1596.method_154(this.orgX + (this.direction == 0 ? -11 : 11), y, z, ID, 2);
                }
            }
        } else {
            for (int y = this.orgY - 1; y < this.orgY + 2; ++y) {
                for (int z = this.orgX - 1; z < this.orgX + 2; ++z) {
                    this.field_1596.method_154(z, y, this.orgZ + (this.direction == 3 ? 11 : -11), ID, 2);
                }
            }
        }
    }

    private void unlockTreasure() {
        int y;
        int x;
        if (this.direction / 2 == 0) {
            for (x = this.orgY - 1; x < this.orgY + 2; ++x) {
                for (y = this.orgZ - 1; y < this.orgZ + 2; ++y) {
                    this.field_1596.method_200(this.orgX + (this.direction == 0 ? 11 : -11), x, y, 0);
                }
            }
        } else {
            for (x = this.orgY - 1; x < this.orgY + 2; ++x) {
                for (y = this.orgX - 1; y < this.orgX + 2; ++y) {
                    this.field_1596.method_200(y, x, this.orgZ + (this.direction == 3 ? -11 : 11), 0);
                }
            }
        }
        List playersNearby = this.field_1596.method_175(class_54.class, class_25.method_87((double)(this.field_1600 - (double)this.areaOfEffect), (double)(this.field_1601 - (double)this.areaOfEffect), (double)(this.field_1602 - (double)this.areaOfEffect), (double)(this.field_1600 + (double)this.areaOfEffect), (double)(this.field_1601 + (double)this.areaOfEffect), (double)(this.field_1602 + (double)this.areaOfEffect)));
        for (class_54 player : playersNearby) {
            AetherAchievements.giveAchievement(AetherAchievements.defeatGold, player);
        }
        for (x = this.orgX - 20; x < this.orgX + 20; ++x) {
            for (y = this.orgY - 3; y < this.orgY + 6; ++y) {
                for (int z = this.orgZ - 20; z < this.orgZ + 20; ++z) {
                    int id = this.field_1596.method_1776(x, y, z);
                    if (id == AetherBlocks.LockedDungeonStone.field_1915) {
                        this.field_1596.method_154(x, y, z, AetherBlocks.DungeonStone.field_1915, this.field_1596.method_1778(x, y, z));
                    }
                    if (id != AetherBlocks.LockedLightDungeonStone.field_1915) continue;
                    this.field_1596.method_154(x, y, z, AetherBlocks.LightDungeonStone.field_1915, this.field_1596.method_1778(x, y, z));
                }
            }
        }
    }

    public void setBoss(boolean boss) {
        this.isBoss = boss;
    }

    public boolean isBoss() {
        return this.isBoss;
    }

    public int getHP() {
        return this.field_1036;
    }

    public int getMaxHP() {
        return 50;
    }

    public String getName() {
        return this.bossName + ", the Sun Spirit";
    }

    public String getCustomTitle() {
        return super.getCustomTitle();
    }

    public Identifier getHandlerIdentifier() {
        return AetherEntities.MOD_ID.id("FireMonster");
    }
}

