/*
 * Decompiled with CFR 0.152.
 */
package com.matthewperiut.aether.poison;

import com.matthewperiut.aether.entity.living.EntityAechorPlant;
import com.matthewperiut.aether.entity.living.EntityCockatrice;
import com.matthewperiut.aether.entity.living.EntityFireMonster;
import com.matthewperiut.aether.entity.living.EntitySentry;
import com.matthewperiut.aether.entity.living.EntitySlider;
import com.matthewperiut.aether.entity.projectile.EntityFiroBall;
import com.matthewperiut.aether.entity.projectile.EntityHomeShot;
import com.matthewperiut.aether.entity.special.EntityMiniCloud;
import com.matthewperiut.aether.mixin.access.EntityAccessor;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_119;
import net.minecraft.class_169;
import net.minecraft.class_54;
import net.minecraft.class_57;
import net.minecraft.class_69;

public class PoisonControl {
    class_57 parent;
    boolean canPoison;
    public long clock;
    public int poisonTime = 0;
    public static final int poisonInterval = 50;
    public static final int poisonDmg = 1;
    public static final int maxPoisonTime = 500;
    public double rotDFac = 0.7853981633974483;
    public double rotD;
    public double rotTaper = 0.125;
    public double motTaper = 0.2;
    public double motD;
    public double motDFac = 0.1;

    public PoisonControl(class_57 parent) {
        this.parent = parent;
        this.canPoison = !(parent instanceof EntitySlider) && !(parent instanceof EntityMiniCloud) && !(parent instanceof EntitySentry) && !(parent instanceof EntityFireMonster) && !(parent instanceof EntityAechorPlant) && !(parent instanceof EntityFiroBall) && !(parent instanceof EntityCockatrice) && !(parent instanceof EntityHomeShot);
    }

    PoisonControl(class_57 parent, boolean canPoison) {
        this.parent = parent;
        this.canPoison = canPoison;
    }

    public void setCanPoison(Boolean canPoison) {
        this.canPoison = canPoison;
    }

    public boolean canPoison(class_57 entity) {
        return this.canPoison;
    }

    public void distractEntity() {
        double gauss = ((EntityAccessor)this.parent).getRand().nextGaussian();
        double newMotD = this.motDFac * gauss;
        this.motD = this.motTaper * newMotD + (1.0 - this.motTaper) * this.motD;
        this.parent.field_1603 += this.motD;
        this.parent.field_1605 += this.motD;
        double newRotD = this.rotDFac * gauss;
        this.rotD = this.rotTaper * newRotD + (1.0 - this.rotTaper) * this.rotD;
        this.parent.field_1606 = (float)((double)this.parent.field_1606 + this.rotD);
        this.parent.field_1607 = (float)((double)this.parent.field_1607 + this.rotD);
    }

    public boolean afflictPoison() {
        if (!this.canPoison) {
            return false;
        }
        if (this.poisonTime < 0) {
            return false;
        }
        this.poisonTime = 500;
        return true;
    }

    public boolean curePoison() {
        if (this.poisonTime == -500) {
            return false;
        }
        this.poisonTime = -500;
        return true;
    }

    public void onTick() {
        if (this.parent.field_1596.field_180) {
            return;
        }
        if (this.poisonTime < 0) {
            ++this.poisonTime;
        } else if (this.poisonTime != 0) {
            long time = this.parent.field_1596.method_256();
            int mod = this.poisonTime % 50;
            if (this.clock != time) {
                class_57 class_572;
                this.distractEntity();
                if (mod == 0) {
                    this.parent.method_1355(null, 1);
                }
                if (FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER && (class_572 = this.parent) instanceof class_54) {
                    class_54 player = (class_54)class_572;
                    PoisonControl.informClientMovement(player);
                }
                --this.poisonTime;
                this.clock = time;
            }
        }
        class_57 class_573 = this.parent;
        if (class_573 instanceof class_54) {
            class_54 player = (class_54)class_573;
            player.method_1331().method_1509(29, (Object)this.poisonTime);
        }
    }

    @Environment(value=EnvType.SERVER)
    private static void informClientMovement(class_54 player) {
        if (player instanceof class_69) {
            class_69 serverPlayer = (class_69)player;
            serverPlayer.field_255.method_835((class_169)new class_119(serverPlayer.field_1591, serverPlayer.field_1603, serverPlayer.field_1604, serverPlayer.field_1605));
        }
    }
}

