/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import api.hbm.block.ICrucibleAcceptor;
import com.hbm.blocks.ModBlocks;
import com.hbm.inventory.material.Mats;
import com.hbm.items.machine.ItemScraps;
import com.hbm.lib.ForgeDirection;
import com.hbm.tileentity.machine.TileEntityFoundryChannel;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FoundryChannel
extends BlockContainer
implements ICrucibleAcceptor {
    public static final PropertyInteger META = PropertyInteger.func_177719_a((String)"meta", (int)0, (int)15);

    public FoundryChannel(String s) {
        super(Material.field_151576_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)META, (Comparable)Integer.valueOf(0)));
        this.func_149663_c(s);
        this.setRegistryName(s);
        ModBlocks.ALL_BLOCKS.add((Block)this);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{META});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)META, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)META);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, world, pos, blockIn, fromPos);
        this.updateMeta(world, pos);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        this.updateMeta(worldIn, pos);
    }

    private void updateMeta(World world, BlockPos pos) {
        int meta = 0;
        if (this.canConnectTo(world, pos, EnumFacing.EAST)) {
            meta |= 1;
        }
        if (this.canConnectTo(world, pos, EnumFacing.WEST)) {
            meta |= 2;
        }
        if (this.canConnectTo(world, pos, EnumFacing.SOUTH)) {
            meta |= 4;
        }
        if (this.canConnectTo(world, pos, EnumFacing.NORTH)) {
            meta |= 8;
        }
        world.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)META, (Comparable)Integer.valueOf(meta)), 2);
    }

    public boolean canConnectTo(World world, BlockPos pos, EnumFacing direction) {
        BlockPos neighborPos = pos.func_177972_a(direction);
        IBlockState neighborState = world.func_180495_p(neighborPos);
        Block neighborBlock = neighborState.func_177230_c();
        if (neighborBlock == ModBlocks.foundry_outlet && neighborBlock.func_176201_c(neighborState) == direction.func_176745_a()) {
            return true;
        }
        return neighborBlock instanceof FoundryChannel || neighborBlock == ModBlocks.foundry_mold;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityFoundryChannel();
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entity, boolean isActualState) {
        int meta = (Integer)state.func_177229_b((IProperty)META);
        ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
        boxes.add(new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 0.5, 0.6875));
        if ((meta & 1) != 0) {
            boxes.add(new AxisAlignedBB(0.6875, 0.0, 0.3125, 1.0, 0.5, 0.6875));
        }
        if ((meta & 2) != 0) {
            boxes.add(new AxisAlignedBB(0.0, 0.0, 0.3125, 0.3125, 0.5, 0.6875));
        }
        if ((meta & 4) != 0) {
            boxes.add(new AxisAlignedBB(0.3125, 0.0, 0.6875, 0.6875, 0.5, 1.0));
        }
        if ((meta & 8) != 0) {
            boxes.add(new AxisAlignedBB(0.3125, 0.0, 0.0, 0.6875, 0.5, 0.3125));
        }
        for (AxisAlignedBB box : boxes) {
            if (!entityBox.func_72326_a(box.func_186670_a(pos))) continue;
            collidingBoxes.add(box.func_186670_a(pos));
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        int meta = (Integer)state.func_177229_b((IProperty)META);
        double minX = (meta & 2) != 0 ? 0.0 : 0.3125;
        double maxX = (meta & 1) != 0 ? 1.0 : 0.6875;
        double minZ = (meta & 8) != 0 ? 0.0 : 0.3125;
        double maxZ = (meta & 4) != 0 ? 1.0 : 0.6875;
        return new AxisAlignedBB(minX, 0.0, minZ, maxX, 0.5, maxZ);
    }

    @Override
    public boolean canAcceptPartialPour(World world, BlockPos pos, double dX, double dY, double dZ, ForgeDirection side, Mats.MaterialStack stack) {
        return ((ICrucibleAcceptor)world.func_175625_s(pos)).canAcceptPartialPour(world, pos, dX, dY, dZ, side, stack);
    }

    @Override
    public Mats.MaterialStack pour(World world, BlockPos pos, double dX, double dY, double dZ, ForgeDirection side, Mats.MaterialStack stack) {
        return ((ICrucibleAcceptor)world.func_175625_s(pos)).pour(world, pos, dX, dY, dZ, side, stack);
    }

    @Override
    public boolean canAcceptPartialFlow(World world, BlockPos pos, ForgeDirection side, Mats.MaterialStack stack) {
        return ((ICrucibleAcceptor)world.func_175625_s(pos)).canAcceptPartialFlow(world, pos, side, stack);
    }

    @Override
    public Mats.MaterialStack flow(World world, BlockPos pos, ForgeDirection side, Mats.MaterialStack stack) {
        return ((ICrucibleAcceptor)world.func_175625_s(pos)).flow(world, pos, side, stack);
    }

    public boolean canConnectTo(IBlockAccess world, int x, int y, int z, ForgeDirection dir) {
        if (dir == ForgeDirection.UP || dir == ForgeDirection.DOWN || dir == ForgeDirection.UNKNOWN) {
            return false;
        }
        BlockPos neighborPos = new BlockPos(x + dir.offsetX, y, z + dir.offsetZ);
        IBlockState neighborState = world.func_180495_p(neighborPos);
        Block neighborBlock = neighborState.func_177230_c();
        if (neighborBlock instanceof FoundryChannel) {
            int neighborMeta = (Integer)neighborState.func_177229_b((IProperty)META);
            return (neighborMeta & 1 << dir.getOpposite().ordinal()) != 0;
        }
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntityFoundryChannel cast = (TileEntityFoundryChannel)world.func_175625_s(pos);
        if (!player.func_184586_b(hand).func_190926_b() && player.func_184586_b(hand).func_77973_b() instanceof ItemTool && ((ItemTool)player.func_184586_b(hand).func_77973_b()).getToolClasses(player.func_184586_b(hand)).contains("shovel")) {
            if (cast.amount > 0) {
                ItemStack scrap = ItemScraps.create(new Mats.MaterialStack(cast.type, cast.amount));
                if (!player.field_71071_by.func_70441_a(scrap)) {
                    EntityItem item = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + this.func_185496_a((IBlockState)state, (IBlockAccess)world, (BlockPos)pos).field_72337_e, (double)pos.func_177952_p() + 0.5, scrap);
                    world.func_72838_d((Entity)item);
                } else {
                    player.field_71069_bz.func_75142_b();
                }
                cast.amount = 0;
                cast.type = null;
                cast.propagateMaterial(null);
                cast.func_70296_d();
                world.markAndNotifyBlock(pos, world.func_175726_f(pos), state, state, 2);
            }
            return true;
        }
        return false;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntityFoundryChannel channel = (TileEntityFoundryChannel)world.func_175625_s(pos);
        if (channel.amount > 0) {
            ItemStack scrap = ItemScraps.create(new Mats.MaterialStack(channel.type, channel.amount));
            EntityItem item = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + this.func_185496_a((IBlockState)state, (IBlockAccess)world, (BlockPos)pos).field_72337_e, (double)pos.func_177952_p() + 0.5, scrap);
            world.func_72838_d((Entity)item);
            channel.amount = 0;
        }
        super.func_180663_b(world, pos, state);
    }
}

