/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.network;

import api.hbm.block.IConveyorBelt;
import api.hbm.block.IConveyorItem;
import api.hbm.block.IConveyorPackage;
import api.hbm.block.IEnterableBlock;
import com.hbm.blocks.BlockDummyable;
import com.hbm.blocks.ModBlocks;
import com.hbm.entity.item.EntityMovingItem;
import com.hbm.entity.item.EntityMovingPackage;
import com.hbm.handler.MultiblockHandlerXR;
import com.hbm.lib.ForgeDirection;
import com.hbm.tileentity.TileEntityProxyCombo;
import com.hbm.tileentity.network.TileEntityCraneSplitter;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class CraneSplitter
extends BlockDummyable
implements IConveyorBelt,
IEnterableBlock {
    public CraneSplitter(Material materialIn, String s) {
        super(materialIn, s);
    }

    @Override
    public int[] getDimensions() {
        return new int[]{0, 0, 0, 0, 1, 0};
    }

    @Override
    public int getOffset() {
        return 0;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        if (meta >= 12) {
            return new TileEntityCraneSplitter();
        }
        if (meta >= 6) {
            return new TileEntityProxyCombo(false, true, true);
        }
        return null;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)ModBlocks.crane_splitter);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(ModBlocks.crane_splitter);
    }

    private EnumFacing getCustomMap(int meta) {
        switch (meta) {
            case 4: {
                return EnumFacing.NORTH;
            }
            case 2: {
                return EnumFacing.EAST;
            }
            case 5: {
                return EnumFacing.SOUTH;
            }
            case 3: {
                return EnumFacing.WEST;
            }
            case 13: {
                return EnumFacing.NORTH;
            }
            case 14: {
                return EnumFacing.EAST;
            }
            case 12: {
                return EnumFacing.SOUTH;
            }
            case 15: {
                return EnumFacing.WEST;
            }
        }
        return EnumFacing.NORTH;
    }

    @Override
    public boolean canItemEnter(World world, int x, int y, int z, EnumFacing dir, IConveyorItem entity) {
        return this.getTravelDirection(world, new BlockPos(x, y, z), null) == dir;
    }

    public EnumFacing getTravelDirection(World world, BlockPos pos, Vec3d itemPos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        int meta = block.func_176201_c(world.func_180495_p(pos));
        return this.getCustomMap(meta).func_176734_d();
    }

    @Override
    public boolean canItemStay(World world, int x, int y, int z, Vec3d itemPos) {
        return true;
    }

    @Override
    public boolean canPackageEnter(World world, int x, int y, int z, EnumFacing dir, IConveyorPackage entity) {
        return true;
    }

    @Override
    public void onPackageEnter(World world, int x, int y, int z, EnumFacing dir, IConveyorPackage entity) {
        if (entity == null) {
            return;
        }
        BlockPos pos = new BlockPos(x, y, z);
        int[] core = this.findCore((IBlockAccess)world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        if (core == null) {
            return;
        }
        pos = new BlockPos(core[0], core[1], core[2]);
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof TileEntityCraneSplitter)) {
            return;
        }
        TileEntityCraneSplitter splitter = (TileEntityCraneSplitter)tile;
        boolean pos1 = splitter.getPosition();
        EnumFacing rot = this.getCustomMap(splitter.func_145832_p()).func_176746_e().func_176746_e().func_176746_e();
        if (pos1) {
            this.spawnMovingBox(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), entity.getItemStacks());
        } else {
            this.spawnMovingBox(world, pos.func_177958_n() + rot.func_82601_c(), pos.func_177956_o(), pos.func_177952_p() + rot.func_82599_e(), entity.getItemStacks());
        }
        splitter.setPosition(!pos1);
    }

    @Override
    public Vec3d getTravelLocation(World world, int x, int y, int z, Vec3d itemPos, double speed) {
        BlockPos pos = new BlockPos(x, y, z);
        EnumFacing dir = this.getTravelDirection(world, pos, itemPos);
        Vec3d snap = this.getClosestSnappingPosition(world, pos, itemPos);
        Vec3d dest = new Vec3d(snap.field_72450_a - (double)dir.func_82601_c() * speed, snap.field_72448_b - (double)dir.func_96559_d() * speed, snap.field_72449_c - (double)dir.func_82599_e() * speed);
        Vec3d motion = new Vec3d(dest.field_72450_a - itemPos.field_72450_a, dest.field_72448_b - itemPos.field_72448_b, dest.field_72449_c - itemPos.field_72449_c);
        double len = motion.func_72433_c();
        return new Vec3d(itemPos.field_72450_a + motion.field_72450_a / len * speed, itemPos.field_72448_b + motion.field_72448_b / len * speed, itemPos.field_72449_c + motion.field_72449_c / len * speed);
    }

    @Override
    public Vec3d getClosestSnappingPosition(World world, BlockPos pos, Vec3d itemPos) {
        EnumFacing dir = this.getTravelDirection(world, pos, itemPos);
        double posX = MathHelper.func_151237_a((double)itemPos.field_72450_a, (double)pos.func_177958_n(), (double)(pos.func_177958_n() + 1));
        double posZ = MathHelper.func_151237_a((double)itemPos.field_72449_c, (double)pos.func_177952_p(), (double)(pos.func_177952_p() + 1));
        double x = (double)pos.func_177958_n() + 0.5;
        double z = (double)pos.func_177952_p() + 0.5;
        double y = (double)pos.func_177956_o() + 0.25;
        if (dir.func_176740_k() == EnumFacing.Axis.X) {
            x = posX;
        } else if (dir.func_176740_k() == EnumFacing.Axis.Z) {
            z = posZ;
        }
        return new Vec3d(x, y, z);
    }

    @Override
    public void onItemEnter(World world, int x, int y, int z, EnumFacing dir, IConveyorItem entity) {
        if (entity == null || entity.getItemStack() == ItemStack.field_190927_a || entity.getItemStack().func_190916_E() <= 0) {
            return;
        }
        BlockPos pos = new BlockPos(x, y, z);
        int[] core = this.findCore((IBlockAccess)world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        if (core == null) {
            return;
        }
        pos = new BlockPos(core[0], core[1], core[2]);
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof TileEntityCraneSplitter)) {
            return;
        }
        TileEntityCraneSplitter splitter = (TileEntityCraneSplitter)tile;
        boolean pos1 = splitter.getPosition();
        ItemStack stack = entity.getItemStack();
        EnumFacing rot = this.getCustomMap(splitter.func_145832_p()).func_176746_e().func_176746_e().func_176746_e();
        if (stack.func_190916_E() % 2 == 0) {
            stack.func_190920_e(stack.func_190916_E() >> 1);
            this.spawnMovingItem(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), stack.func_77946_l());
            this.spawnMovingItem(world, pos.func_177958_n() + rot.func_82601_c(), pos.func_177956_o(), pos.func_177952_p() + rot.func_82599_e(), stack.func_77946_l());
        } else {
            int baseSize = stack.func_190916_E() >> 1;
            if (baseSize == 0) {
                if (pos1) {
                    this.spawnMovingItem(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), stack.func_77946_l());
                } else {
                    this.spawnMovingItem(world, pos.func_177958_n() + rot.func_82601_c(), pos.func_177956_o(), pos.func_177952_p() + rot.func_82599_e(), stack.func_77946_l());
                }
            } else {
                stack.func_190920_e(baseSize + (pos1 ? 0 : 1));
                this.spawnMovingItem(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), stack.func_77946_l());
                stack.func_190920_e(baseSize + (pos1 ? 1 : 0));
                this.spawnMovingItem(world, pos.func_177958_n() + rot.func_82601_c(), pos.func_177956_o(), pos.func_177952_p() + rot.func_82599_e(), stack.func_77946_l());
            }
            splitter.setPosition(!pos1);
        }
    }

    private void spawnMovingItem(World worldIn, int x, int y, int z, ItemStack stack) {
        BlockPos pos1 = new BlockPos(x, y, z);
        int xCoord = pos1.func_177958_n();
        int yCoord = pos1.func_177956_o();
        int zCoord = pos1.func_177952_p();
        if (stack.func_190916_E() <= 0) {
            return;
        }
        EntityMovingItem moving = new EntityMovingItem(worldIn);
        Vec3d itemPos = new Vec3d((double)xCoord + 0.5, (double)yCoord + 0.5, (double)zCoord + 0.5);
        Vec3d snap = this.getClosestSnappingPosition(worldIn, pos1, itemPos);
        moving.func_70107_b(snap.field_72450_a, snap.field_72448_b, snap.field_72449_c);
        moving.setItemStack(stack);
        worldIn.func_72838_d((Entity)moving);
    }

    private void spawnMovingBox(World worldIn, int x, int y, int z, ItemStack[] stacks) {
        BlockPos pos1 = new BlockPos(x, y, z);
        int xCoord = pos1.func_177958_n();
        int yCoord = pos1.func_177956_o();
        int zCoord = pos1.func_177952_p();
        EntityMovingPackage moving = new EntityMovingPackage(worldIn);
        Vec3d itemPos = new Vec3d((double)xCoord + 0.5, (double)yCoord + 0.5, (double)zCoord + 0.5);
        Vec3d snap = this.getClosestSnappingPosition(worldIn, pos1, itemPos);
        moving.func_70107_b(snap.field_72450_a, snap.field_72448_b, snap.field_72449_c);
        moving.setItemStacks(stacks);
        worldIn.func_72838_d((Entity)moving);
    }

    @Override
    protected boolean checkRequirement(World world, int x, int y, int z, ForgeDirection dir, int o) {
        return super.checkRequirement(world, x, y, z, dir, o);
    }

    @Override
    public void fillSpace(World world, int x, int y, int z, ForgeDirection dir, int o) {
        MultiblockHandlerXR.fillSpace(world, x, y, z, this.getDimensions(), (Block)this, dir);
    }
}

