/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.logic;

import com.hbm.config.BombConfig;
import com.hbm.config.CompatibilityConfig;
import com.hbm.config.GeneralConfig;
import com.hbm.entity.effect.EntityFalloutRain;
import com.hbm.entity.effect.EntityFalloutUnderGround;
import com.hbm.entity.logic.EntityChunky;
import com.hbm.entity.mob.EntityGlowingOne;
import com.hbm.explosion.ExplosionNukeRayBatched;
import com.hbm.main.AdvancementManager;
import com.hbm.main.MainRegistry;
import com.hbm.util.ContaminationUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeBeach;
import net.minecraft.world.biome.BiomeJungle;
import net.minecraft.world.biome.BiomeOcean;
import net.minecraft.world.biome.BiomeRiver;
import net.minecraft.world.biome.BiomeSwamp;
import org.apache.logging.log4j.Level;

public class EntityNukeExplosionMK5
extends EntityChunky {
    public int strength;
    public int radius;
    public boolean mute = false;
    public boolean spawnFire = false;
    private boolean fallingStarted = false;
    public boolean fallout = true;
    private boolean floodPlease = false;
    private int falloutAdd = 0;
    ExplosionNukeRayBatched explosion;
    EntityFalloutRain falloutRain;
    public static final double shockSpeed = 2.0;

    public EntityNukeExplosionMK5(World world) {
        super(world);
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.strength == 0 || !CompatibilityConfig.isWarDim(this.field_70170_p)) {
            this.func_70106_y();
            return;
        }
        float rads = 0.0f;
        if (this.fallout && this.falloutRain == null) {
            rads = (float)Math.min(1.0E7, Math.pow(this.radius, 3.0) * (double)((float)Math.pow(0.5, 2.0 * (double)this.field_70173_aa / (double)this.radius)) + (double)this.strength);
            if (this.field_70173_aa == 1) {
                EntityGlowingOne.convertInRadiusToGlow(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, (double)this.radius * 1.5);
                if (this.radius > 60) {
                    for (EntityPlayer player : this.field_70170_p.func_72872_a(EntityPlayer.class, new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t, this.field_70163_u, this.field_70161_v).func_72314_b((double)(this.radius * 2), (double)(this.radius * 2), (double)(this.radius * 2)))) {
                        AdvancementManager.grantAchievement(player, AdvancementManager.progress_nuke);
                    }
                }
            }
        }
        if (this.field_70173_aa < 2400) {
            float fire = (float)(this.fallout ? 10.0 : 0.5 * Math.pow(this.radius + 10, 3.0) * Math.pow(0.5, 0.5 * (double)this.field_70173_aa / (double)this.radius));
            float blast = (float)Math.pow(this.radius + 10, 3.0) * 0.1f;
            ContaminationUtil.radiate(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, Math.min(1000, this.radius * 2), rads, 0.0f, fire, blast, (double)this.field_70173_aa * 2.0);
        }
        if (!this.mute) {
            if (this.radius > 30) {
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187754_de, SoundCategory.AMBIENT, Math.min(1.0f, (float)this.field_70173_aa / 200.0f) * (float)this.radius * 0.05f, 0.8f + this.field_70146_Z.nextFloat() * 0.2f);
            } else {
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187539_bB, SoundCategory.AMBIENT, Math.min(1.0f, (float)this.field_70173_aa / 100.0f) * Math.max(2.0f, (float)this.radius * 0.1f), 0.8f + this.field_70146_Z.nextFloat() * 0.2f);
            }
        }
        if (this.explosion == null) {
            this.explosion = new ExplosionNukeRayBatched(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.strength, this.radius, this.floodPlease);
        }
        if (!this.explosion.isAusf3Complete) {
            this.explosion.collectTip(BombConfig.mk5);
        } else if (!this.explosion.perChunk.isEmpty()) {
            this.explosion.processChunk(BombConfig.mk5);
        } else if (!this.fallingStarted) {
            if (this.fallout) {
                EntityFalloutUnderGround falloutBall = new EntityFalloutUnderGround(this.field_70170_p);
                falloutBall.field_70165_t = this.field_70165_t;
                falloutBall.field_70163_u = this.field_70163_u;
                falloutBall.field_70161_v = this.field_70161_v;
                falloutBall.setScale((int)((float)this.radius * ((float)BombConfig.falloutRange / 100.0f) + (float)this.falloutAdd));
                falloutBall.falloutRainDoFallout = this.fallout && !this.explosion.isContained;
                falloutBall.falloutRainDoFlood = this.floodPlease;
                falloutBall.falloutRainRadius1 = (int)(((float)this.radius * 2.5f + (float)this.falloutAdd) * (float)BombConfig.falloutRange * 0.01f);
                falloutBall.falloutRainRadius2 = this.radius + 4;
                this.field_70170_p.func_72838_d((Entity)falloutBall);
            } else {
                EntityFalloutRain falloutRain = new EntityFalloutRain(this.field_70170_p);
                falloutRain.doFallout = false;
                falloutRain.doFlood = this.floodPlease;
                falloutRain.field_70165_t = this.field_70165_t;
                falloutRain.field_70163_u = this.field_70163_u;
                falloutRain.field_70161_v = this.field_70161_v;
                falloutRain.setScale((int)(((float)this.radius * 2.5f + (float)this.falloutAdd) * (float)BombConfig.falloutRange * 0.01f), this.radius + 4);
                this.field_70170_p.func_72838_d((Entity)falloutRain);
            }
            this.fallingStarted = true;
        } else if ((double)this.field_70173_aa * 2.0 > 160.0) {
            this.func_70106_y();
        }
    }

    public static boolean isWet(World world, BlockPos pos) {
        Biome b = world.func_180494_b(pos);
        return b.func_150561_m() == Biome.TempCategory.OCEAN || b.func_76736_e() || b instanceof BiomeOcean || b instanceof BiomeBeach || b instanceof BiomeRiver || b instanceof BiomeJungle || b instanceof BiomeSwamp;
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        this.radius = nbt.func_74762_e("radius");
        this.strength = nbt.func_74762_e("strength");
        this.falloutAdd = nbt.func_74762_e("falloutAdd");
        this.fallout = nbt.func_74767_n("fallout");
        this.floodPlease = nbt.func_74767_n("floodPlease");
        this.spawnFire = nbt.func_74767_n("spawnFire");
        this.mute = nbt.func_74767_n("mute");
        if (nbt.func_74764_b("fs")) {
            this.fallingStarted = nbt.func_74767_n("fs");
        }
        if (this.explosion == null) {
            this.explosion = new ExplosionNukeRayBatched(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.strength, this.radius, this.floodPlease);
        }
        this.explosion.readEntityFromNBT(nbt);
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74768_a("radius", this.radius);
        nbt.func_74768_a("strength", this.strength);
        nbt.func_74768_a("falloutAdd", this.falloutAdd);
        nbt.func_74757_a("fallout", this.fallout);
        nbt.func_74757_a("floodPlease", this.floodPlease);
        nbt.func_74757_a("spawnFire", this.spawnFire);
        nbt.func_74757_a("mute", this.mute);
        nbt.func_74757_a("fs", this.fallingStarted);
        if (this.explosion != null) {
            this.explosion.writeEntityToNBT(nbt);
        }
    }

    public static EntityNukeExplosionMK5 statFac(World world, int r, double x, double y, double z) {
        if (GeneralConfig.enableExtendedLogging && !world.field_72995_K) {
            MainRegistry.logger.log(Level.INFO, "[NUKE] Initialized explosion at " + x + " / " + y + " / " + z + " with radius " + r + "!");
        }
        if (r == 0) {
            r = 25;
        }
        EntityNukeExplosionMK5 mk5 = new EntityNukeExplosionMK5(world);
        mk5.strength = r << 1;
        mk5.radius = r;
        mk5.func_70107_b(x, y, z);
        mk5.floodPlease = EntityNukeExplosionMK5.isWet(world, new BlockPos(x, y, z));
        if (BombConfig.disableNuclear) {
            mk5.fallout = false;
        }
        return mk5;
    }

    public static EntityNukeExplosionMK5 statFacNoRad(World world, int r, double x, double y, double z) {
        EntityNukeExplosionMK5 mk5 = EntityNukeExplosionMK5.statFac(world, r, x, y, z);
        mk5.fallout = false;
        return mk5;
    }

    public static EntityNukeExplosionMK5 statFacNoRadFire(World world, int r, double x, double y, double z) {
        EntityNukeExplosionMK5 mk5 = EntityNukeExplosionMK5.statFac(world, r, x, y, z);
        mk5.fallout = false;
        mk5.spawnFire = true;
        return mk5;
    }

    public EntityNukeExplosionMK5 moreFallout(int fallout) {
        this.falloutAdd = fallout;
        return this;
    }

    public EntityNukeExplosionMK5 mute() {
        this.mute = true;
        return this;
    }
}

