/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.mob.botprime;

import com.google.common.base.Predicate;
import com.hbm.entity.mob.botprime.EntityBurrowingNT;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;

public abstract class EntityWormBaseNT
extends EntityBurrowingNT {
    public int aggroCooldown = 0;
    public int courseChangeCooldown = 0;
    public double waypointX;
    public double waypointY;
    public double waypointZ;
    protected Entity targetedEntity = null;
    protected boolean canFly = false;
    protected int dmgCooldown = 0;
    protected boolean wasNearGround;
    protected BlockPos spawnPoint = new BlockPos(0, 0, 0);
    protected double attackRange;
    protected double maxSpeed;
    protected double fallSpeed;
    protected double rangeForParts;
    protected EntityLivingBase followed;
    protected int surfaceY;
    private int headID;
    private int partNum;
    protected boolean didCheck;
    protected double bodySpeed;
    protected double maxBodySpeed;
    protected double segmentDistance;
    protected double knockbackDivider;
    public static final Predicate<Entity> wormSelector = target -> target instanceof EntityWormBaseNT;

    public EntityWormBaseNT(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
        this.surfaceY = 60;
    }

    public int getPartNumber() {
        return this.partNum;
    }

    public void setPartNumber(int num) {
        this.partNum = num;
    }

    public Entity getHead() {
        return this.field_70170_p.func_73045_a(this.headID);
    }

    public int getHeadID() {
        return this.headID;
    }

    public void setHeadID(int id) {
        this.headID = id;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source) || source == DamageSource.field_76369_e || source == DamageSource.field_76368_d || source == DamageSource.field_191291_g || source.func_76364_f() instanceof EntityWormBaseNT && ((EntityWormBaseNT)source.func_76364_f()).getHeadID() == this.getHeadID()) {
            return false;
        }
        this.func_130011_c(source.func_76346_g());
        if (this.getIsHead()) {
            return super.func_70097_a(source, amount);
        }
        Entity head = this.targetedEntity;
        if (head != null) {
            return head.func_70097_a(source, amount);
        }
        return super.func_70097_a(source, amount);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
        if (this.targetedEntity != null && this.targetedEntity.field_70128_L) {
            this.targetedEntity = null;
        }
        if (this.field_70163_u < -10.0) {
            this.func_70634_a(this.field_70165_t, 128.0, this.field_70161_v);
            this.field_70181_x = 0.0;
        } else if (this.field_70163_u < 3.0) {
            this.field_70181_x = 0.3;
        }
        if (this.field_70173_aa % 5 == 0) {
            this.attackEntitiesInList(this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b(0.5, 0.5, 0.5)));
        }
    }

    protected void attackEntitiesInList(List<Entity> targets) {
        for (Entity target : targets) {
            if (!(target instanceof EntityLivingBase) || !this.func_70686_a(((EntityLivingBase)target).getClass()) || target instanceof EntityWormBaseNT && ((EntityWormBaseNT)target).getHeadID() == this.getHeadID()) continue;
            this.func_70652_k(target);
        }
    }

    public boolean func_70686_a(Class<? extends EntityLivingBase> cls) {
        return true;
    }

    public boolean func_70652_k(Entity target) {
        boolean var2 = target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), this.getAttackStrength(target));
        if (var2) {
            this.field_70708_bq = 0;
            double tx = (this.func_174813_aQ().field_72340_a + this.func_174813_aQ().field_72336_d) / 2.0;
            double tz = (this.func_174813_aQ().field_72339_c + this.func_174813_aQ().field_72334_f) / 2.0;
            double ty = (this.func_174813_aQ().field_72338_b + this.func_174813_aQ().field_72337_e) / 2.0;
            double deltaX = target.field_70165_t - tx;
            double deltaZ = target.field_70161_v - tz;
            double deltaY = target.field_70163_u - ty;
            double knockback = this.knockbackDivider * (deltaX * deltaX + deltaZ * deltaZ + deltaY * deltaY + 0.1);
            target.func_70024_g(deltaX / knockback, deltaY / knockback, deltaZ / knockback);
        }
        return var2;
    }

    public abstract float getAttackStrength(Entity var1);

    public void func_70024_g(double x, double y, double z) {
    }

    public void func_70625_a(Entity entityIn, float maxYawIncrease, float maxPitchIncrease) {
    }

    protected boolean isCourseTraversable() {
        return this.canFly || this.entInsideOpaqueBlock();
    }

    protected boolean entInsideOpaqueBlock() {
        for (int i = 0; i < 8; ++i) {
            int l;
            int k;
            float f = ((float)((i >> 0) % 2) - 0.5f) * this.field_70130_N * 0.8f;
            float f1 = ((float)((i >> 1) % 2) - 0.5f) * 0.1f;
            float f2 = ((float)((i >> 2) % 2) - 0.5f) * this.field_70130_N * 0.8f;
            int j = MathHelper.func_76128_c((double)(this.field_70165_t + (double)f));
            if (!this.field_70170_p.func_180495_p(new BlockPos(j, k = MathHelper.func_76128_c((double)(this.field_70163_u + (double)this.func_70047_e() + (double)f1)), l = MathHelper.func_76128_c((double)(this.field_70161_v + (double)f2)))).func_185915_l()) continue;
            return true;
        }
        return false;
    }

    protected float func_70599_aP() {
        return 5.0f;
    }

    public void func_70106_y() {
        this.func_184185_a(this.func_184615_bR(), this.func_70599_aP(), this.func_70647_i());
        super.func_70106_y();
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("wormID", this.getHeadID());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setHeadID(compound.func_74762_e("wormID"));
    }
}

