/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.explosion;

import com.hbm.config.BombConfig;
import com.hbm.config.CompatibilityConfig;
import com.hbm.entity.effect.EntityFalloutRain;
import com.hbm.render.amlfrom1710.Vec3;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class ExplosionNukeRayBatched {
    public HashMap<ChunkPos, BitSet> perChunk = new HashMap();
    public List<ChunkPos> orderedChunks = new ArrayList<ChunkPos>();
    private final CoordComparator comparator = new CoordComparator();
    public boolean isContained = true;
    double posX;
    double posY;
    double posZ;
    World world;
    int strength;
    int radius;
    int gspNumMax;
    int gspNum;
    double gspX;
    double gspY;
    private static final int maxY = 255;
    private static final int minY = 0;
    public boolean ignoreWater = false;
    public boolean isAusf3Complete = false;
    public int rayCheckInterval = 100;
    public int waterLevel;
    int age = 0;
    BitSet hitArray;
    ChunkPos chunk;
    boolean needsNewHitArray = true;
    int index = 0;

    public ExplosionNukeRayBatched(World world, double x, double y, double z, int strength, int radius, boolean ignoreWater) {
        this.world = world;
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.strength = strength;
        this.radius = radius;
        this.gspNumMax = (int)(7.853981633974483 * Math.pow(this.strength, 2.0));
        this.gspNum = 1;
        this.gspX = Math.PI;
        this.gspY = 0.0;
        this.rayCheckInterval = 10000 / radius;
        this.ignoreWater = ignoreWater;
        this.waterLevel = EntityFalloutRain.getInt(CompatibilityConfig.fillCraterWithWater.get(world.field_73011_w.getDimension()));
        if (this.waterLevel == 0) {
            this.waterLevel = world.func_181545_F();
        } else if (this.waterLevel < 0 && this.waterLevel > -world.func_181545_F()) {
            this.waterLevel = world.func_181545_F() - this.waterLevel;
        }
    }

    private void generateGspUp() {
        if (this.gspNum < this.gspNumMax) {
            int k = this.gspNum + 1;
            double hk = -1.0 + 2.0 * ((double)k - 1.0) / ((double)this.gspNumMax - 1.0);
            this.gspX = Math.acos(hk);
            double prev_lon = this.gspY;
            double lon = prev_lon + 3.6 / Math.sqrt(this.gspNumMax) / Math.sqrt(1.0 - hk * hk);
            this.gspY = lon % (Math.PI * 2);
        } else {
            this.gspX = 0.0;
            this.gspY = 0.0;
        }
        ++this.gspNum;
    }

    private Vec3 getSpherical2cartesian() {
        double dx = Math.sin(this.gspX) * Math.cos(this.gspY);
        double dy = Math.sin(this.gspX) * Math.sin(this.gspY);
        double dz = Math.cos(this.gspX);
        return Vec3.createVectorHelper(dx, dy, dz);
    }

    public void addPos(int x, int y, int z) {
        this.chunk = new ChunkPos(x >> 4, z >> 4);
        BitSet hitPositions = this.perChunk.computeIfAbsent(this.chunk, k -> new BitSet(65536));
        hitPositions.set((255 - y << 8) + (x - this.chunk.func_180334_c() << 4) + (z - this.chunk.func_180333_d()));
    }

    public boolean waterCheck(Block b, int y) {
        if (b == Blocks.field_150350_a) {
            return false;
        }
        if (this.ignoreWater && y < this.waterLevel) {
            return b != Blocks.field_150355_j && b != Blocks.field_150358_i;
        }
        return true;
    }

    public void collectTip(int time) {
        if (!CompatibilityConfig.isWarDim(this.world)) {
            this.isAusf3Complete = true;
            return;
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        long raysProcessed = 0L;
        long start = System.currentTimeMillis();
        ++this.age;
        if (this.age == 1200) {
            this.age = 0;
        }
        while (this.gspNumMax >= this.gspNum) {
            Vec3 vec = this.getSpherical2cartesian();
            int radius = (int)((double)this.radius);
            float rayStrength = (float)this.strength * 0.3f;
            for (int r = 0; r < radius + 1; ++r) {
                int iY = (int)Math.floor(this.posY + vec.yCoord * (double)r);
                if (iY < 0 || iY > 255) {
                    this.isContained = false;
                    break;
                }
                int iX = (int)Math.floor(this.posX + vec.xCoord * (double)r);
                int iZ = (int)Math.floor(this.posZ + vec.zCoord * (double)r);
                pos.func_181079_c(iX, iY, iZ);
                IBlockState blockState = this.world.func_180495_p((BlockPos)pos);
                Block b = blockState.func_177230_c();
                if (b.func_149638_a(null) >= 2000000.0f || !((rayStrength -= (float)(Math.pow(ExplosionNukeRayBatched.getNukeResistance(blockState, b) + 1.0f, 3.0 * (double)r / (double)radius) - 1.0)) > 0.0f)) break;
                if (this.waterCheck(b, iY)) {
                    this.addPos(iX, iY, iZ);
                }
                if (r < radius) continue;
                this.isContained = false;
            }
            this.generateGspUp();
            if (++raysProcessed % (long)this.rayCheckInterval != 0L || System.currentTimeMillis() + 1L <= start + (long)time) continue;
            return;
        }
        this.orderedChunks.addAll(this.perChunk.keySet());
        this.orderedChunks.sort(this.comparator);
        this.isAusf3Complete = true;
    }

    public static float getNukeResistance(IBlockState blockState, Block b) {
        if (blockState.func_185904_a().func_76224_d()) {
            return 0.1f;
        }
        if (b == Blocks.field_150322_A) {
            return 4.0f;
        }
        if (b == Blocks.field_150343_Z) {
            return 18.0f;
        }
        return b.func_149638_a(null);
    }

    public void processChunk(int time) {
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() < start + (long)time) {
            this.processChunkBlocks(start, time);
        }
    }

    public void processChunkBlocks(long start, int time) {
        if (!CompatibilityConfig.isWarDim(this.world)) {
            this.perChunk.clear();
        }
        if (this.perChunk.isEmpty()) {
            return;
        }
        if (this.needsNewHitArray) {
            this.chunk = this.orderedChunks.get(0);
            this.hitArray = this.perChunk.get(this.chunk);
            this.index = this.hitArray.nextSetBit(0);
            this.needsNewHitArray = false;
        }
        int chunkX = this.chunk.func_180334_c();
        int chunkZ = this.chunk.func_180333_d();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int blocksRemoved = 0;
        while (this.index > -1) {
            pos.func_181079_c((this.index >> 4) % 16 + chunkX, 255 - (this.index >> 8), this.index % 16 + chunkZ);
            this.world.func_175698_g((BlockPos)pos);
            this.index = this.hitArray.nextSetBit(this.index + 1);
            if (++blocksRemoved % 256 != 0 || System.currentTimeMillis() + 1L <= start + (long)time) continue;
        }
        if (this.index < 0) {
            this.perChunk.remove(this.chunk);
            this.orderedChunks.remove(0);
            this.needsNewHitArray = true;
        }
    }

    public void readEntityFromNBT(NBTTagCompound nbt) {
        this.radius = nbt.func_74762_e("radius");
        this.strength = nbt.func_74762_e("strength");
        this.posX = nbt.func_74769_h("posX");
        this.posY = nbt.func_74769_h("posY");
        this.posZ = nbt.func_74769_h("posZ");
        this.gspNumMax = (int)(7.853981633974483 * Math.pow(this.strength, 2.0));
        this.rayCheckInterval = 10000 / this.radius;
        if (nbt.func_74764_b("igW")) {
            this.ignoreWater = nbt.func_74767_n("igW");
        }
        this.waterLevel = EntityFalloutRain.getInt(CompatibilityConfig.fillCraterWithWater.get(this.world.field_73011_w.getDimension()));
        if (this.waterLevel == 0) {
            this.waterLevel = this.world.func_181545_F();
        } else if (this.waterLevel < 0 && this.waterLevel > -this.world.func_181545_F()) {
            this.waterLevel = this.world.func_181545_F() - this.waterLevel;
        }
        if (nbt.func_74764_b("gspNum")) {
            this.gspNum = nbt.func_74762_e("gspNum");
            this.isAusf3Complete = nbt.func_74767_n("f3");
            this.isContained = nbt.func_74767_n("isContained");
            int i = 0;
            while (nbt.func_74764_b("chunks" + i)) {
                NBTTagCompound c = (NBTTagCompound)nbt.func_74781_a("chunks" + i);
                this.perChunk.put(new ChunkPos(c.func_74762_e("cX"), c.func_74762_e("cZ")), BitSet.valueOf(ExplosionNukeRayBatched.getLongArray((NBTTagLongArray)c.func_74781_a("cB"))));
                ++i;
            }
            if (this.isAusf3Complete) {
                this.orderedChunks.addAll(this.perChunk.keySet());
                this.orderedChunks.sort(this.comparator);
            }
        }
    }

    public void writeEntityToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("radius", this.radius);
        nbt.func_74768_a("strength", this.strength);
        nbt.func_74780_a("posX", this.posX);
        nbt.func_74780_a("posY", this.posY);
        nbt.func_74780_a("posZ", this.posZ);
        nbt.func_74757_a("igW", this.ignoreWater);
        if (BombConfig.enableNukeNBTSaving) {
            nbt.func_74768_a("gspNum", this.gspNum);
            nbt.func_74757_a("f3", this.isAusf3Complete);
            nbt.func_74757_a("isContained", this.isContained);
            int i = 0;
            for (Map.Entry<ChunkPos, BitSet> e : this.perChunk.entrySet()) {
                NBTTagCompound c = new NBTTagCompound();
                c.func_74768_a("cX", e.getKey().field_77276_a);
                c.func_74768_a("cZ", e.getKey().field_77275_b);
                c.func_74782_a("cB", (NBTBase)new NBTTagLongArray(e.getValue().toLongArray()));
                nbt.func_74782_a("chunks" + i, (NBTBase)c.func_74737_b());
                ++i;
            }
        }
    }

    public static long[] getLongArray(NBTTagLongArray nbt) {
        return (long[])ObfuscationReflectionHelper.getPrivateValue(NBTTagLongArray.class, (Object)nbt, (int)0);
    }

    public class CoordComparator
    implements Comparator<ChunkPos> {
        @Override
        public int compare(ChunkPos o1, ChunkPos o2) {
            int chunkX = (int)ExplosionNukeRayBatched.this.posX >> 4;
            int chunkZ = (int)ExplosionNukeRayBatched.this.posZ >> 4;
            int diff1 = Math.abs(chunkX - (o1.func_180334_c() >> 4)) + Math.abs(chunkZ - (o1.func_180333_d() >> 4));
            int diff2 = Math.abs(chunkX - (o2.func_180334_c() >> 4)) + Math.abs(chunkZ - (o2.func_180333_d() >> 4));
            return Integer.compare(diff1, diff2);
        }
    }
}

