/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.crt;

import com.hbm.handler.crt.NTMCraftTweaker;
import com.hbm.inventory.AnvilRecipes;
import com.hbm.inventory.RecipesCommon;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import java.util.Arrays;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.ntm.Anvil")
public class Anvil {
    @ZenMethod
    public static void addRecipe(IItemStack[] output, IIngredient[] inputs, int tier) {
        NTMCraftTweaker.postInitActions.add(new ActionAddRecipe(output, inputs, tier));
    }

    @ZenMethod
    public static void addRecipe(IItemStack[] output, IIngredient inputs, int tier) {
        NTMCraftTweaker.postInitActions.add(new ActionAddRecipe(output, new IIngredient[]{inputs}, tier));
    }

    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient[] inputs, int tier) {
        NTMCraftTweaker.postInitActions.add(new ActionAddRecipe(new IItemStack[]{output}, inputs, tier));
    }

    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient inputs, int tier) {
        NTMCraftTweaker.postInitActions.add(new ActionAddRecipe(new IItemStack[]{output}, new IIngredient[]{inputs}, tier));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack[] outputs) {
        CraftTweakerAPI.logInfo((String)("start remove recipe" + Arrays.toString(outputs)));
        NTMCraftTweaker.postInitActions.add(new ActionRemoveRecipe(outputs));
    }

    @ZenMethod
    public static void removeRecipeByInput(IIngredient[] inputs) {
        CraftTweakerAPI.logInfo((String)("start remove recipe" + Arrays.toString(inputs)));
        NTMCraftTweaker.postInitActions.add(new ActionRemoveRecipe(inputs, null));
    }

    @ZenMethod
    public static void replaceRecipe(IItemStack[] oldRecipe, IIngredient inputs, int tier) {
        NTMCraftTweaker.postInitActions.add(new ActionRemoveRecipe(oldRecipe));
        NTMCraftTweaker.postInitActions.add(new ActionAddRecipe(oldRecipe, new IIngredient[]{inputs}, tier));
    }

    private static class ActionAddRecipe
    implements IAction {
        private RecipesCommon.AStack[] inputs;
        private ItemStack[] output;
        private int tier;

        public ActionAddRecipe(IItemStack[] output, IIngredient[] inputs, int tier) {
            this.output = CraftTweakerMC.getItemStacks((IItemStack[])output);
            this.inputs = NTMCraftTweaker.IIngredientsToAStack(inputs);
            this.tier = tier;
        }

        public void apply() {
            AnvilRecipes.addConstructionRecipe(this.inputs, this.output, this.tier);
        }

        public String describe() {
            return "add anvil Recipe for " + Arrays.toString(this.output) + " with inputs " + Arrays.toString(this.inputs) + " with tier " + this.tier;
        }
    }

    public static class ActionRemoveRecipe
    implements IAction {
        private ItemStack[] output;
        private RecipesCommon.AStack[] inputs;

        public ActionRemoveRecipe(IItemStack[] output) {
            this.output = CraftTweakerMC.getItemStacks((IItemStack[])output);
        }

        public ActionRemoveRecipe(IIngredient[] input, IItemStack[] output) {
            this.inputs = NTMCraftTweaker.IIngredientsToAStack(input);
            this.output = CraftTweakerMC.getItemStacks((IItemStack[])output);
        }

        public void apply() {
            if (this.inputs != null && this.output == null) {
                AnvilRecipes.removeConstructionRecipeByInput(this.inputs);
                return;
            }
            if (this.output == null) {
                CraftTweakerAPI.logError((String)"ERROR Anvil output item can not be an empty/air stack!");
                return;
            }
            AnvilRecipes.removeConstructionRecipe(this.output);
        }

        public String describe() {
            return "Removing NTM Anvil recipe for output " + Arrays.toString(this.output);
        }
    }
}

