/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory;

import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.inventory.FluidCombustionRecipes;
import com.hbm.inventory.FluidFlameRecipes;
import com.hbm.inventory.OreDictManager;
import com.hbm.items.ItemEnums;
import com.hbm.items.ModItems;
import com.hbm.util.Tuple;
import java.util.HashMap;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class CokerRecipes {
    public static HashMap<Fluid, Tuple.Triplet<Integer, ItemStack, FluidStack>> recipes = new HashMap();

    public static void registerDefaults() {
        CokerRecipes.registerAuto(ModForgeFluids.HEAVYOIL, ModForgeFluids.OIL_COKER);
        CokerRecipes.registerAuto(ModForgeFluids.HEAVYOIL_VACUUM, ModForgeFluids.REFORMATE);
        CokerRecipes.registerAuto(ModForgeFluids.COALCREOSOTE, ModForgeFluids.NAPHTHA_COKER);
        CokerRecipes.registerAuto(ModForgeFluids.SMEAR, ModForgeFluids.OIL_COKER);
        CokerRecipes.registerAuto(ModForgeFluids.HEATINGOIL, ModForgeFluids.OIL_COKER);
        CokerRecipes.registerAuto(ModForgeFluids.HEATINGOIL_VACUUM, ModForgeFluids.OIL_COKER);
        CokerRecipes.registerAuto(ModForgeFluids.RECLAIMED, ModForgeFluids.NAPHTHA_COKER);
        CokerRecipes.registerAuto(ModForgeFluids.NAPHTHA, ModForgeFluids.NAPHTHA_COKER);
        CokerRecipes.registerAuto(ModForgeFluids.NAPHTHA_DS, ModForgeFluids.NAPHTHA_COKER);
        CokerRecipes.registerAuto(ModForgeFluids.NAPHTHA_CRACK, ModForgeFluids.NAPHTHA_COKER);
        CokerRecipes.registerAuto(ModForgeFluids.DIESEL, ModForgeFluids.NAPHTHA_COKER);
        CokerRecipes.registerAuto(ModForgeFluids.DIESEL_REFORM, ModForgeFluids.NAPHTHA_COKER);
        CokerRecipes.registerAuto(ModForgeFluids.DIESEL_CRACK, ModForgeFluids.GAS_COKER);
        CokerRecipes.registerAuto(ModForgeFluids.DIESEL_CRACK_REFORM, ModForgeFluids.GAS_COKER);
        CokerRecipes.registerAuto(ModForgeFluids.LIGHTOIL, ModForgeFluids.GAS_COKER);
        CokerRecipes.registerAuto(ModForgeFluids.LIGHTOIL_DS, ModForgeFluids.GAS_COKER);
        CokerRecipes.registerAuto(ModForgeFluids.LIGHTOIL_CRACK, ModForgeFluids.GAS_COKER);
        CokerRecipes.registerAuto(ModForgeFluids.LIGHTOIL_VACUUM, ModForgeFluids.GAS_COKER);
        CokerRecipes.registerAuto(ModForgeFluids.BIOFUEL, ModForgeFluids.GAS_COKER);
        CokerRecipes.registerAuto(ModForgeFluids.AROMATICS, ModForgeFluids.GAS_COKER);
        CokerRecipes.registerAuto(ModForgeFluids.REFORMATE, ModForgeFluids.GAS_COKER);
        CokerRecipes.registerAuto(ModForgeFluids.XYLENE, ModForgeFluids.GAS_COKER);
        CokerRecipes.registerAuto(ModForgeFluids.FISHOIL, ModForgeFluids.MERCURY);
        CokerRecipes.registerAuto(ModForgeFluids.SUNFLOWEROIL, ModForgeFluids.GAS_COKER);
        CokerRecipes.registerSFAuto(ModForgeFluids.WOODOIL, 340000L, new ItemStack(Items.field_151044_h, 1, 1), ModForgeFluids.GAS_COKER);
        CokerRecipes.registerRecipe(ModForgeFluids.BITUMEN, 16000, OreDictManager.DictFrame.fromOne(ModItems.coke, (Enum)ItemEnums.EnumCokeType.PETROLEUM), new FluidStack(ModForgeFluids.OIL_COKER, 1600));
        CokerRecipes.registerRecipe(ModForgeFluids.LUBRICANT, 12000, OreDictManager.DictFrame.fromOne(ModItems.coke, (Enum)ItemEnums.EnumCokeType.PETROLEUM), new FluidStack(ModForgeFluids.OIL_COKER, 1200));
        CokerRecipes.registerRecipe(ModForgeFluids.SOURGAS, 1000, new ItemStack(ModItems.sulfur), new FluidStack(ModForgeFluids.GAS_COKER, 150));
    }

    private static void registerAuto(Fluid fluid, Fluid outputFluid) {
        CokerRecipes.registerSFAuto(fluid, 820000L, OreDictManager.DictFrame.fromOne(ModItems.coke, (Enum)ItemEnums.EnumCokeType.PETROLEUM), outputFluid);
    }

    private static void registerSFAuto(Fluid fluid, long tuPerSF, ItemStack fuel, Fluid outputFluid) {
        FluidStack byproduct;
        long tuCombustible;
        long tuFlammable = FluidFlameRecipes.getHeatEnergy(fluid) * 1000L;
        double tuPerBucket = Math.max(tuFlammable, tuCombustible = FluidCombustionRecipes.getCombustionEnergy(fluid));
        int mB = (int)((double)(1000L * tuPerSF) / tuPerBucket);
        if (mB > 10000) {
            mB -= mB % 1000;
        } else if (mB > 1000) {
            mB -= mB % 100;
        } else if (mB > 100) {
            mB -= mB % 10;
        }
        FluidStack fluidStack = byproduct = outputFluid == null ? null : new FluidStack(outputFluid, Math.max(10, mB / 10));
        if (mB > 16000) {
            return;
        }
        CokerRecipes.registerRecipe(fluid, mB, fuel, byproduct);
    }

    private static void registerRecipe(Fluid fluid, int quantity, ItemStack output, FluidStack byproduct) {
        recipes.put(fluid, new Tuple.Triplet<Integer, ItemStack, FluidStack>(quantity, output, byproduct));
    }

    public static Tuple.Triplet<Integer, ItemStack, FluidStack> getOutput(Fluid type) {
        return recipes.get(type);
    }
}

