/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory;

import com.hbm.blocks.ModBlocks;
import com.hbm.items.ModItems;
import com.hbm.potion.HbmPotion;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionHelper;
import net.minecraft.potion.PotionType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreIngredient;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class PotionRecipes {
    public static void registerPotionRecipes() {
        PotionRecipes.addPotionRecipe(HbmPotion.radiation, ModItems.nuclear_waste, 600, 2400, 300);
        PotionRecipes.addPotionRecipe(HbmPotion.radx, ModItems.pill_iodine, 600, 2400, 300);
        PotionRecipes.addPotionRecipe(HbmPotion.radaway, ModBlocks.mush, 1200, 12000, 4800);
        PotionRecipes.addPotionRecipe(HbmPotion.mutation, ModItems.egg_balefire, 600, 2400, 0);
        PotionRecipes.addPotionRecipe(HbmPotion.taint, ModItems.syringe_taint, 600, 2400, 300);
        PotionRecipes.addPotionRecipe(HbmPotion.phosphorus, ModItems.crystal_phosphorus, 600, 2400, 0);
        PotionRecipes.addPotionRecipe(HbmPotion.bang, ModItems.coin_ufo, 600, 300, 1200);
        PotionRecipes.addPotionRecipe(HbmPotion.stability, ModItems.five_htp, 1200, 3600, 0);
        PotionRecipes.addPotionRecipe(HbmPotion.lead, ModItems.apple_lead1, 600, 2400, 300);
        PotionRecipes.addPotionRecipe(HbmPotion.telekinesis, ModBlocks.float_bomb, 600, 2400, 300);
    }

    public static void addPotionRecipe(Potion type, Object input, int normalTime, int longTime, int strongTime) {
        PotionRecipes.addPotionRecipe(type, input, normalTime, longTime, strongTime, 0, 0, 1);
    }

    public static void addPotionRecipe(Potion type, Object input, int normalTime, int longTime, int strongTime, int normalLvl, int longLvl, int strongLvL) {
        String baseName = type.getRegistryName().func_110623_a();
        PotionType normalType = PotionRecipes.addPotion(new PotionEffect(type, normalTime, normalLvl), baseName, baseName);
        Ingredient brewItem = PotionRecipes.getIngredient(input);
        PotionHelper.func_193356_a((PotionType)PotionTypes.field_185230_b, (Ingredient)brewItem, (PotionType)PotionTypes.field_185231_c);
        PotionHelper.func_193356_a((PotionType)PotionTypes.field_185233_e, (Ingredient)brewItem, (PotionType)normalType);
        if (strongTime > 0) {
            PotionType strongType = PotionRecipes.addPotion(new PotionEffect(type, strongTime, strongLvL), baseName, "strong_" + baseName);
            PotionHelper.func_193357_a((PotionType)normalType, (Item)Items.field_151114_aO, (PotionType)strongType);
        }
        if (longTime > 0) {
            PotionType longType = PotionRecipes.addPotion(new PotionEffect(type, longTime, longLvl), baseName, "long_" + baseName);
            PotionHelper.func_193357_a((PotionType)normalType, (Item)Items.field_151137_ax, (PotionType)longType);
        }
    }

    private static PotionType addPotion(PotionEffect effect, String baseName, String name) {
        PotionType type = (PotionType)new PotionType(baseName, new PotionEffect[]{effect}).setRegistryName(new ResourceLocation("hbm", name));
        ForgeRegistries.POTION_TYPES.register((IForgeRegistryEntry)type);
        return type;
    }

    public static Ingredient getIngredient(Object reagent) {
        if (reagent instanceof Item) {
            return Ingredient.func_193367_a((Item)((Item)reagent));
        }
        if (reagent instanceof Block) {
            return Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Block)reagent)});
        }
        if (reagent instanceof ItemStack) {
            return Ingredient.func_193369_a((ItemStack[])new ItemStack[]{(ItemStack)reagent});
        }
        if (reagent instanceof String) {
            return new OreIngredient((String)reagent);
        }
        return null;
    }
}

