/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.gear;

import api.hbm.item.IGasMask;
import com.hbm.handler.ArmorUtil;
import com.hbm.items.ModItems;
import com.hbm.render.RenderHelper;
import com.hbm.render.model.ModelGasMask;
import com.hbm.render.model.ModelM65;
import com.hbm.util.ArmorRegistry;
import com.hbm.util.I18nUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ArmorGasMask
extends ItemArmor
implements IGasMask {
    @SideOnly(value=Side.CLIENT)
    private ModelGasMask modelGas;
    @SideOnly(value=Side.CLIENT)
    private ModelM65 modelM65;
    private ResourceLocation goggleBlur0 = new ResourceLocation("hbm:textures/misc/overlay_goggles_0.png");
    private ResourceLocation goggleBlur1 = new ResourceLocation("hbm:textures/misc/overlay_goggles_1.png");
    private ResourceLocation goggleBlur2 = new ResourceLocation("hbm:textures/misc/overlay_goggles_2.png");
    private ResourceLocation goggleBlur3 = new ResourceLocation("hbm:textures/misc/overlay_goggles_3.png");
    private ResourceLocation goggleBlur4 = new ResourceLocation("hbm:textures/misc/overlay_goggles_4.png");
    private ResourceLocation goggleBlur5 = new ResourceLocation("hbm:textures/misc/overlay_goggles_5.png");
    private ResourceLocation gasmaskBlur0 = new ResourceLocation("hbm:textures/misc/overlay_gasmask_0.png");
    private ResourceLocation gasmaskBlur1 = new ResourceLocation("hbm:textures/misc/overlay_gasmask_1.png");
    private ResourceLocation gasmaskBlur2 = new ResourceLocation("hbm:textures/misc/overlay_gasmask_2.png");
    private ResourceLocation gasmaskBlur3 = new ResourceLocation("hbm:textures/misc/overlay_gasmask_3.png");
    private ResourceLocation gasmaskBlur4 = new ResourceLocation("hbm:textures/misc/overlay_gasmask_4.png");
    private ResourceLocation gasmaskBlur5 = new ResourceLocation("hbm:textures/misc/overlay_gasmask_5.png");

    public ArmorGasMask(ItemArmor.ArmorMaterial materialIn, int renderIndexIn, EntityEquipmentSlot equipmentSlotIn, String s) {
        super(materialIn, renderIndexIn, equipmentSlotIn);
        this.func_77655_b(s);
        this.setRegistryName(s);
        this.func_77637_a(CreativeTabs.field_78037_j);
        ModItems.ALL_ITEMS.add((Item)this);
    }

    public boolean isValidArmor(ItemStack stack, EntityEquipmentSlot armorType, Entity entity) {
        return armorType == EntityEquipmentSlot.HEAD;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        if (this == ModItems.gas_mask && armorSlot == EntityEquipmentSlot.HEAD) {
            if (this.modelGas == null) {
                this.modelGas = new ModelGasMask();
            }
            return this.modelGas;
        }
        if ((this == ModItems.gas_mask_m65 || this == ModItems.hazmat_helmet_red || this == ModItems.hazmat_helmet_grey || this == ModItems.gas_mask_mono || this == ModItems.hazmat_paa_helmet) && armorSlot == EntityEquipmentSlot.HEAD) {
            if (this.modelM65 == null) {
                this.modelM65 = new ModelM65();
            }
            return this.modelM65;
        }
        return null;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        if (stack.func_77973_b() == ModItems.gas_mask) {
            return "hbm:textures/armor/GasMask.png";
        }
        if (stack.func_77973_b() == ModItems.gas_mask_m65) {
            return "hbm:textures/armor/ModelM65.png";
        }
        if (stack.func_77973_b() == ModItems.gas_mask_mono) {
            return "hbm:textures/armor/ModelM65Mono.png";
        }
        if (stack.func_77973_b() == ModItems.hazmat_helmet) {
            return "hbm:textures/armor/hazmat_1.png";
        }
        if (stack.func_77973_b() == ModItems.hazmat_helmet_red) {
            return "hbm:textures/armor/ModelHazRed.png";
        }
        if (stack.func_77973_b() == ModItems.hazmat_helmet_grey) {
            return "hbm:textures/armor/ModelHazGrey.png";
        }
        if (stack.func_77973_b() == ModItems.hazmat_paa_helmet) {
            return "hbm:textures/armor/ModelHazPaa.png";
        }
        return "hbm:textures/models/capes/CapeUnknown.png";
    }

    @SideOnly(value=Side.CLIENT)
    public void renderHelmetOverlay(ItemStack stack, EntityPlayer player, ScaledResolution resolution, float partialTicks) {
        if (this != ModItems.gas_mask && this != ModItems.gas_mask_m65 && this != ModItems.hazmat_helmet_red && this != ModItems.hazmat_helmet_grey) {
            return;
        }
        GlStateManager.func_179097_i();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179118_c();
        if (this == ModItems.gas_mask_m65 || this == ModItems.hazmat_helmet_red || this == ModItems.hazmat_helmet_grey) {
            switch ((int)((double)stack.func_77952_i() / (double)stack.func_77958_k() * 6.0)) {
                case 0: {
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(this.goggleBlur0);
                    break;
                }
                case 1: {
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(this.goggleBlur1);
                    break;
                }
                case 2: {
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(this.goggleBlur2);
                    break;
                }
                case 3: {
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(this.goggleBlur3);
                    break;
                }
                case 4: {
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(this.goggleBlur4);
                    break;
                }
                case 5: {
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(this.goggleBlur5);
                    break;
                }
                default: {
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(this.goggleBlur5);
                }
            }
        }
        if (this == ModItems.gas_mask) {
            switch ((int)((double)stack.func_77952_i() / (double)stack.func_77958_k() * 6.0)) {
                case 0: {
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(this.gasmaskBlur0);
                    break;
                }
                case 1: {
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(this.gasmaskBlur1);
                    break;
                }
                case 2: {
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(this.gasmaskBlur2);
                    break;
                }
                case 3: {
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(this.gasmaskBlur3);
                    break;
                }
                case 4: {
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(this.gasmaskBlur4);
                    break;
                }
                case 5: {
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(this.gasmaskBlur5);
                    break;
                }
                default: {
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(this.gasmaskBlur5);
                }
            }
        }
        RenderHelper.startDrawingTexturedQuads();
        RenderHelper.addVertexWithUV(0.0, resolution.func_78328_b(), -90.0, 0.0, 1.0);
        RenderHelper.addVertexWithUV(resolution.func_78326_a(), resolution.func_78328_b(), -90.0, 1.0, 1.0);
        RenderHelper.addVertexWithUV(resolution.func_78326_a(), 0.0, -90.0, 1.0, 0.0);
        RenderHelper.addVertexWithUV(0.0, 0.0, -90.0, 0.0, 0.0);
        RenderHelper.draw();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179126_j();
        GlStateManager.func_179141_d();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> list, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, list, flagIn);
        ArmorUtil.addGasMaskTooltip(stack, worldIn, list, flagIn);
        ArrayList<ArmorRegistry.HazardClass> haz = this.getBlacklist(stack);
        if (!haz.isEmpty()) {
            list.add("\u00a7c" + I18nUtil.resolveKey("hazard.neverProtects", new Object[0]));
            for (ArmorRegistry.HazardClass clazz : haz) {
                list.add("\u00a74 -" + I18nUtil.resolveKey(clazz.lang, new Object[0]));
            }
        }
    }

    @Override
    public ArrayList<ArmorRegistry.HazardClass> getBlacklist(ItemStack stack) {
        if (stack.func_77973_b() == ModItems.gas_mask_mono) {
            return new ArrayList<ArmorRegistry.HazardClass>(Arrays.asList(ArmorRegistry.HazardClass.GAS_CHLORINE, ArmorRegistry.HazardClass.GAS_CORROSIVE, ArmorRegistry.HazardClass.NERVE_AGENT, ArmorRegistry.HazardClass.BACTERIA));
        }
        if (stack.func_77973_b() == ModItems.gas_mask || stack.func_77973_b() == ModItems.gas_mask_m65) {
            return new ArrayList<ArmorRegistry.HazardClass>(Arrays.asList(ArmorRegistry.HazardClass.GAS_CORROSIVE, ArmorRegistry.HazardClass.NERVE_AGENT));
        }
        return new ArrayList<ArmorRegistry.HazardClass>();
    }

    @Override
    public ItemStack getFilter(ItemStack stack) {
        return ArmorUtil.getGasMaskFilter(stack);
    }

    @Override
    public void installFilter(ItemStack stack, ItemStack filter) {
        ArmorUtil.installGasMaskFilter(stack, filter);
    }

    @Override
    public void damageFilter(EntityLivingBase entity, ItemStack stack, int damage) {
        ArmorUtil.damageGasMaskFilter(entity, stack, damage);
    }

    @Override
    public boolean isFilterApplicable(ItemStack stack, ItemStack filter) {
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack;
        ItemStack filter;
        if (player.func_70093_af() && (filter = this.getFilter(stack = player.func_184586_b(hand))) != null) {
            ArmorUtil.removeFilter(stack);
            if (!player.field_71071_by.func_70441_a(filter)) {
                player.func_146097_a(filter, true, false);
            }
        }
        return super.func_77659_a(world, player, hand);
    }
}

