/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.machine;

import api.hbm.energy.IBatteryItem;
import com.hbm.items.ModItems;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.util.I18nUtil;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ItemBattery
extends Item
implements IBatteryItem {
    private long maxCharge;
    private long chargeRate;
    private long dischargeRate;

    public ItemBattery(long dura, long chargeRate, long dischargeRate, String s) {
        this.maxCharge = dura;
        this.chargeRate = chargeRate;
        this.dischargeRate = dischargeRate;
        this.func_77655_b(s);
        this.setRegistryName(s);
        this.func_77637_a(MainRegistry.controlTab);
        ModItems.ALL_ITEMS.add(this);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> list, ITooltipFlag flagIn) {
        if (stack.func_77973_b() == ModItems.battery_creative) {
            return;
        }
        long charge = this.maxCharge;
        if (stack.func_77942_o()) {
            charge = this.getCharge(stack);
        }
        if (stack.func_77973_b() != ModItems.fusion_core && stack.func_77973_b() != ModItems.factory_core_titanium && stack.func_77973_b() != ModItems.factory_core_advanced && stack.func_77973_b() != ModItems.energy_core) {
            list.add("\u00a76" + I18nUtil.resolveKey("desc.energystore", new Object[0]) + " " + Library.getShortNumber(charge) + "/" + Library.getShortNumber(this.maxCharge) + "HE\u00a7r");
        } else {
            String charge1 = Library.getShortNumber(charge * 100L / this.maxCharge);
            list.add("\u00a72" + I18nUtil.resolveKey("desc.energychargecur", new Object[0]) + " " + charge1 + "%\u00a7r");
            list.add("(" + Library.getShortNumber(charge) + "/" + Library.getShortNumber(this.maxCharge) + "HE)");
        }
        list.add("\u00a7a" + I18nUtil.resolveKey("desc.energychargerate", new Object[0]) + " " + Library.getShortNumber(this.chargeRate * 20L) + "HE/s\u00a7r");
        list.add("\u00a7c" + I18nUtil.resolveKey("desc.energydchargerate", new Object[0]) + " " + Library.getShortNumber(this.dischargeRate * 20L) + "HE/s\u00a7r");
    }

    public EnumRarity func_77613_e(ItemStack p_77613_1_) {
        if (this == ModItems.battery_schrabidium) {
            return EnumRarity.RARE;
        }
        if (this == ModItems.fusion_core || this == ModItems.factory_core_titanium || this == ModItems.factory_core_advanced || this == ModItems.energy_core) {
            return EnumRarity.UNCOMMON;
        }
        return EnumRarity.COMMON;
    }

    @Override
    public void chargeBattery(ItemStack stack, long i) {
        if (stack.func_77973_b() == ModItems.battery_creative) {
            return;
        }
        if (stack.func_77973_b() instanceof ItemBattery) {
            if (stack.func_77942_o()) {
                stack.func_77978_p().func_74772_a("charge", stack.func_77978_p().func_74763_f("charge") + i);
            } else {
                stack.func_77982_d(new NBTTagCompound());
                stack.func_77978_p().func_74772_a("charge", i);
            }
        }
    }

    @Override
    public void setCharge(ItemStack stack, long i) {
        if (stack.func_77973_b() == ModItems.battery_creative) {
            return;
        }
        if (stack.func_77973_b() instanceof ItemBattery) {
            if (stack.func_77942_o()) {
                stack.func_77978_p().func_74772_a("charge", i);
            } else {
                stack.func_77982_d(new NBTTagCompound());
                stack.func_77978_p().func_74772_a("charge", i);
            }
        }
    }

    @Override
    public void dischargeBattery(ItemStack stack, long i) {
        if (stack.func_77973_b() == ModItems.battery_creative) {
            return;
        }
        if (stack.func_77973_b() instanceof ItemBattery) {
            if (stack.func_77942_o()) {
                stack.func_77978_p().func_74772_a("charge", stack.func_77978_p().func_74763_f("charge") - i);
            } else {
                stack.func_77982_d(new NBTTagCompound());
                stack.func_77978_p().func_74772_a("charge", this.maxCharge - i);
            }
        }
    }

    @Override
    public long getCharge(ItemStack stack) {
        if (stack.func_77973_b() == ModItems.battery_creative) {
            return Long.MAX_VALUE;
        }
        if (stack.func_77973_b() instanceof ItemBattery) {
            if (stack.func_77942_o()) {
                return stack.func_77978_p().func_74763_f("charge");
            }
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_74772_a("charge", ((ItemBattery)stack.func_77973_b()).maxCharge);
            return stack.func_77978_p().func_74763_f("charge");
        }
        return 0L;
    }

    @Override
    public long getMaxCharge(ItemStack stack) {
        return this.maxCharge;
    }

    @Override
    public long getChargeRate() {
        return this.chargeRate;
    }

    @Override
    public long getDischargeRate() {
        return this.dischargeRate;
    }

    public static ItemStack getEmptyBattery(Item item) {
        if (item instanceof ItemBattery) {
            ItemStack stack = new ItemStack(item);
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_74772_a("charge", 0L);
            return stack.func_77946_l();
        }
        return null;
    }

    public static ItemStack getFullBattery(Item item) {
        if (item instanceof ItemBattery) {
            ItemStack stack = new ItemStack(item);
            stack.func_77982_d(new NBTTagCompound());
            stack.func_77978_p().func_74772_a("charge", ((ItemBattery)item).getMaxCharge(stack));
            return stack.func_77946_l();
        }
        return new ItemStack(item);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return stack.func_77973_b() != ModItems.battery_creative;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)this.getCharge(stack) / (double)this.getMaxCharge(stack);
    }
}

