/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.machine;

import com.hbm.blocks.ModBlocks;
import com.hbm.interfaces.IHasCustomMetaModels;
import com.hbm.inventory.material.MaterialShapes;
import com.hbm.inventory.material.Mats;
import com.hbm.inventory.material.NTMMaterial;
import com.hbm.items.ModItems;
import com.hbm.util.I18nUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class ItemMold
extends Item
implements IHasCustomMetaModels {
    public static List<Mold> molds = new ArrayList<Mold>();
    public static TreeMap<Integer, Mold> moldById = new TreeMap();
    public HashMap<NTMMaterial, ItemStack> blockOverrides = new HashMap();
    public static int nextOrder = 0;

    public ItemMold(String s) {
        this.func_77655_b(s);
        this.setRegistryName(s);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.blockOverrides.put(Mats.MAT_STONE, new ItemStack(Blocks.field_150348_b));
        this.blockOverrides.put(Mats.MAT_OBSIDIAN, new ItemStack(Blocks.field_150343_Z));
        int S = 0;
        int L = 1;
        this.registerMold(new MoldShape(0, S, "nugget", MaterialShapes.NUGGET));
        this.registerMold(new MoldShape(1, S, "billet", MaterialShapes.BILLET));
        this.registerMold(new MoldShape(2, S, "ingot", MaterialShapes.INGOT));
        this.registerMold(new MoldShape(3, S, "plate", MaterialShapes.PLATE));
        this.registerMold(new MoldShape(4, S, "wire", MaterialShapes.WIRE));
        this.registerMold(new MoldShape(5, S, "plate_cast", MaterialShapes.CASTPLATE));
        this.registerMold(new MoldShape(6, S, "wire_dense", MaterialShapes.DENSEWIRE));
        this.registerMold(new MoldMulti(7, S, "blade", MaterialShapes.INGOT.q(3), Mats.MAT_TITANIUM, new ItemStack(ModItems.blade_titanium), Mats.MAT_TUNGSTEN, new ItemStack(ModItems.blade_tungsten)));
        this.registerMold(new MoldMulti(8, S, "blades", MaterialShapes.INGOT.q(5), Mats.MAT_ALUMINIUM, new ItemStack(ModItems.blades_aluminum), Mats.MAT_GOLD, new ItemStack(ModItems.blades_gold), Mats.MAT_IRON, new ItemStack(ModItems.blades_iron), Mats.MAT_STEEL, new ItemStack(ModItems.blades_steel), Mats.MAT_TITANIUM, new ItemStack(ModItems.blades_titanium), Mats.MAT_ALLOY, new ItemStack(ModItems.blades_advanced_alloy), Mats.MAT_CMB, new ItemStack(ModItems.blades_combine_steel), Mats.MAT_SCHRABIDIUM, new ItemStack(ModItems.blades_schrabidium)));
        this.registerMold(new MoldMulti(9, S, "stamp", MaterialShapes.INGOT.q(3), Mats.MAT_STONE, new ItemStack(ModItems.stamp_stone_flat), Mats.MAT_IRON, new ItemStack(ModItems.stamp_iron_flat), Mats.MAT_STEEL, new ItemStack(ModItems.stamp_steel_flat), Mats.MAT_TITANIUM, new ItemStack(ModItems.stamp_titanium_flat), Mats.MAT_OBSIDIAN, new ItemStack(ModItems.stamp_obsidian_flat), Mats.MAT_SCHRABIDIUM, new ItemStack(ModItems.stamp_schrabidium_flat)));
        this.registerMold(new MoldShape(10, S, "shell", MaterialShapes.SHELL));
        this.registerMold(new MoldShape(11, S, "pipe", MaterialShapes.PIPE));
        this.registerMold(new MoldShape(12, S, "bolt", MaterialShapes.BOLT));
        this.registerMold(new MoldShape(13, L, "ingots", MaterialShapes.INGOT, 9));
        this.registerMold(new MoldShape(14, L, "plates", MaterialShapes.PLATE, 9));
        this.registerMold(new MoldShape(15, L, "wires", MaterialShapes.WIRE, 16));
        this.registerMold(new MoldShape(16, L, "wires_dense", MaterialShapes.DENSEWIRE, 9));
        this.registerMold(new MoldBlock(17, L, "block", MaterialShapes.BLOCK));
        this.registerMold(new MoldSingle(18, L, "pipes", new ItemStack(ModItems.pipes_steel), Mats.MAT_STEEL, MaterialShapes.BLOCK.q(3)));
        this.registerMold(new MoldSingle(19, S, "c357", new ItemStack(ModItems.casing_357), Mats.MAT_COPPER, MaterialShapes.PLATE.q(1)));
        this.registerMold(new MoldSingle(20, S, "c44", new ItemStack(ModItems.casing_44), Mats.MAT_COPPER, MaterialShapes.PLATE.q(1)));
        this.registerMold(new MoldSingle(21, S, "c9", new ItemStack(ModItems.casing_9), Mats.MAT_COPPER, MaterialShapes.PLATE.q(1)));
        this.registerMold(new MoldSingle(22, S, "c50", new ItemStack(ModItems.casing_50), Mats.MAT_COPPER, MaterialShapes.PLATE.q(1)));
        this.registerMold(new MoldSingle(23, S, "cbuckshot", new ItemStack(ModItems.casing_buckshot), Mats.MAT_COPPER, MaterialShapes.PLATE.q(1)));
        ModItems.ALL_ITEMS.add(this);
    }

    public void registerMold(Mold mold) {
        molds.add(mold);
        moldById.put(mold.id, mold);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (tab == this.func_77640_w() || tab == CreativeTabs.field_78027_g) {
            for (int i = 0; i < molds.size(); ++i) {
                Mold mold = molds.get(i);
                list.add((Object)new ItemStack((Item)this, 1, mold.id));
            }
        }
    }

    @Override
    public Set<Integer> getMetaValues() {
        return moldById.keySet();
    }

    @Override
    public ModelResourceLocation getResourceLocation(int meta) {
        Mold mold = moldById.get(meta);
        return new ModelResourceLocation("hbm:mold_" + mold.name, "inventory");
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> list, ITooltipFlag flagIn) {
        Mold mold = this.getMold(stack);
        list.add("\u00a7e" + mold.getTitle());
        if (mold.size == 0) {
            list.add("\u00a76" + I18nUtil.resolveKey(ModBlocks.foundry_mold.func_149739_a() + ".name", new Object[0]));
        } else if (mold.size == 1) {
            list.add("\u00a7c" + I18nUtil.resolveKey(ModBlocks.foundry_basin.func_149739_a() + ".name", new Object[0]));
        }
    }

    public Mold getMold(ItemStack stack) {
        Mold mold = moldById.get(stack.func_77952_i());
        return mold != null ? mold : molds.get(0);
    }

    public class MoldShape
    extends Mold {
        public MaterialShapes shape;
        public int amount;

        public MoldShape(int id, int size, String name, MaterialShapes shape) {
            this(id, size, name, shape, 1);
        }

        public MoldShape(int id, int size, String name, MaterialShapes shape, int amount) {
            super(id, size, name);
            this.shape = shape;
            this.amount = amount;
        }

        @Override
        public ItemStack getOutput(NTMMaterial mat) {
            for (String name : mat.names) {
                String od = this.shape.name() + name;
                NonNullList ores = OreDictionary.getOres((String)od);
                if (ores.isEmpty()) continue;
                ItemStack copy = ((ItemStack)ores.get(0)).func_77946_l();
                copy.func_190920_e(this.amount);
                return copy;
            }
            return null;
        }

        @Override
        public int getCost() {
            return this.shape.q(this.amount);
        }

        @Override
        public String getTitle() {
            return I18nUtil.resolveKey("shape." + this.shape.name(), new Object[0]) + " x" + this.amount;
        }
    }

    public abstract class Mold {
        public int order = nextOrder++;
        public int id;
        public int size;
        public String name;

        public Mold(int id, int size, String name) {
            this.id = id;
            this.size = size;
            this.name = name;
        }

        public abstract ItemStack getOutput(NTMMaterial var1);

        public abstract int getCost();

        public abstract String getTitle();
    }

    public class MoldMulti
    extends Mold {
        public HashMap<NTMMaterial, ItemStack> map;
        public int amount;
        public int stacksize;

        public MoldMulti(int id, int size, String name, int amount, Object ... inputs) {
            super(id, size, name);
            this.map = new HashMap();
            this.amount = amount;
            for (int i = 0; i < inputs.length; i += 2) {
                this.map.put((NTMMaterial)inputs[i], (ItemStack)inputs[i + 1]);
                if (i != 0) continue;
                this.stacksize = ((ItemStack)inputs[i + 1]).func_190916_E();
            }
        }

        @Override
        public ItemStack getOutput(NTMMaterial mat) {
            ItemStack out = this.map.get(mat);
            if (out != null) {
                return out.func_77946_l();
            }
            return out;
        }

        @Override
        public int getCost() {
            return this.amount;
        }

        @Override
        public String getTitle() {
            return I18nUtil.resolveKey("shape." + this.name, new Object[0]) + " x" + this.stacksize;
        }
    }

    public class MoldBlock
    extends MoldShape {
        public MoldBlock(int id, int size, String name, MaterialShapes shape) {
            super(id, size, name, shape);
        }

        @Override
        public ItemStack getOutput(NTMMaterial mat) {
            ItemStack override = ItemMold.this.blockOverrides.get(mat);
            if (override != null) {
                return override.func_77946_l();
            }
            return super.getOutput(mat);
        }
    }

    public class MoldSingle
    extends Mold {
        public ItemStack out;
        public NTMMaterial mat;
        public int amount;

        public MoldSingle(int id, int size, String name, ItemStack out, NTMMaterial mat, int amount) {
            super(id, size, name);
            this.out = out;
            this.mat = mat;
            this.amount = amount;
        }

        @Override
        public ItemStack getOutput(NTMMaterial mat) {
            return this.mat == mat ? this.out.func_77946_l() : null;
        }

        @Override
        public int getCost() {
            return this.amount;
        }

        @Override
        public String getTitle() {
            return this.out.func_82833_r() + " x" + this.out.func_190916_E();
        }
    }
}

