/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.tool;

import com.hbm.forgefluid.HbmFluidHandlerCanister;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.forgefluid.SpecialContainerFillLists;
import com.hbm.interfaces.IHasCustomModel;
import com.hbm.items.ModItems;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.util.I18nUtil;
import java.util.List;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemFluidCanister
extends Item
implements IHasCustomModel {
    public static final ModelResourceLocation fluidCanisterModel = new ModelResourceLocation("hbm:canister_empty", "inventory");
    public int cap;

    public ItemFluidCanister(String s, int cap) {
        this.func_77655_b(s);
        this.setRegistryName(s);
        this.func_77637_a(MainRegistry.controlTab);
        this.func_77625_d(1);
        this.func_77656_e(cap);
        this.cap = cap;
        ModItems.ALL_ITEMS.add(this);
    }

    public int getItemStackLimit(ItemStack stack) {
        return ItemFluidCanister.isFullOrEmpty(stack) ? 64 : 1;
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77653_i(ItemStack stack) {
        FluidStack f = FluidUtil.getFluidContained((ItemStack)stack);
        if (f == null) {
            return I18n.func_135052_a((String)"item.canister_empty.name", (Object[])new Object[0]);
        }
        try {
            return I18n.func_135052_a((String)SpecialContainerFillLists.EnumCanister.getEnumFromFluid(f.getFluid()).getTranslateKey(), (Object[])new Object[0]);
        }
        catch (Exception x) {
            return I18n.func_135052_a((String)"item.canister_empty.name", (Object[])new Object[0]);
        }
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        FluidStack f = FluidUtil.getFluidContained((ItemStack)stack);
        if (this == ModItems.canister_generic && f != null && f.getFluid() == ModForgeFluids.DIESEL) {
            tooltip.add(I18nUtil.resolveKey("desc.canisterdiesel", new Object[0]));
        }
        String s = Library.getColoredMbPercent(f == null ? 0L : (long)f.amount, this.cap);
        if (stack.func_190916_E() > 1) {
            s = stack.func_190916_E() + "x " + s;
        }
        tooltip.add(s);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (tab == this.func_77640_w() || tab == CreativeTabs.field_78027_g) {
            for (Fluid f : SpecialContainerFillLists.EnumCanister.getFluids()) {
                ItemStack stack = new ItemStack((Item)this, 1, 0);
                if (f != null) {
                    stack.func_77982_d(new NBTTagCompound());
                    stack.func_77978_p().func_74782_a("HbmFluidKey", (NBTBase)new FluidStack(f, this.cap).writeToNBT(new NBTTagCompound()));
                }
                items.add((Object)stack);
            }
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return new HbmFluidHandlerCanister(stack, this.cap);
    }

    @Override
    public ModelResourceLocation getResourceLocation() {
        return fluidCanisterModel;
    }

    public static boolean isFullCanister(ItemStack stack, Fluid fluid) {
        if (stack != null) {
            FluidStack f = FluidUtil.getFluidContained((ItemStack)stack);
            return stack.func_77973_b() instanceof ItemFluidCanister && f != null && f.getFluid() == fluid && f.amount == ((ItemFluidCanister)stack.func_77973_b()).cap;
        }
        return false;
    }

    public static ItemStack getFullCanister(Fluid f, int amount) {
        ItemStack stack = new ItemStack(ModItems.canister_generic, amount, 0);
        stack.func_77982_d(new NBTTagCompound());
        if (SpecialContainerFillLists.EnumCanister.contains(f)) {
            stack.func_77978_p().func_74782_a("HbmFluidKey", (NBTBase)new FluidStack(f, 1000).writeToNBT(new NBTTagCompound()));
        }
        return stack;
    }

    public static ItemStack getFullCanister(Fluid f) {
        return ItemFluidCanister.getFullCanister(f, 1);
    }

    public static boolean isFullOrEmpty(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77973_b() == ModItems.canister_generic) {
            FluidStack f = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p().func_74775_l("HbmFluidKey"));
            if (f == null) {
                return true;
            }
            return f.amount == 1000 || f.amount == 0;
        }
        return stack.func_77973_b() == ModItems.canister_generic;
    }

    public static boolean isEmptyCanister(ItemStack out) {
        return out.func_77973_b() == ModItems.canister_generic && FluidUtil.getFluidContained((ItemStack)out) == null;
    }
}

