/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.weapon;

import com.hbm.config.GeneralConfig;
import com.hbm.entity.projectile.EntityBulletBase;
import com.hbm.handler.BulletConfigSyncingUtil;
import com.hbm.handler.BulletConfiguration;
import com.hbm.handler.GunConfiguration;
import com.hbm.handler.HbmKeybinds;
import com.hbm.interfaces.IHoldableWeapon;
import com.hbm.interfaces.IItemHUD;
import com.hbm.items.ModItems;
import com.hbm.lib.Library;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.GunAnimationPacket;
import com.hbm.packet.GunButtonPacket;
import com.hbm.packet.GunFXPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.render.anim.BusAnimation;
import com.hbm.render.anim.HbmAnimations;
import com.hbm.render.misc.RenderScreenOverlay;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

public class ItemGunBase
extends Item
implements IHoldableWeapon,
IItemHUD {
    public GunConfiguration mainConfig;
    public GunConfiguration altConfig;
    public static Field hurtResistantTime;
    @SideOnly(value=Side.CLIENT)
    public static boolean m1;
    @SideOnly(value=Side.CLIENT)
    public static boolean m2;
    public static boolean oldClickRight;
    public static boolean oldClickLeft;

    public ItemGunBase(GunConfiguration config, String s) {
        this.mainConfig = config;
        this.func_77625_d(1);
        this.func_77655_b(s);
        this.setRegistryName(s);
        ModItems.ALL_ITEMS.add(this);
    }

    public ItemGunBase(GunConfiguration config, GunConfiguration alt, String s) {
        this(config, s);
        this.altConfig = alt;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        EnumHand hand = null;
        if (entity instanceof EntityPlayer) {
            if (((EntityPlayer)entity).func_184586_b(EnumHand.MAIN_HAND) == stack) {
                hand = EnumHand.MAIN_HAND;
            } else if (((EntityPlayer)entity).func_184586_b(EnumHand.OFF_HAND) == stack) {
                hand = EnumHand.OFF_HAND;
            }
            if (hand != null) {
                if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && world.field_72995_K) {
                    this.updateClient(stack, world, (EntityPlayer)entity, itemSlot, hand);
                } else {
                    this.updateServer(stack, world, (EntityPlayer)entity, itemSlot, hand);
                }
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.func_77973_b() != newStack.func_77973_b();
    }

    @SideOnly(value=Side.CLIENT)
    protected void updateClient(ItemStack stack, World world, EntityPlayer entity, int slot, EnumHand hand) {
        boolean clickLeft = Mouse.isButtonDown((int)0);
        boolean clickRight = Mouse.isButtonDown((int)1);
        boolean left = m1;
        boolean right = m2;
        if (hand != null) {
            if (left && right) {
                PacketDispatcher.wrapper.sendToServer((IMessage)new GunButtonPacket(false, 0, hand));
                PacketDispatcher.wrapper.sendToServer((IMessage)new GunButtonPacket(false, 1, hand));
                m1 = false;
                m2 = false;
            }
            if ((m1 || ItemGunBase.getIsMouseDown(stack)) && !clickLeft) {
                PacketDispatcher.wrapper.sendToServer((IMessage)new GunButtonPacket(false, 0, hand));
                m1 = false;
                this.endActionClient(stack, world, entity, true, hand);
            }
            if ((m2 || ItemGunBase.getIsAltDown(stack)) && !clickRight) {
                PacketDispatcher.wrapper.sendToServer((IMessage)new GunButtonPacket(false, 1, hand));
                m2 = false;
                this.endActionClient(stack, world, entity, false, hand);
            }
            if ((this.mainConfig.reloadType != 0 || this.altConfig != null && this.altConfig.reloadType != 0) && HbmKeybinds.reloadKey.func_151470_d() && (ItemGunBase.getMag(stack) < this.mainConfig.ammoCap || this.mainConfig.allowsInfinity && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0)) {
                PacketDispatcher.wrapper.sendToServer((IMessage)new GunButtonPacket(true, 2, hand));
                ItemGunBase.setIsReloading(stack, true);
                this.resetReloadCycle(stack);
            }
        }
        oldClickLeft = m1;
        oldClickRight = m2;
    }

    protected void updateServer(ItemStack stack, World world, EntityPlayer player, int slot, EnumHand hand) {
        if (ItemGunBase.getDelay(stack) > 0 && hand != null) {
            ItemGunBase.setDelay(stack, ItemGunBase.getDelay(stack) - 1);
        }
        if (ItemGunBase.getIsMouseDown(stack) && hand == null) {
            ItemGunBase.setIsMouseDown(stack, false);
        }
        if (ItemGunBase.getIsAltDown(stack) && hand == null) {
            ItemGunBase.setIsAltDown(stack, false);
        }
        if (GeneralConfig.enableGuns && this.mainConfig.firingMode == 1 && ItemGunBase.getIsMouseDown(stack) && this.tryShoot(stack, world, player, hand != null)) {
            this.fire(stack, world, player, hand);
            ItemGunBase.setDelay(stack, this.mainConfig.rateOfFire);
        }
        if (ItemGunBase.getIsReloading(stack) && hand != null) {
            this.reload2(stack, world, player, hand);
        }
    }

    protected boolean tryShoot(ItemStack stack, World world, EntityPlayer player, boolean main2) {
        if (main2 && ItemGunBase.getDelay(stack) == 0 && !ItemGunBase.getIsReloading(stack) && ItemGunBase.getItemWear(stack) < this.mainConfig.durability) {
            if (this.mainConfig.reloadType == 0) {
                return ItemGunBase.getBeltSize(player, ItemGunBase.getBeltType(player, stack, main2)) > 0;
            }
            return ItemGunBase.getMag(stack) > 0;
        }
        if (!main2 && this.altConfig != null && ItemGunBase.getDelay(stack) == 0 && !ItemGunBase.getIsReloading(stack) && ItemGunBase.getItemWear(stack) < this.mainConfig.durability) {
            if (this.altConfig.reloadType == 0) {
                return ItemGunBase.getBeltSize(player, ItemGunBase.getBeltType(player, stack, main2)) > 0;
            }
            return ItemGunBase.getMag(stack) > 0;
        }
        return false;
    }

    public boolean hasAmmo(ItemStack stack, EntityPlayer player, boolean main2) {
        if (this.mainConfig.reloadType == 0 || !main2) {
            return ItemGunBase.getBeltSize(player, ItemGunBase.getBeltType(player, stack, main2)) > 0;
        }
        return ItemGunBase.getMag(stack) > 0;
    }

    private void fire(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        BulletConfiguration config = null;
        config = this.mainConfig.reloadType == 0 ? ItemGunBase.getBeltCfg(player, stack, true) : BulletConfigSyncingUtil.pullConfig(this.mainConfig.config.get(ItemGunBase.getMagType(stack)));
        int bullets = this.getBullets(world, player, hand, config);
        for (int k = 0; k < this.mainConfig.roundsPerCycle && this.hasAmmo(stack, player, true); ++k) {
            for (int i = 0; i < bullets; ++i) {
                this.spawnProjectile(world, player, stack, BulletConfigSyncingUtil.getKey(config), hand);
            }
            this.useUpAmmo(player, stack, true);
            player.field_71069_bz.func_75142_b();
            int wear = (int)Math.ceil((float)config.wear / (1.0f + (float)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)stack)));
            ItemGunBase.setItemWear(stack, ItemGunBase.getItemWear(stack) + wear);
        }
        world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, this.mainConfig.firingSound, SoundCategory.PLAYERS, 1.0f, this.mainConfig.firingPitch);
        if (player.func_145748_c_().toString().equals("Vic4Games")) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("type", "justTilt");
            nbt.func_74768_a("time", this.mainConfig.rateOfFire + 1);
            PacketDispatcher.wrapper.sendTo((IMessage)new AuxParticlePacketNT(nbt, player.field_70165_t, player.field_70163_u, player.field_70161_v), (EntityPlayerMP)player);
        }
    }

    protected int getBullets(World world, EntityPlayer player, EnumHand hand, BulletConfiguration config) {
        int bullets = config.bulletsMin;
        if (config.bulletsMax > config.bulletsMin) {
            bullets += world.field_73012_v.nextInt(config.bulletsMax - config.bulletsMin);
        }
        return bullets;
    }

    protected void altFire(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (this.altConfig == null) {
            return;
        }
        BulletConfiguration config = ItemGunBase.getBeltCfg(player, stack, false);
        int bullets = config.bulletsMin;
        for (int k = 0; k < this.altConfig.roundsPerCycle && this.hasAmmo(stack, player, false); ++k) {
            if (config.bulletsMax > config.bulletsMin) {
                bullets += world.field_73012_v.nextInt(config.bulletsMax - config.bulletsMin);
            }
            for (int i = 0; i < bullets; ++i) {
                this.spawnProjectile(world, player, stack, BulletConfigSyncingUtil.getKey(config), hand);
            }
            this.useUpAmmo(player, stack, false);
            ItemGunBase.setItemWear(stack, ItemGunBase.getItemWear(stack) + config.wear);
            player.field_71069_bz.func_75142_b();
        }
        world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, this.altConfig.firingSound, SoundCategory.PLAYERS, 1.0f, this.altConfig.firingPitch);
    }

    protected EntityBulletBase getBulletEntity(World world, EntityPlayer player, ItemStack stack, int config, EnumHand hand) {
        return new EntityBulletBase(world, config, (EntityLivingBase)player, hand);
    }

    protected void spawnProjectile(World world, EntityPlayer player, ItemStack stack, int config, EnumHand hand) {
        world.func_72838_d((Entity)this.getBulletEntity(world, player, stack, config, hand));
        if (this.mainConfig.animations.containsKey((Object)HbmAnimations.AnimType.CYCLE) && player instanceof EntityPlayerMP) {
            PacketDispatcher.wrapper.sendTo((IMessage)new GunAnimationPacket(HbmAnimations.AnimType.CYCLE.ordinal(), hand), (EntityPlayerMP)player);
        }
        PacketDispatcher.wrapper.sendToAllTracking((IMessage)new GunFXPacket(player, hand, GunFXPacket.FXType.FIRE), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), player.field_70165_t, player.field_70163_u, player.field_70161_v, 1.0));
    }

    public void startAction(ItemStack stack, World world, EntityPlayer player, boolean main2, EnumHand hand) {
        if (this.mainConfig.firingMode == 0 && ItemGunBase.getIsMouseDown(stack) && this.tryShoot(stack, world, player, main2)) {
            this.fire(stack, world, player, hand);
            ItemGunBase.setDelay(stack, this.mainConfig.rateOfFire);
        }
        if (!main2 && this.altConfig != null && this.tryShoot(stack, world, player, main2)) {
            this.altFire(stack, world, player, hand);
            ItemGunBase.setDelay(stack, this.altConfig.rateOfFire);
        }
    }

    public void startActionClient(ItemStack stack, World world, EntityPlayer player, boolean main2, EnumHand hand) {
    }

    public void endAction(ItemStack stack, World world, EntityPlayer player, boolean main2, EnumHand hand) {
    }

    public void endActionClient(ItemStack stack, World world, EntityPlayer player, boolean main2, EnumHand hand) {
    }

    protected void reload2(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (ItemGunBase.getMag(stack) >= this.mainConfig.ammoCap) {
            ItemGunBase.setIsReloading(stack, false);
            return;
        }
        if (ItemGunBase.getReloadCycle(stack) < 0) {
            if (ItemGunBase.getMag(stack) == 0) {
                this.resetAmmoType(stack, world, player);
            }
            int count = 1;
            if (this.mainConfig.reloadType == 1) {
                count = this.mainConfig.ammoCap - ItemGunBase.getMag(stack);
            }
            BulletConfiguration cfg = BulletConfigSyncingUtil.pullConfig(this.mainConfig.config.get(ItemGunBase.getMagType(stack)));
            Item ammo = cfg.ammo;
            int loadCount = 0;
            for (int i = 0; i < count; ++i) {
                if (Library.hasInventoryItem(player.field_71071_by, ammo) && ItemGunBase.getMag(stack) < this.mainConfig.ammoCap) {
                    Library.consumeInventoryItem(player.field_71071_by, ammo);
                    ItemGunBase.setMag(stack, Math.min(ItemGunBase.getMag(stack) + cfg.ammoCount, this.mainConfig.ammoCap));
                    ++loadCount;
                    continue;
                }
                ItemGunBase.setIsReloading(stack, false);
                break;
            }
            if (ItemGunBase.getMag(stack) >= this.mainConfig.ammoCap) {
                ItemGunBase.setIsReloading(stack, false);
            } else {
                this.resetReloadCycle(stack);
            }
            if (loadCount > 0) {
                this.onAmmoLoad(world, player, stack, loadCount, hand);
            }
            if (loadCount > 0 && this.mainConfig.reloadSoundEnd && this.mainConfig.reloadSound != null) {
                world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, this.mainConfig.reloadSound, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
        } else {
            ItemGunBase.setReloadCycle(stack, ItemGunBase.getReloadCycle(stack) - 1);
        }
        if (stack != player.func_184586_b(hand)) {
            ItemGunBase.setReloadCycle(stack, 0);
            ItemGunBase.setIsReloading(stack, false);
        }
    }

    public void onAmmoLoad(World world, EntityPlayer player, ItemStack stack, int loadCount, EnumHand hand) {
    }

    public void startReloadAction(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (player.func_70093_af() && this.mainConfig.allowsInfinity && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0) {
            if (ItemGunBase.getMag(stack) == this.mainConfig.ammoCap) {
                ItemGunBase.setMag(stack, 0);
                this.resetAmmoType(stack, world, player);
                player.func_184185_a(SoundEvents.field_187715_dR, 1.0f, 1.0f);
            }
            return;
        }
        if (ItemGunBase.getMag(stack) == this.mainConfig.ammoCap) {
            return;
        }
        if (ItemGunBase.getIsReloading(stack)) {
            return;
        }
        if (!this.mainConfig.reloadSoundEnd && this.mainConfig.reloadSound != null) {
            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, this.mainConfig.reloadSound, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
        PacketDispatcher.wrapper.sendTo((IMessage)new GunAnimationPacket(HbmAnimations.AnimType.RELOAD.ordinal(), hand), (EntityPlayerMP)player);
        ItemGunBase.setIsReloading(stack, true);
        this.resetReloadCycle(stack);
    }

    public boolean canReload(ItemStack stack, World world, EntityPlayer player) {
        if (ItemGunBase.getMag(stack) == 0) {
            for (Integer config : this.mainConfig.config) {
                BulletConfiguration cfg = BulletConfigSyncingUtil.pullConfig(config);
                if (!Library.hasInventoryItem(player.field_71071_by, cfg.ammo)) continue;
                return true;
            }
        } else {
            Item ammo = BulletConfigSyncingUtil.pullConfig((int)this.mainConfig.config.get((int)ItemGunBase.getMagType((ItemStack)stack)).intValue()).ammo;
            return Library.hasInventoryItem(player.field_71071_by, ammo);
        }
        return false;
    }

    protected void resetAmmoType(ItemStack stack, World world, EntityPlayer player) {
        for (Integer config : this.mainConfig.config) {
            BulletConfiguration cfg = BulletConfigSyncingUtil.pullConfig(config);
            if (!Library.hasInventoryItem(player.field_71071_by, cfg.ammo)) continue;
            ItemGunBase.setMagType(stack, this.mainConfig.config.indexOf(config));
            break;
        }
    }

    public static String getColor(int a, int b) {
        float fraction = 100.0f * (float)a / (float)b;
        if (fraction > 75.0f) {
            return "\u00a7a";
        }
        if (fraction > 25.0f) {
            return "\u00a7e";
        }
        return "\u00a7c";
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> list, ITooltipFlag flagIn) {
        Item ammo = BulletConfigSyncingUtil.pullConfig((int)this.mainConfig.config.get((int)ItemGunBase.getMagType((ItemStack)stack)).intValue()).ammo;
        if (this.mainConfig.ammoCap > 0) {
            int mag = ItemGunBase.getMag(stack);
            list.add("Ammo: " + ItemGunBase.getColor(mag, this.mainConfig.ammoCap) + mag + " \u00a72/ " + this.mainConfig.ammoCap);
        } else {
            list.add("Ammo: \u00a76Belt");
        }
        list.add("Ammo Type: \u00a7e" + I18n.func_135052_a((String)(ammo.func_77658_a() + ".name"), (Object[])new Object[0]));
        int dura = this.mainConfig.durability - ItemGunBase.getItemWear(stack);
        if (dura < 0) {
            dura = 0;
        }
        list.add("Durability: " + ItemGunBase.getColor(dura, this.mainConfig.durability) + dura + " \u00a72/ " + this.mainConfig.durability);
        list.add("");
        list.add("Name: " + this.mainConfig.name);
        list.add("Manufacturer: " + this.mainConfig.manufacturer);
        if (!this.mainConfig.comment.isEmpty()) {
            list.add("");
            for (String s : this.mainConfig.comment) {
                list.add("\u00a76" + TextFormatting.ITALIC + s);
            }
        }
        if (GeneralConfig.enableExtendedLogging) {
            list.add("");
            list.add("Type: " + ItemGunBase.getMagType(stack));
            list.add("Is Reloading: " + ItemGunBase.getIsReloading(stack));
            list.add("Reload Cycle: " + ItemGunBase.getReloadCycle(stack));
            list.add("RoF Cooldown: " + ItemGunBase.getDelay(stack));
        }
    }

    public static Item getBeltType(EntityPlayer player, ItemStack stack, boolean main2) {
        if (!(stack.func_77973_b() instanceof ItemGunBase)) {
            return null;
        }
        ItemGunBase gun = (ItemGunBase)stack.func_77973_b();
        GunConfiguration guncfg = main2 ? gun.mainConfig : (gun.altConfig != null ? gun.altConfig : gun.mainConfig);
        Item ammo = BulletConfigSyncingUtil.pullConfig((int)guncfg.config.get((int)0).intValue()).ammo;
        for (Integer config : guncfg.config) {
            BulletConfiguration cfg = BulletConfigSyncingUtil.pullConfig(config);
            if (!Library.hasInventoryItem(player.field_71071_by, cfg.ammo)) continue;
            ammo = cfg.ammo;
            break;
        }
        return ammo;
    }

    public static BulletConfiguration getBeltCfg(EntityPlayer player, ItemStack stack, boolean main2) {
        ItemGunBase gun = (ItemGunBase)stack.func_77973_b();
        GunConfiguration guncfg = main2 ? gun.mainConfig : (gun.altConfig != null ? gun.altConfig : gun.mainConfig);
        ItemGunBase.getBeltType(player, stack, main2);
        for (Integer config : guncfg.config) {
            BulletConfiguration cfg = BulletConfigSyncingUtil.pullConfig(config);
            if (!Library.hasInventoryItem(player.field_71071_by, cfg.ammo)) continue;
            return cfg;
        }
        return BulletConfigSyncingUtil.pullConfig(guncfg.config.get(0));
    }

    public static int getBeltSize(EntityPlayer player, Item ammo) {
        int amount = 0;
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack == null || stack.func_77973_b() != ammo) continue;
            amount += stack.func_190916_E();
        }
        return amount;
    }

    public void useUpAmmo(EntityPlayer player, ItemStack stack, boolean main2) {
        if (!main2 && this.altConfig == null) {
            return;
        }
        GunConfiguration config = this.mainConfig;
        if (!main2) {
            config = this.altConfig;
        }
        if (config.allowsInfinity && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0) {
            return;
        }
        if (config.reloadType != 0) {
            ItemGunBase.setMag(stack, ItemGunBase.getMag(stack) - 1);
        } else {
            Library.consumeInventoryItem(player.field_71071_by, ItemGunBase.getBeltType(player, stack, main2));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onFireClient(ItemStack stack, EntityPlayer player, boolean shouldDoThirdPerson) {
    }

    @SideOnly(value=Side.CLIENT)
    public void playerWorldRender(EntityPlayer player, RenderWorldLastEvent e, EnumHand hand) {
    }

    public void resetReloadCycle(ItemStack stack) {
        ItemGunBase.writeNBT(stack, "reload", this.getReloadDuration(stack));
    }

    public int getReloadDuration(ItemStack stack) {
        return ((ItemGunBase)stack.func_77973_b()).mainConfig.reloadDuration;
    }

    public static void setIsReloading(ItemStack stack, boolean b) {
        ItemGunBase.writeNBT(stack, "isReloading", b ? 1 : 0);
    }

    public static boolean getIsReloading(ItemStack stack) {
        return ItemGunBase.readNBT(stack, "isReloading") == 1;
    }

    public static void setIsMouseDown(ItemStack stack, boolean b) {
        ItemGunBase.writeNBT(stack, "isMouseDown", b ? 1 : 0);
    }

    public static boolean getIsMouseDown(ItemStack stack) {
        return ItemGunBase.readNBT(stack, "isMouseDown") == 1;
    }

    public static void setIsAltDown(ItemStack stack, boolean b) {
        ItemGunBase.writeNBT(stack, "isAltDown", b ? 1 : 0);
    }

    public static boolean getIsAltDown(ItemStack stack) {
        return ItemGunBase.readNBT(stack, "isAltDown") == 1;
    }

    public static void setDelay(ItemStack stack, int i) {
        ItemGunBase.writeNBT(stack, "dlay", i);
    }

    public static int getDelay(ItemStack stack) {
        return ItemGunBase.readNBT(stack, "dlay");
    }

    public static void setItemWear(ItemStack stack, int i) {
        ItemGunBase.writeNBT(stack, "wear", i);
    }

    public static int getItemWear(ItemStack stack) {
        return ItemGunBase.readNBT(stack, "wear");
    }

    public static void setCycleAnim(ItemStack stack, int i) {
        ItemGunBase.writeNBT(stack, "cycle", i);
    }

    public static int getCycleAnim(ItemStack stack) {
        return ItemGunBase.readNBT(stack, "cycle");
    }

    public static void setReloadCycle(ItemStack stack, int i) {
        ItemGunBase.writeNBT(stack, "reload", i);
    }

    public static int getReloadCycle(ItemStack stack) {
        return ItemGunBase.readNBT(stack, "reload");
    }

    public static void setMag(ItemStack stack, int i) {
        ItemGunBase.writeNBT(stack, "magazine", i);
    }

    public static int getMag(ItemStack stack) {
        return ItemGunBase.readNBT(stack, "magazine");
    }

    public static void setMagType(ItemStack stack, int i) {
        ItemGunBase.writeNBT(stack, "magazineType", i);
    }

    public static int getMagType(ItemStack stack) {
        return ItemGunBase.readNBT(stack, "magazineType");
    }

    protected static void writeNBT(ItemStack stack, String key, int value) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a(key, value);
    }

    public static int readNBT(ItemStack stack, String key) {
        if (!stack.func_77942_o()) {
            return 0;
        }
        return stack.func_77978_p().func_74762_e(key);
    }

    @Override
    public RenderScreenOverlay.Crosshair getCrosshair() {
        return this.mainConfig.crosshair;
    }

    @SideOnly(value=Side.CLIENT)
    public void startAnim(EntityPlayer player, ItemStack stack, int slot, HbmAnimations.AnimType type) {
        GunConfiguration config = ((ItemGunBase)stack.func_77973_b()).mainConfig;
        BusAnimation animation = config.animations.get((Object)type);
        if (animation != null) {
            HbmAnimations.hotbar[slot] = new HbmAnimations.Animation(stack.func_77973_b().func_77658_a(), System.currentTimeMillis(), animation);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderHUD(RenderGameOverlayEvent.Pre event, RenderGameOverlayEvent.ElementType type, EntityPlayer player, ItemStack stack, EnumHand hand) {
        ItemGunBase gun = (ItemGunBase)player.func_184586_b(hand).func_77973_b();
        GunConfiguration gcfg = gun.mainConfig;
        if (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            BulletConfiguration bcfg = BulletConfigSyncingUtil.pullConfig(gun.mainConfig.config.get(ItemGunBase.getMagType(player.func_184586_b(hand))));
            Item ammo = bcfg.ammo;
            int count = ItemGunBase.getMag(player.func_184586_b(hand));
            int max = gcfg.ammoCap;
            boolean showammo = gcfg.showAmmo;
            if (gcfg.reloadType == 0) {
                ammo = ItemGunBase.getBeltType(player, player.func_184586_b(hand), true);
                count = ItemGunBase.getBeltSize(player, ammo);
                max = -1;
            }
            int dura = ItemGunBase.getItemWear(player.func_184586_b(hand)) * 50 / gcfg.durability;
            RenderScreenOverlay.renderAmmo(event.getResolution(), (Gui)Minecraft.func_71410_x().field_71456_v, ammo, count, max, dura, hand, showammo);
            if (gun.altConfig != null && gun.altConfig.reloadType == 0) {
                Item oldAmmo = ammo;
                ammo = ItemGunBase.getBeltType(player, player.func_184586_b(hand), false);
                if (ammo != oldAmmo) {
                    count = ItemGunBase.getBeltSize(player, ammo);
                    RenderScreenOverlay.renderAmmoAlt(event.getResolution(), (Gui)Minecraft.func_71410_x().field_71456_v, ammo, count, hand);
                }
            }
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS && GeneralConfig.enableCrosshairs && (hand != EnumHand.OFF_HAND || !(player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof IHoldableWeapon))) {
            event.setCanceled(true);
            if (((IHoldableWeapon)player.func_184586_b(hand).func_77973_b()).hasCustomHudElement()) {
                ((IHoldableWeapon)player.func_184586_b(hand).func_77973_b()).renderHud(event.getResolution(), Minecraft.func_71410_x().field_71456_v, player.func_184614_ca(), event.getPartialTicks());
            } else if (!gcfg.hasSights || !player.func_70093_af()) {
                RenderScreenOverlay.renderCustomCrosshairs(event.getResolution(), (Gui)Minecraft.func_71410_x().field_71456_v, ((IHoldableWeapon)player.func_184586_b(hand).func_77973_b()).getCrosshair());
            } else {
                RenderScreenOverlay.renderCustomCrosshairs(event.getResolution(), (Gui)Minecraft.func_71410_x().field_71456_v, RenderScreenOverlay.Crosshair.NONE);
            }
        }
    }
}

