/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.APPLEVertexArrayObject;
import org.lwjgl.opengl.ARBDrawInstanced;
import org.lwjgl.opengl.ARBFramebufferObject;
import org.lwjgl.opengl.ARBImaging;
import org.lwjgl.opengl.ARBInstancedArrays;
import org.lwjgl.opengl.ARBMultitexture;
import org.lwjgl.opengl.ARBOcclusionQuery;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.ARBVertexArrayObject;
import org.lwjgl.opengl.ARBVertexBufferObject;
import org.lwjgl.opengl.ARBVertexProgram;
import org.lwjgl.opengl.ARBVertexShader;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.EXTDrawInstanced;
import org.lwjgl.opengl.EXTFramebufferBlit;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL31;
import org.lwjgl.opengl.GL33;
import org.lwjgl.opengl.GLContext;

public class GLCompat {
    public static String error = "";
    public static int GL_ARRAY_BUFFER;
    public static int GL_ELEMENT_ARRAY_BUFFER;
    public static int GL_DYNAMIC_DRAW;
    public static int GL_STATIC_DRAW;
    public static int GL_TEXTURE0;
    public static int GL_RENDERBUFFER;
    public static int GL_FRAMEBUFFER;
    public static int GL_READ_FRAMEBUFFER;
    public static int GL_DRAW_FRAMEBUFFER;
    public static int GL_RGBA16F;
    public static int GL_DEPTH_ATTACHMENT;
    public static int GL_COLOR_ATTACHMENT0;
    public static int GL_DEPTH_COMPONENT24;
    public static int GL_VERTEX_SHADER;
    public static int GL_FRAGMENT_SHADER;
    public static int GL_COMPILE_STATUS;
    public static int GL_LINK_STATUS;
    public static int GL_INFO_LOG_LENGTH;
    public static int GL_CURRENT_PROGRAM;
    public static int GL_FUNC_ADD;
    public static int GL_MAX;
    public static int GL_SAMPLES_PASSED;
    public static int GL_QUERY_RESULT_AVAILABLE;
    public static int GL_QUERY_RESULT;
    public static VAOType vaoType;
    public static FBOType fboType;
    public static InstancingType instancingType;
    public static boolean arbInstancedArrays;
    public static boolean arbImaging;
    public static boolean arbVbo;
    public static boolean arbShaderObject;
    public static boolean arbVertexProgram;
    public static boolean arbVertexShader;
    public static boolean arbFragmentShader;
    public static boolean arbMultitexture;
    public static boolean arbOcclusionQuery;

    public static int genVertexArrays() {
        switch (vaoType) {
            case NORMAL: {
                return GL30.glGenVertexArrays();
            }
            case ARB: {
                return ARBVertexArrayObject.glGenVertexArrays();
            }
            case APPLE: {
                return APPLEVertexArrayObject.glGenVertexArraysAPPLE();
            }
        }
        return 0;
    }

    public static void bindVertexArray(int vao) {
        switch (vaoType) {
            case NORMAL: {
                GL30.glBindVertexArray((int)vao);
                break;
            }
            case ARB: {
                ARBVertexArrayObject.glBindVertexArray((int)vao);
                break;
            }
            case APPLE: {
                APPLEVertexArrayObject.glBindVertexArrayAPPLE((int)vao);
            }
        }
    }

    public static int genBuffers() {
        if (arbVbo) {
            return ARBVertexBufferObject.glGenBuffersARB();
        }
        return GL15.glGenBuffers();
    }

    public static void bindBuffer(int target, int buf) {
        if (arbVbo) {
            ARBVertexBufferObject.glBindBufferARB((int)target, (int)buf);
        } else {
            GL15.glBindBuffer((int)target, (int)buf);
        }
    }

    public static void bufferData(int target, ByteBuffer data, int usage) {
        if (arbVbo) {
            ARBVertexBufferObject.glBufferDataARB((int)target, (ByteBuffer)data, (int)usage);
        } else {
            GL15.glBufferData((int)target, (ByteBuffer)data, (int)usage);
        }
    }

    public static void vertexAttribPointer(int index, int size, int type, boolean normalized, int stride, long offset2) {
        if (arbVertexProgram) {
            ARBVertexProgram.glVertexAttribPointerARB((int)index, (int)size, (int)type, (boolean)normalized, (int)stride, (long)offset2);
        } else {
            GL20.glVertexAttribPointer((int)index, (int)size, (int)type, (boolean)normalized, (int)stride, (long)offset2);
        }
    }

    public static void enableVertexAttribArray(int index) {
        if (arbVertexProgram) {
            ARBVertexProgram.glEnableVertexAttribArrayARB((int)index);
        } else {
            GL20.glEnableVertexAttribArray((int)index);
        }
    }

    public static void disableVertexAttribArray(int index) {
        if (arbVertexProgram) {
            ARBVertexProgram.glDisableVertexAttribArrayARB((int)index);
        } else {
            GL20.glDisableVertexAttribArray((int)index);
        }
    }

    public static void bindAttribLocation(int program, int index, CharSequence name) {
        if (arbVertexShader) {
            ARBVertexShader.glBindAttribLocationARB((int)program, (int)index, (CharSequence)name);
        } else {
            GL20.glBindAttribLocation((int)program, (int)index, (CharSequence)name);
        }
    }

    public static void deleteFramebuffers(int framebuffer) {
        switch (fboType) {
            case NORMAL: {
                GL30.glDeleteFramebuffers((int)framebuffer);
                break;
            }
            case ARB: {
                ARBFramebufferObject.glDeleteFramebuffers((int)framebuffer);
                break;
            }
            case EXT: {
                EXTFramebufferObject.glDeleteFramebuffersEXT((int)framebuffer);
            }
        }
    }

    public static void bindFramebuffer(int target, int framebuffer) {
        switch (fboType) {
            case NORMAL: {
                GL30.glBindFramebuffer((int)target, (int)framebuffer);
                break;
            }
            case ARB: {
                ARBFramebufferObject.glBindFramebuffer((int)target, (int)framebuffer);
                break;
            }
            case EXT: {
                EXTFramebufferObject.glBindFramebufferEXT((int)target, (int)framebuffer);
            }
        }
    }

    public static void framebufferTexture2D(int target, int attachment, int textarget, int texture, int level) {
        switch (fboType) {
            case NORMAL: {
                GL30.glFramebufferTexture2D((int)target, (int)attachment, (int)textarget, (int)texture, (int)level);
                break;
            }
            case ARB: {
                ARBFramebufferObject.glFramebufferTexture2D((int)target, (int)attachment, (int)textarget, (int)texture, (int)level);
                break;
            }
            case EXT: {
                EXTFramebufferObject.glFramebufferTexture2DEXT((int)target, (int)attachment, (int)textarget, (int)texture, (int)level);
            }
        }
    }

    public static void bindRenderbuffer(int target, int renderbuffer) {
        switch (fboType) {
            case NORMAL: {
                GL30.glBindRenderbuffer((int)target, (int)renderbuffer);
                break;
            }
            case ARB: {
                ARBFramebufferObject.glBindRenderbuffer((int)target, (int)renderbuffer);
                break;
            }
            case EXT: {
                EXTFramebufferObject.glBindRenderbufferEXT((int)target, (int)renderbuffer);
            }
        }
    }

    public static int genRenderbuffers() {
        switch (fboType) {
            case NORMAL: {
                return GL30.glGenRenderbuffers();
            }
            case ARB: {
                return ARBFramebufferObject.glGenRenderbuffers();
            }
            case EXT: {
                return EXTFramebufferObject.glGenRenderbuffersEXT();
            }
        }
        return 0;
    }

    public static void renderbufferStorage(int target, int internalformat, int width, int height) {
        switch (fboType) {
            case NORMAL: {
                GL30.glRenderbufferStorage((int)target, (int)internalformat, (int)width, (int)height);
                break;
            }
            case ARB: {
                ARBFramebufferObject.glRenderbufferStorage((int)target, (int)internalformat, (int)width, (int)height);
                break;
            }
            case EXT: {
                EXTFramebufferObject.glRenderbufferStorageEXT((int)target, (int)internalformat, (int)width, (int)height);
            }
        }
    }

    public static void framebufferRenderbuffer(int target, int attachment, int renderbuffertarget, int renderbuffer) {
        switch (fboType) {
            case NORMAL: {
                GL30.glFramebufferRenderbuffer((int)target, (int)attachment, (int)renderbuffertarget, (int)renderbuffer);
                break;
            }
            case ARB: {
                ARBFramebufferObject.glFramebufferRenderbuffer((int)target, (int)attachment, (int)renderbuffertarget, (int)renderbuffer);
                break;
            }
            case EXT: {
                EXTFramebufferObject.glFramebufferRenderbufferEXT((int)target, (int)attachment, (int)renderbuffertarget, (int)renderbuffer);
            }
        }
    }

    public static void deleteRenderbuffers(int renderbuffer) {
        switch (fboType) {
            case NORMAL: {
                GL30.glDeleteRenderbuffers((int)renderbuffer);
                break;
            }
            case ARB: {
                ARBFramebufferObject.glDeleteRenderbuffers((int)renderbuffer);
                break;
            }
            case EXT: {
                EXTFramebufferObject.glDeleteRenderbuffersEXT((int)renderbuffer);
            }
        }
    }

    public static int genFramebuffers() {
        switch (fboType) {
            case NORMAL: {
                return GL30.glGenFramebuffers();
            }
            case ARB: {
                return ARBFramebufferObject.glGenFramebuffers();
            }
            case EXT: {
                return EXTFramebufferObject.glGenFramebuffersEXT();
            }
        }
        return 0;
    }

    public static void blitFramebuffer(int srcX0, int srcY0, int srcX1, int srcY1, int dstX0, int dstY0, int dstX1, int dstY1, int mask, int filter) {
        switch (fboType) {
            case NORMAL: {
                GL30.glBlitFramebuffer((int)srcX0, (int)srcY0, (int)srcX1, (int)srcY1, (int)dstX0, (int)dstY0, (int)dstX1, (int)dstY1, (int)mask, (int)filter);
                break;
            }
            case ARB: {
                ARBFramebufferObject.glBlitFramebuffer((int)srcX0, (int)srcY0, (int)srcX1, (int)srcY1, (int)dstX0, (int)dstY0, (int)dstX1, (int)dstY1, (int)mask, (int)filter);
                break;
            }
            case EXT: {
                EXTFramebufferBlit.glBlitFramebufferEXT((int)srcX0, (int)srcY0, (int)srcX1, (int)srcY1, (int)dstX0, (int)dstY0, (int)dstX1, (int)dstY1, (int)mask, (int)filter);
            }
        }
    }

    public static void activeTexture(int tex) {
        if (arbMultitexture) {
            ARBMultitexture.glActiveTextureARB((int)tex);
        } else {
            GL13.glActiveTexture((int)tex);
        }
    }

    public static void blendEquation(int mode) {
        if (arbImaging) {
            ARBImaging.glBlendEquation((int)mode);
        } else {
            GL14.glBlendEquation((int)mode);
        }
    }

    public static void drawArraysInstanced(int mode, int first, int count, int primcount) {
        switch (instancingType) {
            case NORMAL: {
                GL31.glDrawArraysInstanced((int)mode, (int)first, (int)count, (int)primcount);
                break;
            }
            case ARB: {
                ARBDrawInstanced.glDrawArraysInstancedARB((int)mode, (int)first, (int)count, (int)primcount);
                break;
            }
            case EXT: {
                EXTDrawInstanced.glDrawArraysInstancedEXT((int)mode, (int)first, (int)count, (int)primcount);
            }
        }
    }

    public static void vertexAttribDivisor(int index, int divisor) {
        if (arbInstancedArrays) {
            ARBInstancedArrays.glVertexAttribDivisorARB((int)index, (int)divisor);
        } else {
            GL33.glVertexAttribDivisor((int)index, (int)divisor);
        }
    }

    public static int genQueries() {
        if (arbOcclusionQuery) {
            return ARBOcclusionQuery.glGenQueriesARB();
        }
        return GL15.glGenQueries();
    }

    public static void beginQuery(int target, int id) {
        if (arbOcclusionQuery) {
            ARBOcclusionQuery.glBeginQueryARB((int)target, (int)id);
        } else {
            GL15.glBeginQuery((int)target, (int)id);
        }
    }

    public static void endQuery(int target) {
        if (arbOcclusionQuery) {
            ARBOcclusionQuery.glEndQueryARB((int)target);
        } else {
            GL15.glEndQuery((int)target);
        }
    }

    public static void deleteQueries(int id) {
        if (arbOcclusionQuery) {
            ARBOcclusionQuery.glDeleteQueriesARB((int)id);
        } else {
            GL15.glDeleteQueries((int)id);
        }
    }

    public static int getQueryObject(int id, int pname) {
        if (arbOcclusionQuery) {
            return ARBOcclusionQuery.glGetQueryObjectuiARB((int)id, (int)pname);
        }
        return GL15.glGetQueryObjectui((int)id, (int)pname);
    }

    public static int getUniformLocation(int program, CharSequence name) {
        if (arbShaderObject) {
            return ARBShaderObjects.glGetUniformLocationARB((int)program, (CharSequence)name);
        }
        return GL20.glGetUniformLocation((int)program, (CharSequence)name);
    }

    public static void uniform1i(int location, int i) {
        if (arbShaderObject) {
            ARBShaderObjects.glUniform1iARB((int)location, (int)i);
        } else {
            GL20.glUniform1i((int)location, (int)i);
        }
    }

    public static void uniform1f(int location, float f) {
        if (arbShaderObject) {
            ARBShaderObjects.glUniform1fARB((int)location, (float)f);
        } else {
            GL20.glUniform1f((int)location, (float)f);
        }
    }

    public static void uniform2f(int location, float f1, float f2) {
        if (arbShaderObject) {
            ARBShaderObjects.glUniform2fARB((int)location, (float)f1, (float)f2);
        } else {
            GL20.glUniform2f((int)location, (float)f1, (float)f2);
        }
    }

    public static void uniform3f(int location, float f1, float f2, float f3) {
        if (arbShaderObject) {
            ARBShaderObjects.glUniform3fARB((int)location, (float)f1, (float)f2, (float)f3);
        } else {
            GL20.glUniform3f((int)location, (float)f1, (float)f2, (float)f3);
        }
    }

    public static void uniform4f(int location, float f1, float f2, float f3, float f4) {
        if (arbShaderObject) {
            ARBShaderObjects.glUniform4fARB((int)location, (float)f1, (float)f2, (float)f3, (float)f4);
        } else {
            GL20.glUniform4f((int)location, (float)f1, (float)f2, (float)f3, (float)f4);
        }
    }

    public static void uniformMatrix3(int location, boolean transpose, FloatBuffer matrices) {
        if (arbShaderObject) {
            ARBShaderObjects.glUniformMatrix3ARB((int)location, (boolean)transpose, (FloatBuffer)matrices);
        } else {
            GL20.glUniformMatrix3((int)location, (boolean)transpose, (FloatBuffer)matrices);
        }
    }

    public static void uniformMatrix4(int location, boolean transpose, FloatBuffer matrices) {
        if (arbShaderObject) {
            ARBShaderObjects.glUniformMatrix4ARB((int)location, (boolean)transpose, (FloatBuffer)matrices);
        } else {
            GL20.glUniformMatrix4((int)location, (boolean)transpose, (FloatBuffer)matrices);
        }
    }

    public static int createProgram() {
        if (arbShaderObject) {
            return ARBShaderObjects.glCreateProgramObjectARB();
        }
        return GL20.glCreateProgram();
    }

    public static int createShader(int shaderType) {
        if (arbShaderObject) {
            return ARBShaderObjects.glCreateShaderObjectARB((int)shaderType);
        }
        return GL20.glCreateShader((int)shaderType);
    }

    public static void shaderSource(int shader, ByteBuffer string) {
        if (arbShaderObject) {
            ARBShaderObjects.glShaderSourceARB((int)shader, (ByteBuffer)string);
        } else {
            GL20.glShaderSource((int)shader, (ByteBuffer)string);
        }
    }

    public static void compileShader(int shader) {
        if (arbShaderObject) {
            ARBShaderObjects.glCompileShaderARB((int)shader);
        } else {
            GL20.glCompileShader((int)shader);
        }
    }

    public static int getShaderi(int shader, int pname) {
        if (arbShaderObject) {
            return ARBShaderObjects.glGetObjectParameteriARB((int)shader, (int)pname);
        }
        return GL20.glGetShaderi((int)shader, (int)pname);
    }

    public static String getShaderInfoLog(int shader, int length) {
        if (arbShaderObject) {
            return ARBShaderObjects.glGetInfoLogARB((int)shader, (int)length);
        }
        return GL20.glGetShaderInfoLog((int)shader, (int)length);
    }

    public static void attachShader(int program, int shader) {
        if (arbShaderObject) {
            ARBShaderObjects.glAttachObjectARB((int)program, (int)shader);
        } else {
            GL20.glAttachShader((int)program, (int)shader);
        }
    }

    public static void linkProgram(int program) {
        if (arbShaderObject) {
            ARBShaderObjects.glLinkProgramARB((int)program);
        } else {
            GL20.glLinkProgram((int)program);
        }
    }

    public static int getProgrami(int program, int pname) {
        if (arbShaderObject) {
            return ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)pname);
        }
        return GL20.glGetProgrami((int)program, (int)pname);
    }

    public static String getProgramInfoLog(int program, int length) {
        if (arbShaderObject) {
            return ARBShaderObjects.glGetInfoLogARB((int)program, (int)length);
        }
        return GL20.glGetProgramInfoLog((int)program, (int)length);
    }

    public static void deleteShader(int shader) {
        if (arbShaderObject) {
            ARBShaderObjects.glDeleteObjectARB((int)shader);
        } else {
            GL20.glDeleteShader((int)shader);
        }
    }

    public static void useProgram(int program) {
        if (arbShaderObject) {
            ARBShaderObjects.glUseProgramObjectARB((int)program);
        } else {
            GL20.glUseProgram((int)program);
        }
    }

    public static String init() {
        ContextCapabilities cap = GLContext.getCapabilities();
        if (cap.OpenGL30) {
            vaoType = VAOType.NORMAL;
        } else if (Minecraft.field_142025_a) {
            vaoType = VAOType.APPLE;
        } else if (cap.GL_ARB_vertex_array_object) {
            vaoType = VAOType.ARB;
        } else {
            return "VAO not supported";
        }
        if (cap.OpenGL15) {
            arbVbo = false;
        } else if (cap.GL_ARB_vertex_buffer_object) {
            arbVbo = true;
        } else {
            return "VBO not supported";
        }
        if (cap.OpenGL31) {
            instancingType = InstancingType.NORMAL;
        } else if (cap.GL_ARB_draw_instanced) {
            instancingType = InstancingType.ARB;
        } else if (cap.GL_EXT_draw_instanced) {
            instancingType = InstancingType.EXT;
        } else {
            return "Instancing not supported";
        }
        if (cap.OpenGL33) {
            arbInstancedArrays = false;
        } else if (cap.GL_ARB_instanced_arrays) {
            arbInstancedArrays = true;
        } else {
            return "Instanced arrays not supported";
        }
        if (cap.OpenGL20) {
            arbShaderObject = false;
        } else if (cap.GL_ARB_shader_objects) {
            arbShaderObject = true;
        } else {
            return "Shaders not supported";
        }
        if (cap.OpenGL20) {
            arbVertexProgram = false;
        } else if (cap.GL_ARB_vertex_program) {
            arbVertexProgram = true;
        } else {
            return "Vertex program not supported";
        }
        if (cap.OpenGL20) {
            arbVertexShader = false;
        } else if (cap.GL_ARB_vertex_shader) {
            arbVertexShader = true;
        } else {
            return "Vertex shader not supported";
        }
        if (cap.OpenGL20) {
            arbFragmentShader = false;
        } else if (cap.GL_ARB_fragment_shader) {
            arbFragmentShader = true;
        } else {
            return "Fragment shader not supported";
        }
        if (cap.OpenGL30) {
            fboType = FBOType.NORMAL;
        } else if (cap.GL_ARB_framebuffer_object) {
            fboType = FBOType.ARB;
        } else if (cap.GL_EXT_framebuffer_object && cap.GL_EXT_framebuffer_blit) {
            fboType = FBOType.EXT;
        } else {
            return "Framebuffer objects not supported";
        }
        if (cap.OpenGL13) {
            arbMultitexture = false;
        } else if (cap.GL_ARB_multitexture) {
            arbMultitexture = true;
        } else {
            return "Multitexturing not supported";
        }
        if (cap.OpenGL14) {
            arbImaging = false;
        } else if (cap.GL_ARB_imaging) {
            arbImaging = true;
        } else {
            return "Imaging not supported";
        }
        if (cap.OpenGL15) {
            arbOcclusionQuery = false;
        } else if (cap.GL_ARB_occlusion_query) {
            arbOcclusionQuery = true;
        } else {
            return "Occlusion queries not supported";
        }
        if (arbVertexProgram) {
            GL_ARRAY_BUFFER = 34962;
            GL_ELEMENT_ARRAY_BUFFER = 34963;
            GL_DYNAMIC_DRAW = 35048;
            GL_STATIC_DRAW = 35044;
        } else {
            GL_ARRAY_BUFFER = 34962;
            GL_ELEMENT_ARRAY_BUFFER = 34963;
            GL_DYNAMIC_DRAW = 35048;
            GL_STATIC_DRAW = 35044;
        }
        GL_TEXTURE0 = arbMultitexture ? 33984 : 33984;
        if (fboType == FBOType.NORMAL) {
            GL_RENDERBUFFER = 36161;
            GL_FRAMEBUFFER = 36160;
            GL_READ_FRAMEBUFFER = 36008;
            GL_DRAW_FRAMEBUFFER = 36009;
            GL_DEPTH_ATTACHMENT = 36096;
            GL_COLOR_ATTACHMENT0 = 36064;
        } else if (fboType == FBOType.ARB) {
            GL_RENDERBUFFER = 36161;
            GL_FRAMEBUFFER = 36160;
            GL_READ_FRAMEBUFFER = 36008;
            GL_DRAW_FRAMEBUFFER = 36009;
            GL_DEPTH_ATTACHMENT = 36096;
            GL_COLOR_ATTACHMENT0 = 36064;
        } else if (fboType == FBOType.EXT) {
            GL_RENDERBUFFER = 36161;
            GL_FRAMEBUFFER = 36160;
            GL_READ_FRAMEBUFFER = 36008;
            GL_DRAW_FRAMEBUFFER = 36009;
            GL_DEPTH_ATTACHMENT = 36096;
            GL_COLOR_ATTACHMENT0 = 36064;
        }
        if (cap.OpenGL30) {
            GL_RGBA16F = 34842;
        } else if (cap.GL_APPLE_float_pixels) {
            GL_RGBA16F = 34842;
        } else if (cap.GL_ARB_texture_float) {
            GL_RGBA16F = 34842;
        } else if (cap.GL_ATI_texture_float) {
            GL_RGBA16F = 34842;
        } else {
            return "Floating point texture format not supported";
        }
        if (cap.OpenGL14) {
            GL_DEPTH_COMPONENT24 = 33190;
        } else if (cap.GL_ARB_depth_texture) {
            GL_DEPTH_COMPONENT24 = 33190;
        } else {
            return "24 bit depth not supported";
        }
        if (arbShaderObject) {
            GL_COMPILE_STATUS = 35713;
            GL_LINK_STATUS = 35714;
            GL_INFO_LOG_LENGTH = 35716;
            GL_CURRENT_PROGRAM = 35725;
        } else {
            GL_COMPILE_STATUS = 35713;
            GL_LINK_STATUS = 35714;
            GL_INFO_LOG_LENGTH = 35716;
            GL_CURRENT_PROGRAM = 35725;
        }
        GL_VERTEX_SHADER = arbVertexShader ? 35633 : 35633;
        GL_FRAGMENT_SHADER = arbFragmentShader ? 35632 : 35632;
        if (arbImaging) {
            GL_FUNC_ADD = 32774;
            GL_MAX = 32776;
        } else {
            GL_FUNC_ADD = 32774;
            GL_MAX = 32776;
        }
        if (arbOcclusionQuery) {
            GL_SAMPLES_PASSED = 35092;
            GL_QUERY_RESULT_AVAILABLE = 34919;
            GL_QUERY_RESULT = 34918;
        } else {
            GL_SAMPLES_PASSED = 35092;
            GL_QUERY_RESULT_AVAILABLE = 34919;
            GL_QUERY_RESULT = 34918;
        }
        return "";
    }

    public static enum VAOType {
        NORMAL,
        ARB,
        APPLE;

    }

    public static enum FBOType {
        NORMAL,
        ARB,
        EXT;

    }

    public static enum InstancingType {
        NORMAL,
        ARB,
        EXT;

    }
}

