/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.icon;

import com.google.common.collect.Lists;
import com.hbm.main.MainRegistry;
import com.hbm.render.icon.RGBMutator;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.PngSizeInfo;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.AnimationFrame;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.compress.utils.IOUtils;

@SideOnly(value=Side.CLIENT)
public class TextureAtlasSpriteMutatable
extends TextureAtlasSprite {
    private RGBMutator mutator;
    public String basePath = "textures";
    private int mipmap = 0;

    public TextureAtlasSpriteMutatable(String iconName, RGBMutator mutator) {
        super(iconName);
        this.mutator = mutator;
    }

    public void func_188539_a(IResource resource, int mipmapLevels) throws IOException {
        Object frame;
        AnimationMetadataSection animationMetadataSection;
        BufferedImage bufferedImage = ImageIO.read(resource.func_110527_b());
        if (bufferedImage == null) {
            MainRegistry.logger.warn("Failed to load texture " + this.func_94215_i() + " from " + resource.func_177241_a());
        }
        if ((animationMetadataSection = (AnimationMetadataSection)resource.func_110526_a("animation")) == null) {
            MainRegistry.logger.warn("No animation metadata found for " + this.func_94215_i());
        }
        int[][] frameData = new int[mipmapLevels][];
        frameData[0] = new int[bufferedImage.getWidth() * bufferedImage.getHeight()];
        bufferedImage.getRGB(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), frameData[0], 0, bufferedImage.getWidth());
        if (this.mutator != null) {
            for (int i = 0; i < mipmapLevels; ++i) {
                if (frameData[i] == null) continue;
                frame = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getType());
                ((BufferedImage)frame).setRGB(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), frameData[i], 0, bufferedImage.getWidth());
                this.mutator.mutate((BufferedImage)frame, i, mipmapLevels);
                ((BufferedImage)frame).getRGB(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), frameData[i], 0, bufferedImage.getWidth());
            }
        }
        if (animationMetadataSection == null) {
            this.field_110976_a.add(frameData);
        } else {
            int frameCount = bufferedImage.getHeight() / this.field_130223_c;
            if (animationMetadataSection.func_110473_c() > 0) {
                frame = animationMetadataSection.func_130073_e().iterator();
                while (frame.hasNext()) {
                    int frameIndex = (Integer)frame.next();
                    if (frameIndex >= frameCount) {
                        throw new RuntimeException("Invalid frame index " + frameIndex);
                    }
                    this.allocateFrameTextureData(frameIndex);
                    this.field_110976_a.set(frameIndex, TextureAtlasSpriteMutatable.getFrameTextureData(frameData, this.field_130223_c, this.field_130223_c, frameIndex));
                }
                this.setAnimationMetadata(animationMetadataSection);
            } else {
                ArrayList frames = Lists.newArrayList();
                for (int i = 0; i < frameCount; ++i) {
                    this.field_110976_a.add(TextureAtlasSpriteMutatable.getFrameTextureData(frameData, this.field_130223_c, this.field_130223_c, i));
                    frames.add(new AnimationFrame(i, -1));
                }
                this.setAnimationMetadata(new AnimationMetadataSection((List)frames, this.field_130223_c, this.field_130224_d, animationMetadataSection.func_110469_d(), animationMetadataSection.func_177219_e()));
            }
        }
    }

    private static int[][] getFrameTextureData(int[][] data, int width, int height, int frame) {
        int[][] result = new int[data.length][];
        for (int i = 0; i < data.length; ++i) {
            int[] pixels = data[i];
            if (pixels == null) continue;
            result[i] = new int[(width >> i) * (height >> i)];
            System.arraycopy(pixels, frame * result[i].length, result[i], 0, result[i].length);
        }
        return result;
    }

    public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(IResourceManager man, ResourceLocation resourcelocation, Function<ResourceLocation, TextureAtlasSprite> textureGetter) {
        String pathName = resourcelocation.func_110623_a();
        String undashedPath = pathName.substring(0, pathName.indexOf(45));
        String truncatedPath = undashedPath.substring(undashedPath.indexOf(47) + 1);
        resourcelocation = new ResourceLocation(resourcelocation.func_110624_b(), truncatedPath);
        ResourceLocation resourcelocation1 = this.completeResourceLocation(resourcelocation);
        MainRegistry.logger.info("Loading texture " + resourcelocation1);
        IResource iresource = null;
        try {
            iresource = man.func_110536_a(resourcelocation1);
            PngSizeInfo pngSizeInfo = PngSizeInfo.func_188532_a((IResource)iresource);
            boolean hasAnimation = iresource.func_110526_a("animation") != null;
            this.func_188538_a(pngSizeInfo, hasAnimation);
            this.mipmap = Minecraft.func_71410_x().func_147117_R().getMipmapLevels() + 1;
            iresource = man.func_110536_a(resourcelocation1);
            this.func_188539_a(iresource, this.mipmap);
        }
        catch (IOException | RuntimeException e) {
            FMLClientHandler.instance().trackBrokenTexture(resourcelocation1, e.getMessage());
            boolean bl = true;
            return bl;
        }
        finally {
            IOUtils.closeQuietly((Closeable)iresource);
        }
        return false;
    }

    private ResourceLocation completeResourceLocation(ResourceLocation loc) {
        return new ResourceLocation(loc.func_110624_b(), String.format("%s/%s%s", this.basePath, loc.func_110623_a(), ".png"));
    }

    private void setAnimationMetadata(AnimationMetadataSection metadata) {
        try {
            Field field = ReflectionHelper.findField(TextureAtlasSprite.class, (String)"animationMetadata", (String)"field_110982_k");
            field.setAccessible(true);
            field.set((Object)this, metadata);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to set animation metadata", e);
        }
    }

    private void allocateFrameTextureData(int index) {
        if (this.field_110976_a.size() <= index) {
            for (int i = this.field_110976_a.size(); i <= index; ++i) {
                this.field_110976_a.add(null);
            }
        }
    }
}

