/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.misc;

import com.hbm.config.GeneralConfig;
import com.hbm.handler.HbmShaderManager2;
import com.hbm.main.ResourceManager;
import com.hbm.render.amlfrom1710.Vec3;
import com.hbm.util.BobMathUtil;
import java.nio.FloatBuffer;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector4f;

public class BeamPronter {
    public static void prontBeam(Vec3 skeleton, EnumWaveType wave, EnumBeamType beam, int outerColor, int innerColor, int start, int segments, float spinRadius, int layers, float thickness) {
        GL11.glPushMatrix();
        float sYaw = (float)(Math.atan2(skeleton.xCoord, skeleton.zCoord) * 180.0 / Math.PI);
        float sqrt = MathHelper.func_76133_a((double)(skeleton.xCoord * skeleton.xCoord + skeleton.zCoord * skeleton.zCoord));
        float sPitch = (float)(Math.atan2(skeleton.yCoord, sqrt) * 180.0 / Math.PI);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)sYaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(sPitch - 90.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glPushMatrix();
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a((boolean)true);
        if (beam == EnumBeamType.SOLID) {
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            GlStateManager.func_179129_p();
        }
        com.hbm.render.amlfrom1710.Tessellator tessellator = com.hbm.render.amlfrom1710.Tessellator.instance;
        if (beam == EnumBeamType.LINE) {
            Tessellator.func_178181_a().func_178180_c().func_181668_a(1, DefaultVertexFormats.field_181706_f);
        } else if (beam == EnumBeamType.SOLID) {
            Tessellator.func_178181_a().func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181706_f);
        }
        Vec3 unit = Vec3.createVectorHelper(0.0, 1.0, 0.0);
        Random rand = new Random(start);
        double length = skeleton.length();
        double segLength = length / (double)segments;
        double lastX = 0.0;
        double lastY = 0.0;
        double lastZ = 0.0;
        for (int i = 0; i <= segments; ++i) {
            double pX = unit.xCoord * segLength * (double)i;
            double pY = unit.yCoord * segLength * (double)i;
            double pZ = unit.zCoord * segLength * (double)i;
            if (wave != EnumWaveType.STRAIGHT) {
                Vec3 spinner = Vec3.createVectorHelper(spinRadius, 0.0, 0.0);
                if (wave == EnumWaveType.SPIRAL) {
                    spinner.rotateAroundY((float)Math.PI * (float)start / 180.0f);
                    spinner.rotateAroundY(0.7853982f * (float)i);
                } else if (wave == EnumWaveType.RANDOM) {
                    spinner.rotateAroundY((float)Math.PI * 2 * rand.nextFloat());
                }
                pX += spinner.xCoord;
                pY += spinner.yCoord;
                pZ += spinner.zCoord;
            }
            if (beam == EnumBeamType.LINE && i > 0) {
                tessellator.setColorOpaque_I(outerColor);
                tessellator.addVertex(pX, pY, pZ);
                tessellator.addVertex(lastX, lastY, lastZ);
            }
            if (beam == EnumBeamType.SOLID && i > 0) {
                float radius = thickness / (float)layers;
                for (int j = 1; j <= layers; ++j) {
                    int color = 0;
                    if (layers == 1) {
                        color = outerColor;
                    } else {
                        float inter = (float)(j - 1) / (float)(layers - 1);
                        color = BobMathUtil.interpolateColor(innerColor, outerColor, inter);
                    }
                    tessellator.setColorOpaque_I(color);
                    tessellator.addVertex(lastX + (double)(radius * (float)j), lastY, lastZ + (double)(radius * (float)j));
                    tessellator.addVertex(lastX + (double)(radius * (float)j), lastY, lastZ - (double)(radius * (float)j));
                    tessellator.addVertex(pX + (double)(radius * (float)j), pY, pZ - (double)(radius * (float)j));
                    tessellator.addVertex(pX + (double)(radius * (float)j), pY, pZ + (double)(radius * (float)j));
                    tessellator.addVertex(lastX - (double)(radius * (float)j), lastY, lastZ + (double)(radius * (float)j));
                    tessellator.addVertex(lastX - (double)(radius * (float)j), lastY, lastZ - (double)(radius * (float)j));
                    tessellator.addVertex(pX - (double)(radius * (float)j), pY, pZ - (double)(radius * (float)j));
                    tessellator.addVertex(pX - (double)(radius * (float)j), pY, pZ + (double)(radius * (float)j));
                    tessellator.addVertex(lastX + (double)(radius * (float)j), lastY, lastZ + (double)(radius * (float)j));
                    tessellator.addVertex(lastX - (double)(radius * (float)j), lastY, lastZ + (double)(radius * (float)j));
                    tessellator.addVertex(pX - (double)(radius * (float)j), pY, pZ + (double)(radius * (float)j));
                    tessellator.addVertex(pX + (double)(radius * (float)j), pY, pZ + (double)(radius * (float)j));
                    tessellator.addVertex(lastX + (double)(radius * (float)j), lastY, lastZ - (double)(radius * (float)j));
                    tessellator.addVertex(lastX - (double)(radius * (float)j), lastY, lastZ - (double)(radius * (float)j));
                    tessellator.addVertex(pX - (double)(radius * (float)j), pY, pZ - (double)(radius * (float)j));
                    tessellator.addVertex(pX + (double)(radius * (float)j), pY, pZ - (double)(radius * (float)j));
                }
            }
            lastX = pX;
            lastY = pY;
            lastZ = pZ;
        }
        if (beam == EnumBeamType.LINE) {
            tessellator.setColorOpaque_I(innerColor);
            tessellator.addVertex(0.0, 0.0, 0.0);
            tessellator.addVertex(0.0, skeleton.length(), 0.0);
        }
        tessellator.draw();
        if (beam == EnumBeamType.SOLID) {
            GlStateManager.func_179084_k();
            GlStateManager.func_179089_o();
            GlStateManager.func_179132_a((boolean)true);
        }
        GlStateManager.func_179145_e();
        GlStateManager.func_179098_w();
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    public static void gluonBeam(Vec3 pos1, Vec3 pos2, float size) {
        GL11.glPushMatrix();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        GlStateManager.func_179129_p();
        if (!GeneralConfig.useShaders2) {
            GlStateManager.func_179131_c((float)0.4f, (float)0.7f, (float)1.0f, (float)1.0f);
        }
        Vec3 diff = pos1.subtract(pos2);
        float len = (float)diff.length();
        Vec3 angles = BobMathUtil.getEulerAngles(diff);
        GL11.glTranslated((double)pos1.xCoord, (double)pos1.yCoord, (double)pos1.zCoord);
        GL11.glRotated((double)(angles.xCoord + 90.0), (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)(-angles.yCoord), (double)0.0, (double)0.0, (double)1.0);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(ResourceManager.noise_1);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(ResourceManager.noise_2);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(ResourceManager.bfg_core_lightning);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder buf = tes.func_178180_c();
        GL11.glGetFloat((int)2982, (FloatBuffer)HbmShaderManager2.AUX_GL_BUFFER);
        HbmShaderManager2.AUX_GL_BUFFER.rewind();
        Matrix4f mvMatrix = new Matrix4f();
        mvMatrix.load(HbmShaderManager2.AUX_GL_BUFFER);
        HbmShaderManager2.AUX_GL_BUFFER.rewind();
        Matrix4f.invert((Matrix4f)mvMatrix, (Matrix4f)mvMatrix);
        Vector4f billboardPos = Matrix4f.transform((Matrix4f)mvMatrix, (Vector4f)new Vector4f(0.0f, 0.0f, 0.0f, 1.0f), null);
        int SUBDIVISIONS_PER_BLOCK = 16;
        int subdivisions = (int)Math.ceil(len * (float)SUBDIVISIONS_PER_BLOCK);
        ResourceManager.gluon_spiral.use();
        ResourceManager.gluon_spiral.uniform3f("playerPos", billboardPos.x, billboardPos.y, billboardPos.z);
        ResourceManager.gluon_spiral.uniform1f("subdivXAmount", 1.0f / (float)SUBDIVISIONS_PER_BLOCK);
        ResourceManager.gluon_spiral.uniform1f("subdivUAmount", 1.0f / (float)(subdivisions + 1));
        ResourceManager.gluon_spiral.uniform1f("len", len);
        buf.func_181668_a(5, DefaultVertexFormats.field_181707_g);
        for (int i = 0; i <= subdivisions; ++i) {
            float iN = (float)i / (float)subdivisions;
            float pos = iN * len;
            buf.func_181662_b((double)pos, 0.0, (double)(-size) * 0.025).func_187315_a((double)iN, 0.45).func_181675_d();
            buf.func_181662_b((double)pos, 0.0, (double)size * 0.025).func_187315_a((double)iN, 0.55).func_181675_d();
        }
        tes.func_78381_a();
        SUBDIVISIONS_PER_BLOCK = (int)((double)SUBDIVISIONS_PER_BLOCK * 0.5);
        subdivisions = (int)Math.ceil(len * (float)SUBDIVISIONS_PER_BLOCK);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(ResourceManager.gluon_beam_tex);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        ResourceManager.gluon_beam.use();
        ResourceManager.gluon_beam.uniform1f("beam_length", len);
        buf.func_181668_a(5, DefaultVertexFormats.field_181707_g);
        Vec3d vec = new Vec3d((double)billboardPos.x, (double)billboardPos.y, (double)billboardPos.z).func_72431_c(new Vec3d(1.0, 0.0, 0.0)).func_72432_b();
        for (int i = 0; i <= subdivisions; ++i) {
            float iN = (float)i / (float)subdivisions;
            float pos = iN * len;
            buf.func_181662_b((double)pos, -vec.field_72448_b, -vec.field_72449_c).func_187315_a((double)iN, 0.0).func_181675_d();
            buf.func_181662_b((double)pos, vec.field_72448_b, vec.field_72449_c).func_187315_a((double)iN, 1.0).func_181675_d();
        }
        tes.func_78381_a();
        HbmShaderManager2.releaseShader();
        if (!GeneralConfig.useShaders2) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179089_o();
        GL11.glPopMatrix();
    }

    public static enum EnumBeamType {
        SOLID,
        LINE;

    }

    public static enum EnumWaveType {
        RANDOM,
        SPIRAL,
        STRAIGHT;

    }
}

