/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.tileentity;

import com.hbm.blocks.machine.FoundryChannel;
import com.hbm.tileentity.machine.TileEntityFoundryChannel;
import java.awt.Color;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class RenderFoundryChannel
extends TileEntitySpecialRenderer<TileEntityFoundryChannel> {
    public static final ResourceLocation LAVA_TEXTURE = new ResourceLocation("hbm", "textures/models/machines/lava_gray.png");

    public void render(TileEntityFoundryChannel tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        boolean doRender;
        if (tile == null || !tile.func_145830_o()) {
            return;
        }
        World world = tile.func_145831_w();
        BlockPos pos = tile.func_174877_v();
        FoundryChannel channel = (FoundryChannel)tile.func_145838_q();
        boolean bl = doRender = tile.amount > 0 && tile.type != null;
        if (!doRender) {
            return;
        }
        Color color = new Color(tile.type.moltenColor).brighter();
        double level = (double)tile.amount * 0.25 / (double)tile.getCapacity();
        this.func_147499_a(LAVA_TEXTURE);
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        GlStateManager.func_179140_f();
        GlStateManager.func_179131_c((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)1.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        if (channel.canConnectTo(world, pos, EnumFacing.EAST)) {
            this.renderLiquid(buffer, 0.625, 0.125, 0.3125, 1.0, 0.125 + level, 0.6875);
        }
        if (channel.canConnectTo(world, pos, EnumFacing.WEST)) {
            this.renderLiquid(buffer, 0.0, 0.125, 0.3125, 0.375, 0.125 + level, 0.6875);
        }
        if (channel.canConnectTo(world, pos, EnumFacing.SOUTH)) {
            this.renderLiquid(buffer, 0.3125, 0.125, 0.625, 0.6875, 0.125 + level, 1.0);
        }
        if (channel.canConnectTo(world, pos, EnumFacing.NORTH)) {
            this.renderLiquid(buffer, 0.3125, 0.125, 0.0, 0.6875, 0.125 + level, 0.375);
        }
        this.renderLiquid(buffer, 0.375, 0.125, 0.375, 0.625, 0.125 + level, 0.625);
        tessellator.func_78381_a();
        GlStateManager.func_179117_G();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    private void renderLiquid(BufferBuilder buffer, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        buffer.func_181662_b(minX, minY, minZ).func_187315_a(0.0, 0.0).func_181675_d();
        buffer.func_181662_b(minX, minY, maxZ).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b(maxX, minY, maxZ).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b(maxX, minY, minZ).func_187315_a(1.0, 0.0).func_181675_d();
        buffer.func_181662_b(minX, maxY, minZ).func_187315_a(0.0, 0.0).func_181675_d();
        buffer.func_181662_b(minX, maxY, maxZ).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b(maxX, maxY, maxZ).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b(maxX, maxY, minZ).func_187315_a(1.0, 0.0).func_181675_d();
    }
}

