/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.tileentity;

import com.hbm.render.amlfrom1710.Tessellator;
import com.hbm.tileentity.machine.IRenderFoundry;
import com.hbm.tileentity.machine.TileEntityFoundryCastingBase;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.items.ItemStackHandler;
import org.lwjgl.opengl.GL11;

public class RenderFoundryLib {
    public static final ResourceLocation lava = new ResourceLocation("hbm", "textures/models/machines/lava_gray.png");

    private static void drawItem(ItemStack stack, double height, World world) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.5, (double)height, (double)0.5);
        if (!(stack.func_77973_b() instanceof ItemBlock)) {
            GL11.glRotatef((float)-180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
        } else {
            GL11.glTranslated((double)0.0, (double)-0.352, (double)0.0);
        }
        double scale = 1.5;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
        IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_184393_a(stack, world, null);
        model = ForgeHooksClient.handleCameraTransforms((IBakedModel)model, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.FIXED, (boolean)false);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        Minecraft.func_71410_x().func_175599_af().func_180454_a(stack, model);
        GL11.glEnable((int)3008);
        GL11.glPopMatrix();
    }

    public static void renderFoundry(TileEntity te, double x, double y, double z, float interp) {
        IRenderFoundry foundry = (IRenderFoundry)te;
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        if (te instanceof TileEntityFoundryCastingBase) {
            ItemStack out;
            ItemStackHandler inv = ((TileEntityFoundryCastingBase)te).inventory;
            ItemStack mold = inv.getStackInSlot(0);
            if (mold != null && !mold.func_190926_b()) {
                RenderFoundryLib.drawItem(mold, foundry.moldHeight(), te.func_145831_w());
            }
            if ((out = inv.getStackInSlot(1)) != null && !out.func_190926_b()) {
                RenderFoundryLib.drawItem(out, foundry.outHeight(), te.func_145831_w());
            }
        }
        if (foundry.shouldRender()) {
            int hex = foundry.getMat().moltenColor;
            Color color = new Color(hex);
            GL11.glPushMatrix();
            GL11.glDisable((int)2884);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(lava);
            Tessellator tess = new Tessellator();
            tess.setNormal(0.0f, 1.0f, 0.0f);
            tess.setBrightness(240);
            tess.startDrawingQuadsColor();
            tess.setColorRGBA_F((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
            tess.addVertexWithUV(foundry.minX(), foundry.getLevel(), foundry.minZ(), foundry.minZ(), foundry.maxX());
            tess.addVertexWithUV(foundry.minX(), foundry.getLevel(), foundry.maxZ(), foundry.maxZ(), foundry.maxX());
            tess.addVertexWithUV(foundry.maxX(), foundry.getLevel(), foundry.maxZ(), foundry.maxZ(), foundry.minX());
            tess.addVertexWithUV(foundry.maxX(), foundry.getLevel(), foundry.minZ(), foundry.minZ(), foundry.minX());
            tess.draw();
            GL11.glEnable((int)2884);
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }
}

