/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.bomb;

import api.hbm.energy.IEnergyUser;
import com.hbm.interfaces.IBomb;
import com.hbm.items.ModItems;
import com.hbm.lib.ForgeDirection;
import com.hbm.lib.Library;
import com.hbm.packet.AuxElectricityPacket;
import com.hbm.packet.AuxGaugePacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.TEMissilePacket;
import com.hbm.tileentity.TileEntityLoadedBase;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")})
public class TileEntityLaunchPad
extends TileEntityLoadedBase
implements ITickable,
IEnergyUser,
SimpleComponent {
    public ItemStackHandler inventory;
    public long power;
    public final long maxPower = 100000L;
    public int state = 0;
    public static final int clearingDuraction = 100;
    public int clearingTimer = 0;
    private String customName;
    private ItemStack detectStack = ItemStack.field_190927_a;
    private long detectPower;

    public TileEntityLaunchPad() {
        this.inventory = new ItemStackHandler(3);
    }

    public String getInventoryName() {
        return this.hasCustomInventoryName() ? this.customName : "container.launchPad";
    }

    public boolean hasCustomInventoryName() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.power = compound.func_74763_f("power");
        this.detectPower = this.power + 1L;
        if (compound.func_74764_b("inventory")) {
            this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        }
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74772_a("power", this.power);
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return super.func_189515_b(compound);
    }

    public long getPowerScaled(long i) {
        return this.power * i / 100000L;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.clearingTimer > 0) {
                --this.clearingTimer;
            }
            this.updateConnections();
            this.power = Library.chargeTEFromItems((IItemHandlerModifiable)this.inventory, 2, this.power, 100000L);
            this.detectAndSendChanges();
        }
    }

    private void updateConnections() {
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(1, 0, 0), ForgeDirection.EAST);
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(-1, 0, 0), ForgeDirection.WEST);
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(0, 0, 1), ForgeDirection.SOUTH);
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(0, 0, -1), ForgeDirection.NORTH);
        this.trySubscribe(this.field_145850_b, this.field_174879_c.func_177982_a(0, -1, 0), ForgeDirection.DOWN);
    }

    private void detectAndSendChanges() {
        boolean mark = false;
        if (!(this.detectStack.func_190926_b() && this.inventory.getStackInSlot(0).func_190926_b() || this.detectStack.func_185136_b(this.inventory.getStackInSlot(0)))) {
            mark = true;
            this.detectStack = this.inventory.getStackInSlot(0).func_77946_l();
        }
        if (this.detectPower != this.power) {
            mark = true;
            this.detectPower = this.power;
        }
        PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxGaugePacket(this.field_174879_c, this.clearingTimer, 0), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 20.0));
        PacketDispatcher.wrapper.sendToAllTracking((IMessage)new TEMissilePacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.inventory.getStackInSlot(0)), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 1000.0));
        PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxElectricityPacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.power), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0));
        if (mark) {
            this.func_70296_d();
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 100000L;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory) : super.getCapability(capability, facing));
    }

    public boolean setCoords(int x, int z) {
        if (!(this.inventory.getStackInSlot(1).func_190926_b() || this.inventory.getStackInSlot(1).func_77973_b() != ModItems.designator && this.inventory.getStackInSlot(1).func_77973_b() != ModItems.designator_range && this.inventory.getStackInSlot(1).func_77973_b() != ModItems.designator_manual)) {
            NBTTagCompound nbt = this.inventory.getStackInSlot(1).func_77942_o() ? this.inventory.getStackInSlot(1).func_77978_p() : new NBTTagCompound();
            nbt.func_74768_a("xCoord", x);
            nbt.func_74768_a("zCoord", z);
            this.inventory.getStackInSlot(1).func_77982_d(nbt);
            return true;
        }
        return false;
    }

    public String getComponentName() {
        return "launchpad";
    }

    @Callback(doc="setTarget(x:int, z:int); saves coords in target designator item - returns true if it worked")
    public Object[] setTarget(Context context, Arguments args) {
        int x = args.checkInteger(0);
        int z = args.checkInteger(1);
        return new Object[]{this.setCoords(x, z)};
    }

    @Callback(doc="launch(); tries to launch the rocket")
    public Object[] launch(Context context, Arguments args) {
        Block b = this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c();
        if (b instanceof IBomb) {
            ((IBomb)b).explode(this.field_145850_b, this.field_174879_c);
        }
        return new Object[]{null};
    }
}

