/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.forgefluid.FFUtils;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.lib.ForgeDirection;
import com.hbm.packet.FluidTankPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.INBTPacketReceiver;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileEntityCondenser
extends TileEntity
implements ITickable,
IFluidHandler,
ITankPacketAcceptor,
INBTPacketReceiver {
    public int age = 0;
    public FluidTank[] tanks = new FluidTank[2];
    public int waterTimer = 0;

    public TileEntityCondenser() {
        this.tanks[0] = new FluidTank(100);
        this.tanks[1] = new FluidTank(100);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            ++this.age;
            if (this.age >= 2) {
                this.age = 0;
            }
            if (this.waterTimer > 0) {
                --this.waterTimer;
            }
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new FluidTankPacket(this.field_174879_c, this.tanks[0]), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 150.0));
            int convert = Math.min(this.tanks[0].getFluidAmount(), this.tanks[1].getCapacity() - this.tanks[1].getFluidAmount());
            if (this.extraCondition(convert)) {
                if (convert > 0) {
                    this.waterTimer = 20;
                }
                this.tanks[0].drain(convert, true);
                this.tanks[1].fill(new FluidStack(FluidRegistry.WATER, convert), true);
                this.postConvert(convert);
                this.fillFluidInit(this.tanks[1]);
                this.networkPack();
            }
        }
    }

    public void packExtra(NBTTagCompound data) {
    }

    public boolean extraCondition(int convert) {
        return true;
    }

    public void postConvert(int convert) {
    }

    public void networkPack() {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74782_a("tanks", (NBTBase)FFUtils.serializeTankArray(this.tanks));
        data.func_74774_a("timer", (byte)this.waterTimer);
        this.packExtra(data);
        INBTPacketReceiver.networkPack(this, data, 150);
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        FFUtils.deserializeTankArray(data.func_150295_c("tanks", 10), this.tanks);
        this.waterTimer = data.func_74771_c("timer");
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tanks[0].readFromNBT(nbt.func_74775_l("steam"));
        this.tanks[1].readFromNBT(nbt.func_74775_l("water"));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74782_a("steam", (NBTBase)this.tanks[1].writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("water", (NBTBase)this.tanks[1].writeToNBT(new NBTTagCompound()));
        return nbt;
    }

    public void fillFluidInit(FluidTank tank) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            this.fillFluid(this.field_174879_c.func_177958_n() + dir.offsetX, this.field_174879_c.func_177956_o() + dir.offsetY, this.field_174879_c.func_177952_p() + dir.offsetZ, tank);
        }
    }

    public void fillFluid(int x, int y, int z, FluidTank type) {
        FFUtils.fillFluid(this, type, this.field_145850_b, new BlockPos(x, y, z), type.getCapacity());
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length == 1) {
            this.tanks[0].readFromNBT(tags[0]);
        }
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.tanks[0].getTankProperties()[0], this.tanks[1].getTankProperties()[0]};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource != null && resource.getFluid() == ModForgeFluids.SPENTSTEAM) {
            return this.tanks[0].fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource != null && resource.getFluid() == FluidRegistry.WATER) {
            return this.tanks[1].drain(resource, doDrain);
        }
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.tanks[1].drain(maxDrain, doDrain);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }
}

