/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.tile.IHeatSource;
import com.hbm.lib.ForgeDirection;
import com.hbm.modules.ModuleBurnTime;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public abstract class TileEntityFireboxBase
extends TileEntityMachineBase
implements ITickable,
IGUIProvider,
IHeatSource {
    public int maxBurnTime;
    public int burnTime;
    public int burnHeat;
    public boolean wasOn = false;
    public int playersUsing = 0;
    public float doorAngle = 0.0f;
    public float prevDoorAngle = 0.0f;
    public int heatEnergy;
    AxisAlignedBB bb = null;

    public TileEntityFireboxBase() {
        super(2);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.wasOn = false;
            if (this.burnTime <= 0) {
                for (int i = 0; i < 2; ++i) {
                    int fuel;
                    if (this.inventory.getStackInSlot(i) == null || (fuel = (int)((double)this.getModule().getBurnTime(this.inventory.getStackInSlot(i)) * this.getTimeMult())) <= 0) continue;
                    this.maxBurnTime = this.burnTime = fuel;
                    this.burnHeat = this.getModule().getBurnHeat(this.getBaseHeat(), this.inventory.getStackInSlot(i));
                    ItemStack copy = this.inventory.getStackInSlot(i).func_77946_l();
                    this.inventory.getStackInSlot(i).func_190918_g(1);
                    if (this.inventory.getStackInSlot(i).func_190926_b()) {
                        this.inventory.setStackInSlot(i, copy.func_77973_b().getContainerItem(copy));
                    }
                    this.wasOn = true;
                    break;
                }
            } else {
                if (this.heatEnergy < this.getMaxHeat()) {
                    --this.burnTime;
                }
                this.wasOn = true;
                if (this.field_145850_b.field_73012_v.nextInt(15) == 0) {
                    this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 0.5f + this.field_145850_b.field_73012_v.nextFloat() * 0.5f);
                }
            }
            if (this.wasOn) {
                this.heatEnergy = Math.min(this.heatEnergy + this.burnHeat, this.getMaxHeat());
            } else {
                this.heatEnergy = Math.max(this.heatEnergy - Math.max(this.heatEnergy / 1000, 1), 0);
                this.burnHeat = 0;
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74768_a("maxBurnTime", this.maxBurnTime);
            data.func_74768_a("burnTime", this.burnTime);
            data.func_74768_a("burnHeat", this.burnHeat);
            data.func_74768_a("heatEnergy", this.heatEnergy);
            data.func_74768_a("playersUsing", this.playersUsing);
            data.func_74757_a("wasOn", this.wasOn);
            this.networkPack(data, 50);
        } else {
            this.prevDoorAngle = this.doorAngle;
            float swingSpeed = this.doorAngle / 10.0f + 3.0f;
            this.doorAngle = this.playersUsing > 0 ? (this.doorAngle += swingSpeed) : (this.doorAngle -= swingSpeed);
            this.doorAngle = MathHelper.func_76131_a((float)this.doorAngle, (float)0.0f, (float)135.0f);
            if (this.wasOn && this.field_145850_b.func_82737_E() % 5L == 0L) {
                ForgeDirection dir = ForgeDirection.getOrientation(this.func_145832_p() - 10);
                double x = (double)this.field_174879_c.func_177958_n() + 0.5 + (double)dir.offsetX;
                double y = (double)this.field_174879_c.func_177956_o() + 0.25;
                double z = (double)this.field_174879_c.func_177952_p() + 0.5 + (double)dir.offsetZ;
                this.field_145850_b.func_175682_a(EnumParticleTypes.FLAME, this.wasOn, x + this.field_145850_b.field_73012_v.nextDouble() * 0.5 - 0.25, y + this.field_145850_b.field_73012_v.nextDouble() * 0.25, z + this.field_145850_b.field_73012_v.nextDouble() * 0.5 - 0.25, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public abstract ModuleBurnTime getModule();

    public abstract int getBaseHeat();

    public abstract double getTimeMult();

    public abstract int getMaxHeat();

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing e) {
        return new int[]{0, 1};
    }

    @Override
    public boolean isItemValidForSlot(int i, ItemStack itemStack) {
        return this.getModule().getBurnTime(itemStack) > 0;
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.maxBurnTime = nbt.func_74762_e("maxBurnTime");
        this.burnTime = nbt.func_74762_e("burnTime");
        this.burnHeat = nbt.func_74762_e("burnHeat");
        this.heatEnergy = nbt.func_74762_e("heatEnergy");
        this.playersUsing = nbt.func_74762_e("playersUsing");
        this.wasOn = nbt.func_74767_n("wasOn");
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.maxBurnTime = nbt.func_74762_e("maxBurnTime");
        this.burnTime = nbt.func_74762_e("burnTime");
        this.burnHeat = nbt.func_74762_e("burnHeat");
        this.heatEnergy = nbt.func_74762_e("heatEnergy");
    }

    @Override
    @NotNull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74768_a("maxBurnTime", this.maxBurnTime);
        nbt.func_74768_a("burnTime", this.burnTime);
        nbt.func_74768_a("burnHeat", this.burnHeat);
        nbt.func_74768_a("heatEnergy", this.heatEnergy);
        return super.func_189515_b(nbt);
    }

    @Override
    public int getHeatStored() {
        return this.heatEnergy;
    }

    @Override
    public void useUpHeat(int heat) {
        this.heatEnergy = Math.max(0, this.heatEnergy - heat);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 1), (double)this.field_174879_c.func_177956_o(), (double)(this.field_174879_c.func_177952_p() - 1), (double)(this.field_174879_c.func_177958_n() + 2), (double)(this.field_174879_c.func_177956_o() + 1), (double)(this.field_174879_c.func_177952_p() + 2));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

