/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.tile.IHeatSource;
import com.hbm.inventory.container.ContainerRadioThermal;
import com.hbm.inventory.gui.GUIRadioThermal;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.RTGUtil;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class TileEntityHeaterRadioThermal
extends TileEntityMachineBase
implements IHeatSource,
ITickable,
IGUIProvider {
    public int heatGen;
    public int heatEnergy;
    public static final int maxHeatEnergy = 750000;
    AxisAlignedBB bb = null;

    public TileEntityHeaterRadioThermal() {
        super(15);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.heatEnergy = (int)((double)this.heatEnergy * 0.999);
            this.tryPullHeat();
            this.heatGen = RTGUtil.updateRTGs(this.inventory, new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14}) * 10;
            this.heatEnergy += this.heatGen;
            if (this.heatEnergy > 750000) {
                this.heatEnergy = 750000;
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74768_a("hg", this.heatGen);
            data.func_74768_a("h", this.heatEnergy);
            this.networkPack(data, 25);
        }
    }

    @Override
    public String getName() {
        return "container.heaterRadioThermal";
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.heatGen = nbt.func_74762_e("hg");
        this.heatEnergy = nbt.func_74762_e("h");
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.heatEnergy = nbt.func_74762_e("heatEnergy");
    }

    @Override
    @NotNull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("heatEnergy", this.heatEnergy);
        return nbt;
    }

    protected void tryPullHeat() {
        TileEntity con = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, -1, 0));
        if (con instanceof IHeatSource) {
            IHeatSource source = (IHeatSource)con;
            this.heatEnergy = (int)((double)this.heatEnergy + (double)source.getHeatStored() * 0.85);
            source.useUpHeat(source.getHeatStored());
        }
    }

    @Override
    public int getHeatStored() {
        return this.heatEnergy;
    }

    @Override
    public void useUpHeat(int heat) {
        this.heatEnergy = Math.max(0, this.heatEnergy - heat);
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 1), (double)this.field_174879_c.func_177956_o(), (double)(this.field_174879_c.func_177952_p() - 1), (double)(this.field_174879_c.func_177958_n() + 2), (double)(this.field_174879_c.func_177956_o() + 2), (double)(this.field_174879_c.func_177952_p() + 2));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerRadioThermal(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIRadioThermal(player.field_71071_by, this);
    }

    public boolean hasHeatGen() {
        return this.heatGen > 0;
    }

    public boolean hasHeat() {
        return this.heatEnergy > 0;
    }

    public int getHeatGenScaled(int i) {
        if (this.heatGen == 0) {
            return 0;
        }
        return (int)(Math.log(this.heatGen) * (double)i / Math.log(90000.0));
    }

    public int getHeatScaled(int i) {
        return this.heatEnergy * i / 750000;
    }
}

