/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyGenerator;
import com.hbm.hazard.HazardSystem;
import com.hbm.lib.Library;
import com.hbm.packet.AuxElectricityPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.TileEntityLoadedBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityMachineRadGen
extends TileEntityLoadedBase
implements ITickable,
IEnergyGenerator {
    public ItemStackHandler inventory = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            TileEntityMachineRadGen.this.func_70296_d();
            super.onContentsChanged(slot);
        }
    };
    public long power;
    public int fuel;
    public int strength;
    public int mode;
    public int soundCycle = 0;
    public float rotation;
    public static final long maxPower = 1000000L;
    public static final int maxFuel = 1000;
    public static final int maxStrength = 10000;
    private String customName;
    private static int[] accessibleSlots = new int[]{0};

    public String getInventoryName() {
        return this.hasCustomInventoryName() ? this.customName : "container.radGen";
    }

    public boolean hasCustomInventoryName() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.power = compound.func_74763_f("power");
        this.fuel = compound.func_74762_e("fuel");
        this.strength = compound.func_74762_e("strength");
        if (compound.func_74764_b("inventory")) {
            this.inventory.deserializeNBT(compound.func_74775_l("inventory"));
        }
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74772_a("power", this.power);
        compound.func_74768_a("fuel", this.fuel);
        compound.func_74768_a("strength", this.strength);
        compound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return super.func_189515_b(compound);
    }

    public int[] getAccessibleSlotsFromSide(EnumFacing e) {
        return accessibleSlots;
    }

    public boolean isItemValidForSlot(int i, ItemStack stack) {
        return i == 0 && HazardSystem.getTotalRadsFromStack(stack) > 0.0f;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.power = Library.chargeItemsFromTE((IItemHandlerModifiable)this.inventory, 2, this.power, 1000000L);
            this.sendRADGenPower();
            int r = (int)Math.sqrt(HazardSystem.getTotalRadsFromStack(this.inventory.getStackInSlot(0)));
            if (r > 0) {
                if (this.inventory.getStackInSlot(0).func_77973_b().hasContainerItem(this.inventory.getStackInSlot(0))) {
                    if (this.inventory.getStackInSlot(1).func_190926_b()) {
                        if (this.fuel + r <= 1000) {
                            this.inventory.setStackInSlot(1, new ItemStack(this.inventory.getStackInSlot(0).func_77973_b().func_77668_q()));
                            this.inventory.getStackInSlot(0).func_190918_g(1);
                            if (this.inventory.getStackInSlot(0).func_190926_b()) {
                                this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
                            }
                            this.fuel += r;
                        }
                    } else if (this.inventory.getStackInSlot(0).func_77973_b().func_77668_q() == this.inventory.getStackInSlot(1).func_77973_b() && this.inventory.getStackInSlot(1).func_190916_E() < this.inventory.getStackInSlot(1).func_77976_d() && this.fuel + r <= 1000) {
                        this.inventory.getStackInSlot(1).func_190917_f(1);
                        this.inventory.getStackInSlot(0).func_190918_g(1);
                        if (this.inventory.getStackInSlot(0).func_190926_b()) {
                            this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
                        }
                        this.fuel += r;
                    }
                } else if (this.fuel + r <= 1000) {
                    this.inventory.getStackInSlot(0).func_190918_g(1);
                    this.fuel += r;
                }
            }
            if (this.fuel > 1000) {
                this.fuel = 1000;
            }
            if (this.fuel > 0) {
                --this.fuel;
                this.strength = this.strength < 10000 ? 10000 * this.fuel / 1000 : 10000;
            } else if (this.strength > 0) {
                this.strength -= (int)((double)this.strength * 0.1);
            }
            if (this.strength > 10000) {
                this.strength = 10000;
            }
            if (this.strength < 0) {
                this.strength = 0;
            }
            this.power += (long)this.strength;
            if (this.power > 1000000L) {
                this.power = 1000000L;
            }
            this.mode = 0;
            if (this.strength > 0) {
                this.mode = 1;
            }
            if (this.strength > 1000) {
                this.mode = 2;
            }
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxElectricityPacket(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.power), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 20.0));
        }
    }

    public void sendRADGenPower() {
        int i = this.func_145832_p();
        switch (i) {
            case 2: {
                this.sendPower(this.field_145850_b, this.field_174879_c.func_177982_a(5, 0, 0), Library.POS_X);
                break;
            }
            case 3: {
                this.sendPower(this.field_145850_b, this.field_174879_c.func_177982_a(-5, 0, 0), Library.NEG_X);
                break;
            }
            case 4: {
                this.sendPower(this.field_145850_b, this.field_174879_c.func_177982_a(0, 0, -5), Library.NEG_Z);
                break;
            }
            case 5: {
                this.sendPower(this.field_145850_b, this.field_174879_c.func_177982_a(0, 0, 5), Library.POS_Z);
            }
        }
    }

    public int getFuelScaled(int i) {
        return this.fuel * i / 1000;
    }

    public long getPowerScaled(long i) {
        return this.power * i / 1000000L;
    }

    public int getStrengthScaled(int i) {
        return this.strength * i / 10000;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getMaxPower() {
        return 1000000L;
    }
}

