/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IEnergyUser;
import api.hbm.entity.IRadarDetectable;
import com.hbm.blocks.ModBlocks;
import com.hbm.capability.HbmLivingProps;
import com.hbm.config.WeaponConfig;
import com.hbm.lib.ForgeDirection;
import com.hbm.lib.HBMSoundHandler;
import com.hbm.packet.AuxElectricityPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.TileEntityTickingBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityMachineRadar
extends TileEntityTickingBase
implements ITickable,
IEnergyUser {
    public List<Entity> entList = new ArrayList<Entity>();
    public List<int[]> nearbyMissiles = new ArrayList<int[]>();
    public int pingTimer = 0;
    public int lastPower;
    static final int maxTimer = 40;
    public boolean scanMissiles = true;
    public boolean scanPlayers = false;
    public boolean smartMode = true;
    public boolean redMode = true;
    public boolean jammed = false;
    public float prevRotation;
    public float rotation;
    public long power = 0L;
    public static final int maxPower = 100000;

    @Override
    public String getInventoryName() {
        return "";
    }

    public void func_73660_a() {
        if (this.field_174879_c.func_177956_o() < WeaponConfig.radarAltitude) {
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            this.updateConnectionsExcept(this.field_145850_b, this.field_174879_c, ForgeDirection.UP);
            this.nearbyMissiles.clear();
            if (this.power > 0L) {
                this.allocateMissiles();
                this.power -= 500L;
                if (this.power < 0L) {
                    this.power = 0L;
                }
            }
            if (this.lastPower != this.getRedPower()) {
                this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), true);
            }
            this.sendMissileData();
            this.lastPower = this.getRedPower();
            if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()).func_177230_c() != ModBlocks.muffler) {
                ++this.pingTimer;
                if (this.power > 0L && this.pingTimer >= 40) {
                    this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), HBMSoundHandler.sonarPing, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    this.pingTimer = 0;
                }
            }
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxElectricityPacket(this.field_174879_c, this.power), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 10.0));
        } else {
            this.prevRotation = this.rotation;
            if (this.power > 0L) {
                this.rotation += 5.0f;
            }
            if (this.rotation >= 360.0f) {
                this.rotation -= 360.0f;
                this.prevRotation -= 360.0f;
            }
        }
    }

    public void handleButtonPacket(int value, int meta) {
        switch (meta) {
            case 0: {
                this.scanMissiles = !this.scanMissiles;
                break;
            }
            case 1: {
                this.scanPlayers = !this.scanPlayers;
                break;
            }
            case 2: {
                this.smartMode = !this.smartMode;
                break;
            }
            case 3: {
                this.redMode = !this.redMode;
            }
        }
    }

    public boolean isEntityApproaching(Entity e) {
        boolean xAxisApproaching = (double)this.field_174879_c.func_177958_n() < e.field_70165_t && e.field_70159_w < 0.0 || (double)this.field_174879_c.func_177958_n() > e.field_70165_t && e.field_70159_w > 0.0;
        boolean zAxisApproaching = (double)this.field_174879_c.func_177952_p() < e.field_70161_v && e.field_70179_y < 0.0 || (double)this.field_174879_c.func_177952_p() > e.field_70161_v && e.field_70179_y > 0.0;
        return xAxisApproaching && zAxisApproaching;
    }

    public int getV(Entity e) {
        return (int)(Math.sqrt(e.field_70159_w * e.field_70159_w + e.field_70181_x * e.field_70181_x + e.field_70179_y * e.field_70179_y) * 20.0);
    }

    private void allocateMissiles() {
        this.nearbyMissiles.clear();
        this.entList.clear();
        this.jammed = false;
        List list = this.field_145850_b.func_72839_b(null, new AxisAlignedBB((double)this.field_174879_c.func_177958_n() + 0.5 - (double)WeaponConfig.radarRange, 0.0, (double)this.field_174879_c.func_177952_p() + 0.5 - (double)WeaponConfig.radarRange, (double)this.field_174879_c.func_177958_n() + 0.5 + (double)WeaponConfig.radarRange, 10000.0, (double)this.field_174879_c.func_177952_p() + 0.5 + (double)WeaponConfig.radarRange));
        for (Entity e : list) {
            if (e.field_70163_u < (double)(this.field_174879_c.func_177956_o() + WeaponConfig.radarBuffer)) continue;
            if (e instanceof EntityLivingBase && (double)HbmLivingProps.getDigamma((EntityLivingBase)e) > 0.001) {
                this.jammed = true;
                this.nearbyMissiles.clear();
                this.entList.clear();
                return;
            }
            if (e instanceof EntityPlayer && this.scanPlayers) {
                this.nearbyMissiles.add(new int[]{(int)e.field_70165_t, (int)e.field_70163_u, (int)e.field_70161_v, this.getV(e), IRadarDetectable.RadarTargetType.PLAYER.ordinal()});
                this.entList.add(e);
            }
            if (!(e instanceof IRadarDetectable) || !this.scanMissiles) continue;
            this.nearbyMissiles.add(new int[]{(int)e.field_70165_t, (int)e.field_70163_u, (int)e.field_70161_v, this.getV(e), ((IRadarDetectable)e).getTargetType().ordinal()});
            if (this.smartMode) {
                if (!(e.field_70181_x <= 0.0) || !this.isEntityApproaching(e)) continue;
                this.entList.add(e);
                continue;
            }
            this.entList.add(e);
        }
    }

    public int getRedPower() {
        if (!this.entList.isEmpty()) {
            if (this.redMode) {
                double maxRange = (double)WeaponConfig.radarRange * Math.sqrt(2.0);
                int power = 0;
                for (Entity e : this.entList) {
                    double dist = Math.sqrt(Math.pow(e.field_70165_t - (double)this.field_174879_c.func_177958_n(), 2.0) + Math.pow(e.field_70161_v - (double)this.field_174879_c.func_177952_p(), 2.0));
                    int p = 15 - (int)Math.floor(dist / maxRange * 15.0);
                    if (p <= power) continue;
                    power = p;
                }
                return power;
            }
            int power = 0;
            for (int[] nearbyMissile : this.nearbyMissiles) {
                if (nearbyMissile[5] + 1 <= power) continue;
                power = nearbyMissile[5] + 1;
            }
            return power;
        }
        return 0;
    }

    private void sendMissileData() {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74772_a("power", this.power);
        data.func_74757_a("scanMissiles", this.scanMissiles);
        data.func_74757_a("scanPlayers", this.scanPlayers);
        data.func_74757_a("smartMode", this.smartMode);
        data.func_74757_a("redMode", this.redMode);
        data.func_74757_a("jammed", this.jammed);
        data.func_74768_a("count", this.nearbyMissiles.size());
        for (int i = 0; i < this.nearbyMissiles.size(); ++i) {
            data.func_74768_a("x" + i, this.nearbyMissiles.get(i)[0]);
            data.func_74768_a("y" + i, this.nearbyMissiles.get(i)[1]);
            data.func_74768_a("z" + i, this.nearbyMissiles.get(i)[2]);
            data.func_74768_a("v" + i, this.nearbyMissiles.get(i)[3]);
            data.func_74768_a("type" + i, this.nearbyMissiles.get(i)[4]);
        }
        this.networkPack(data, 15);
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        this.nearbyMissiles.clear();
        this.power = data.func_74763_f("power");
        this.scanMissiles = data.func_74767_n("scanMissiles");
        this.scanPlayers = data.func_74767_n("scanPlayers");
        this.smartMode = data.func_74767_n("smartMode");
        this.redMode = data.func_74767_n("redMode");
        this.jammed = data.func_74767_n("jammed");
        int count = data.func_74762_e("count");
        for (int i = 0; i < count; ++i) {
            int x = data.func_74762_e("x" + i);
            int y = data.func_74762_e("y" + i);
            int z = data.func_74762_e("z" + i);
            int v = data.func_74762_e("v" + i);
            int type = data.func_74762_e("type" + i);
            this.nearbyMissiles.add(new int[]{x, y, z, v, type});
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.power = compound.func_74763_f("power");
        this.scanMissiles = compound.func_74767_n("scanMissiles");
        this.scanPlayers = compound.func_74767_n("scanPlayers");
        this.smartMode = compound.func_74767_n("smartMode");
        this.redMode = compound.func_74767_n("redMode");
        super.func_145839_a(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74772_a("power", this.power);
        compound.func_74757_a("scanMissiles", this.scanMissiles);
        compound.func_74757_a("scanPlayers", this.scanPlayers);
        compound.func_74757_a("smartMode", this.smartMode);
        compound.func_74757_a("redMode", this.redMode);
        return super.func_189515_b(compound);
    }

    public long getPowerScaled(long i) {
        return this.power * i / 100000L;
    }

    @Override
    public void setPower(long i) {
        if (this.power != i) {
            this.func_70296_d();
        }
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 100000L;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

