/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.inventory.BreederRecipes;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.tileentity.machine.TileEntityMachineReactorSmall;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class TileEntityMachineReactor
extends TileEntityMachineBase
implements ITickable {
    public int progress;
    public int charge;
    public int heat;
    public int recipeHeat;
    public static final int maxPower = 1000;
    public static final int processingSpeed = 1000;
    private static final int[] slots_top = new int[]{1};
    private static final int[] slots_bottom = new int[]{2, 0};
    private static final int[] slots_side = new int[]{0};
    AxisAlignedBB bb = null;

    public TileEntityMachineReactor() {
        super(3);
    }

    @Override
    public String getName() {
        return "container.reactor";
    }

    public boolean hasItemPower(ItemStack stack) {
        return BreederRecipes.getFuelValue(stack) != null;
    }

    private static int getItemPower(ItemStack stack) {
        int[] power = BreederRecipes.getFuelValue(stack);
        if (power == null) {
            return 0;
        }
        return power[1];
    }

    private static int getItemHeat(ItemStack stack) {
        int[] power = BreederRecipes.getFuelValue(stack);
        if (power == null) {
            return 0;
        }
        return power[0];
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.charge = nbt.func_74765_d("powerTime");
        this.heat = nbt.func_74765_d("heat");
        this.progress = nbt.func_74765_d("CookTime");
    }

    @Override
    @NotNull
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt.func_74777_a("powerTime", (short)this.charge);
        nbt.func_74777_a("heat", (short)this.heat);
        nbt.func_74777_a("cookTime", (short)this.progress);
        return super.func_189515_b(nbt);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + 3), (double)(this.field_174879_c.func_177952_p() + 1));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public int[] getAccessibleSlotsFromSide(EnumFacing e) {
        int side = e.ordinal();
        return side == 0 ? slots_bottom : (side == 1 ? slots_top : slots_side);
    }

    @Override
    public boolean canExtractItem(int slot, ItemStack itemStack, int amount) {
        if (slot == 0) {
            return !this.hasItemPower(this.inventory.getStackInSlot(0));
        }
        return true;
    }

    @Override
    public boolean isItemValidForSlot(int i, ItemStack stack) {
        return i != 2 && (i != 0 || this.hasItemPower(stack));
    }

    public int getProgressScaled(int i) {
        return this.progress * i / 1000;
    }

    public int getHeatScaled(int i) {
        return this.heat * i / 4;
    }

    public boolean hasPower() {
        return this.charge > 0;
    }

    public boolean isProcessing() {
        return this.progress > 0;
    }

    public boolean canProcess() {
        if (this.inventory.getStackInSlot(1).func_190926_b()) {
            return false;
        }
        BreederRecipes.BreederRecipe recipe = BreederRecipes.getOutput(this.inventory.getStackInSlot(1));
        if (recipe == null) {
            return false;
        }
        this.recipeHeat = recipe.heat;
        if (this.heat < recipe.heat) {
            return false;
        }
        if (this.inventory.getStackInSlot(2).func_190926_b()) {
            return true;
        }
        if (!this.inventory.getStackInSlot(2).func_77969_a(recipe.output)) {
            return false;
        }
        if (this.inventory.getStackInSlot(2).func_190916_E() < this.inventory.getSlotLimit(2) && this.inventory.getStackInSlot(2).func_190916_E() < this.inventory.getStackInSlot(2).func_77976_d()) {
            return true;
        }
        return this.inventory.getStackInSlot(2).func_190916_E() < recipe.output.func_77976_d();
    }

    private void processItem() {
        if (this.canProcess()) {
            BreederRecipes.BreederRecipe rec = BreederRecipes.getOutput(this.inventory.getStackInSlot(1));
            if (rec == null) {
                return;
            }
            ItemStack itemStack = rec.output;
            if (this.inventory.getStackInSlot(2).func_190926_b()) {
                this.inventory.setStackInSlot(2, itemStack.func_77946_l());
            } else if (this.inventory.getStackInSlot(2).func_77969_a(itemStack)) {
                this.inventory.getStackInSlot(2).func_190917_f(itemStack.func_190916_E());
            }
            for (int i = 1; i < 2; ++i) {
                if (this.inventory.getStackInSlot(i).func_190926_b()) {
                    this.inventory.setStackInSlot(i, new ItemStack(this.inventory.getStackInSlot(i).func_77973_b()));
                } else {
                    this.inventory.getStackInSlot(i).func_190918_g(1);
                }
                if (!this.inventory.getStackInSlot(i).func_190926_b()) continue;
                this.inventory.setStackInSlot(i, ItemStack.field_190927_a);
            }
        }
    }

    public void updateReactorPower() {
        int incomingflux = this.getReactorPower(this.field_174879_c.func_177978_c()) + this.getReactorPower(this.field_174879_c.func_177968_d()) + this.getReactorPower(this.field_174879_c.func_177976_e()) + this.getReactorPower(this.field_174879_c.func_177974_f());
        if (incomingflux > 0 && this.charge < 2) {
            this.charge = 1;
            this.heat = incomingflux * 5 / 50000;
        }
    }

    public int getReactorPower(BlockPos rPos) {
        TileEntity r = this.field_145850_b.func_175625_s(rPos);
        if (r == null || !(r instanceof TileEntityMachineReactorSmall)) {
            return 0;
        }
        return ((TileEntityMachineReactorSmall)r).coreHeat;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            boolean trigger;
            boolean markDirty = false;
            this.updateReactorPower();
            if (this.charge == 0) {
                this.heat = 0;
            }
            if (this.hasItemPower(this.inventory.getStackInSlot(0)) && this.charge == 0) {
                this.charge += TileEntityMachineReactor.getItemPower(this.inventory.getStackInSlot(0));
                this.heat = TileEntityMachineReactor.getItemHeat(this.inventory.getStackInSlot(0));
                if (!this.inventory.getStackInSlot(0).func_190926_b()) {
                    ItemStack container = this.inventory.getStackInSlot(0).func_77973_b().getContainerItem(this.inventory.getStackInSlot(0));
                    this.inventory.getStackInSlot(0).func_190918_g(1);
                    if (this.inventory.getStackInSlot(0).func_190926_b()) {
                        this.inventory.setStackInSlot(0, container);
                    }
                    markDirty = true;
                }
            }
            if (this.hasPower() && this.canProcess()) {
                this.progress += this.heat / this.recipeHeat;
                if (this.progress >= 1000) {
                    this.progress = 0;
                    --this.charge;
                    this.processItem();
                    markDirty = true;
                }
            } else {
                this.progress = 0;
            }
            boolean bl = trigger = !this.hasPower() || !this.canProcess() || this.progress != 0;
            if (trigger) {
                markDirty = true;
            }
            if (markDirty) {
                this.func_70296_d();
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74777_a("charge", (short)this.charge);
            data.func_74777_a("progress", (short)this.progress);
            data.func_74774_a("heat", (byte)this.heat);
            this.networkPack(data, 20);
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        this.charge = data.func_74765_d("charge");
        this.progress = data.func_74765_d("progress");
        this.heat = data.func_74771_c("heat");
    }
}

