/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.rbmk;

import com.hbm.blocks.ModBlocks;
import com.hbm.entity.projectile.EntityRBMKDebris;
import com.hbm.forgefluid.FFUtils;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.inventory.control_panel.DataValue;
import com.hbm.inventory.control_panel.DataValueFloat;
import com.hbm.inventory.control_panel.DataValueString;
import com.hbm.packet.FluidTankPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.render.amlfrom1710.Vec3;
import com.hbm.tileentity.machine.rbmk.RBMKDials;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKConsole;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKSlottedBase;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileEntityRBMKBoiler
extends TileEntityRBMKSlottedBase
implements IFluidHandler,
ITankPacketAcceptor,
IControlReceiver {
    public FluidTank feed = new FluidTank(200000);
    public FluidTank steam = new FluidTank(20000000);
    public Fluid steamType = ModForgeFluids.STEAM;
    public double gameruleBoilerHeatConsumption = 0.1;
    public byte timer = 0;
    public static final byte gamerulePollTime = 100;

    public TileEntityRBMKBoiler() {
        super(0);
    }

    @Override
    public void getDiagData(NBTTagCompound nbt) {
        this.func_189515_b(nbt);
        nbt.func_82580_o("jumpheight");
        nbt.func_74768_a("water", this.feed.getFluidAmount());
        nbt.func_74768_a("steam", this.steam.getFluidAmount());
    }

    @Override
    public String getName() {
        return "container.rbmkBoiler";
    }

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.timer < 100) {
                this.timer = (byte)(this.timer + 1);
            } else {
                this.timer = 0;
                this.gameruleBoilerHeatConsumption = RBMKDials.getBoilerHeatConsumption(this.field_145850_b);
            }
            if (this.feed.getFluidAmount() < 200000 || this.steam.getFluidAmount() > 0) {
                PacketDispatcher.wrapper.sendToAllAround((IMessage)new FluidTankPacket(this.field_174879_c, this.feed, this.steam), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 50.0));
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74778_a("steamType2", this.steamType.getName());
            this.networkPack(data, 50);
            double heatCap = this.getHeatFromSteam(this.steamType);
            double heatProvided = this.heat - heatCap;
            if (heatProvided > 0.0 && this.feed.getFluidAmount() > 0) {
                int waterUsed = (int)Math.floor(heatProvided / this.gameruleBoilerHeatConsumption);
                waterUsed = Math.min(waterUsed, this.feed.getFluidAmount());
                waterUsed = this.makeLossless(waterUsed, this.steamType);
                int steamProduced = (int)Math.round((double)((float)waterUsed * 100.0f) / this.getFactorFromSteam(this.steamType));
                this.feed.drain(waterUsed, true);
                this.steam.fill(new FluidStack(this.steamType, steamProduced), true);
                this.heat -= (double)waterUsed * this.gameruleBoilerHeatConsumption;
            }
            if (this.steam.getFluidAmount() > 0) {
                this.fillFluidInit(this.steam);
            }
        }
        super.func_73660_a();
    }

    public int makeLossless(int water, Fluid type) {
        if (type == ModForgeFluids.ULTRAHOTSTEAM) {
            return (int)((double)water * 0.1) * 10;
        }
        return water;
    }

    public double getHeatFromSteam(Fluid type) {
        if (type == ModForgeFluids.STEAM) {
            return 100.0;
        }
        if (type == ModForgeFluids.HOTSTEAM) {
            return 300.0;
        }
        if (type == ModForgeFluids.SUPERHOTSTEAM) {
            return 450.0;
        }
        if (type == ModForgeFluids.ULTRAHOTSTEAM) {
            return 600.0;
        }
        return 0.0;
    }

    public double getFactorFromSteam(Fluid type) {
        if (type == ModForgeFluids.STEAM) {
            return 1.0;
        }
        if (type == ModForgeFluids.HOTSTEAM) {
            return 10.0;
        }
        if (type == ModForgeFluids.SUPERHOTSTEAM) {
            return 100.0;
        }
        if (type == ModForgeFluids.ULTRAHOTSTEAM) {
            return 1000.0;
        }
        return 0.0;
    }

    public void fillFluidInit(FluidTank tank) {
        this.fillFluid(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() + RBMKDials.getColumnHeight(this.field_145850_b) + 1, this.field_174879_c.func_177952_p(), tank);
        if (this.field_145850_b.func_180495_p(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p())).func_177230_c() == ModBlocks.rbmk_loader) {
            this.fillFluid(this.field_174879_c.func_177958_n() + 1, this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p(), tank);
            this.fillFluid(this.field_174879_c.func_177958_n() - 1, this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p(), tank);
            this.fillFluid(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p() + 1, tank);
            this.fillFluid(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p() - 1, tank);
            this.fillFluid(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 2, this.field_174879_c.func_177952_p(), tank);
        }
        if (this.field_145850_b.func_180495_p(new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 2, this.field_174879_c.func_177952_p())).func_177230_c() == ModBlocks.rbmk_loader) {
            this.fillFluid(this.field_174879_c.func_177958_n() + 1, this.field_174879_c.func_177956_o() - 2, this.field_174879_c.func_177952_p(), tank);
            this.fillFluid(this.field_174879_c.func_177958_n() - 1, this.field_174879_c.func_177956_o() - 2, this.field_174879_c.func_177952_p(), tank);
            this.fillFluid(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 2, this.field_174879_c.func_177952_p() + 1, tank);
            this.fillFluid(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 2, this.field_174879_c.func_177952_p() - 1, tank);
            this.fillFluid(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p(), tank);
            this.fillFluid(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 3, this.field_174879_c.func_177952_p(), tank);
        }
    }

    public void fillFluid(int x, int y, int z, FluidTank tank) {
        FFUtils.fillFluid(this, tank, this.field_145850_b, new BlockPos(x, y, z), tank.getCapacity());
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.feed.readFromNBT(nbt.func_74775_l("feed"));
        this.steam.readFromNBT(nbt.func_74775_l("steam"));
        this.steamType = FluidRegistry.getFluid((String)nbt.func_74779_i("steamType"));
        if (this.steamType == null) {
            this.steamType = ModForgeFluids.STEAM;
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74782_a("feed", (NBTBase)this.feed.writeToNBT(new NBTTagCompound()));
        nbt.func_74782_a("steam", (NBTBase)this.steam.writeToNBT(new NBTTagCompound()));
        nbt.func_74778_a("steamType", this.steamType.getName());
        return nbt;
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return Vec3.createVectorHelper((double)this.field_174879_c.func_177958_n() - player.field_70165_t, (double)this.field_174879_c.func_177956_o() - player.field_70163_u, (double)this.field_174879_c.func_177952_p() - player.field_70161_v).length() < 20.0;
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("compression")) {
            int newAmount = 0;
            if (this.steamType == null) {
                this.steamType = ModForgeFluids.STEAM;
            }
            if (this.steamType == ModForgeFluids.STEAM) {
                this.steamType = ModForgeFluids.HOTSTEAM;
                newAmount = this.steam.getFluidAmount() / 10;
            } else if (this.steamType == ModForgeFluids.HOTSTEAM) {
                this.steamType = ModForgeFluids.SUPERHOTSTEAM;
                newAmount = this.steam.getFluidAmount() / 10;
            } else if (this.steamType == ModForgeFluids.SUPERHOTSTEAM) {
                this.steamType = ModForgeFluids.ULTRAHOTSTEAM;
                newAmount = this.steam.getFluidAmount() / 10;
            } else if (this.steamType == ModForgeFluids.ULTRAHOTSTEAM) {
                this.steamType = ModForgeFluids.STEAM;
                newAmount = this.steam.getFluidAmount() * 1000;
            }
            if (newAmount > 0) {
                this.steam.setFluid(new FluidStack(this.steamType, Math.min(newAmount, this.steam.getCapacity())));
            } else {
                this.steam.setFluid(null);
            }
            this.func_70296_d();
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        if (nbt.func_74764_b("steamType2")) {
            this.steamType = FluidRegistry.getFluid((String)nbt.func_74779_i("steamType2"));
            if (this.steamType == null) {
                this.steamType = ModForgeFluids.STEAM;
            }
        } else {
            super.networkUnpack(nbt);
        }
    }

    @Override
    public void onMelt(int reduce) {
        int count = 1 + this.field_145850_b.field_73012_v.nextInt(2);
        for (int i = 0; i < count; ++i) {
            this.spawnDebris(EntityRBMKDebris.DebrisType.BLANK);
        }
        super.onMelt(reduce);
    }

    @Override
    public TileEntityRBMKConsole.ColumnType getConsoleType() {
        return TileEntityRBMKConsole.ColumnType.BOILER;
    }

    @Override
    public NBTTagCompound getNBTForConsole() {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74768_a("water", this.feed.getFluidAmount());
        data.func_74768_a("maxWater", this.feed.getCapacity());
        data.func_74768_a("steam", this.steam.getFluidAmount());
        data.func_74768_a("maxSteam", this.steam.getCapacity());
        data.func_74778_a("type", this.steamType.getName());
        return data;
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length == 2) {
            this.feed.readFromNBT(tags[0]);
            this.steam.readFromNBT(tags[1]);
        }
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{this.feed.getTankProperties()[0], this.steam.getTankProperties()[0]};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource != null && resource.getFluid() == FluidRegistry.WATER) {
            return this.feed.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource != null && resource.getFluid() == this.steamType) {
            return this.steam.drain(resource, doDrain);
        }
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.steam.drain(maxDrain, doDrain);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public Map<String, DataValue> getQueryData() {
        Map<String, DataValue> data = super.getQueryData();
        data.put("feed", new DataValueFloat(this.feed.getFluidAmount()));
        data.put("steam", new DataValueFloat(this.steam.getFluidAmount()));
        data.put("steamType", new DataValueString(this.steamType.getName()));
        return data;
    }
}

