/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.rbmk;

import com.hbm.blocks.ModBlocks;
import com.hbm.entity.projectile.EntityRBMKDebris;
import com.hbm.forgefluid.FFUtils;
import com.hbm.forgefluid.ModForgeFluids;
import com.hbm.interfaces.ITankPacketAcceptor;
import com.hbm.inventory.RBMKOutgasserRecipes;
import com.hbm.inventory.control_panel.DataValue;
import com.hbm.inventory.control_panel.DataValueFloat;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemFluidIcon;
import com.hbm.packet.FluidTankPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.machine.rbmk.IRBMKFluxReceiver;
import com.hbm.tileentity.machine.rbmk.IRBMKLoadable;
import com.hbm.tileentity.machine.rbmk.RBMKDials;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKConsole;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKSlottedBase;
import com.hbm.util.ContaminationUtil;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileEntityRBMKOutgasser
extends TileEntityRBMKSlottedBase
implements IRBMKFluxReceiver,
IFluidHandler,
ITankPacketAcceptor,
IRBMKLoadable {
    public FluidTank gas = new FluidTank(64000);
    public Fluid gasType = ModForgeFluids.TRITIUM;
    public double progress = 0.0;
    public double usedFlux = 0.0;
    public int duration = 10000;

    public TileEntityRBMKOutgasser() {
        super(2);
    }

    @Override
    public String getName() {
        return "container.rbmkOutgasser";
    }

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new FluidTankPacket(this.field_174879_c, this.gas), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 50.0));
            NBTTagCompound type = new NBTTagCompound();
            type.func_74778_a("gasType", this.gasType.getName());
            this.networkPack(type, 50);
            if (this.field_145850_b.func_82737_E() % 10L == 0L) {
                this.fillFluidInit(this.gas);
            }
            if (!this.canProcess()) {
                this.progress = 0.0;
            }
        }
        super.func_73660_a();
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        if (nbt.func_74764_b("steamType")) {
            this.gasType = FluidRegistry.getFluid((String)nbt.func_74779_i("gasType"));
        } else {
            super.networkUnpack(nbt);
        }
    }

    @Override
    public void receiveFlux(IRBMKFluxReceiver.NType type, double flux) {
        if (this.canProcess()) {
            if (type == IRBMKFluxReceiver.NType.FAST) {
                flux *= 0.2;
            }
            this.progress += flux * RBMKDials.getOutgasserMod(this.field_145850_b);
            if (this.progress > (double)this.duration) {
                this.process();
                this.func_70296_d();
            }
        } else if (!this.inventory.getStackInSlot(0).func_190926_b()) {
            if (type == IRBMKFluxReceiver.NType.FAST) {
                flux *= 0.2;
            }
            ContaminationUtil.neutronActivateItem(this.inventory.getStackInSlot(0), (float)(flux * 0.001), 1.0f);
            this.func_70296_d();
        }
        this.usedFlux = flux;
    }

    private boolean canProcess() {
        if (this.inventory.getStackInSlot(0).func_190926_b()) {
            return false;
        }
        int requiredFlux = RBMKOutgasserRecipes.getRequiredFlux(this.inventory.getStackInSlot(0));
        if (requiredFlux == -1) {
            return false;
        }
        this.duration = requiredFlux;
        ItemStack output = RBMKOutgasserRecipes.getOutput(this.inventory.getStackInSlot(0));
        if (output.func_77973_b() == ModItems.fluid_icon) {
            return ItemFluidIcon.getFluid(output) == this.gasType && this.gas.getFluidAmount() + ItemFluidIcon.getQuantity(output) <= this.gas.getCapacity();
        }
        if (this.inventory.getStackInSlot(1).func_190926_b()) {
            return true;
        }
        return this.inventory.getStackInSlot(1).func_77973_b() == output.func_77973_b() && this.inventory.getStackInSlot(1).func_77952_i() == output.func_77952_i() && this.inventory.getStackInSlot(1).func_190916_E() + output.func_190916_E() <= this.inventory.getStackInSlot(1).func_77976_d();
    }

    private void process() {
        ItemStack output = RBMKOutgasserRecipes.getOutput(this.inventory.getStackInSlot(0));
        this.inventory.getStackInSlot(0).func_190918_g(1);
        this.progress = 0.0;
        if (output.func_77973_b() == ModItems.fluid_icon) {
            this.gas.fill(new FluidStack(this.gasType, ItemFluidIcon.getQuantity(output)), true);
            return;
        }
        if (this.inventory.getStackInSlot(1).func_190926_b()) {
            this.inventory.setStackInSlot(1, output.func_77946_l());
        } else {
            this.inventory.getStackInSlot(1).func_190917_f(output.func_190916_E());
        }
    }

    public void fillFluidInit(FluidTank tank) {
        this.fillFluid(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() + RBMKDials.getColumnHeight(this.field_145850_b) + 1, this.field_174879_c.func_177952_p(), tank);
        if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()).func_177230_c() == ModBlocks.rbmk_loader) {
            this.fillFluid(this.field_174879_c.func_177958_n() + 1, this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p(), tank);
            this.fillFluid(this.field_174879_c.func_177958_n() - 1, this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p(), tank);
            this.fillFluid(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p() + 1, tank);
            this.fillFluid(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p() - 1, tank);
            this.fillFluid(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 2, this.field_174879_c.func_177952_p(), tank);
        }
        if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177979_c(2)).func_177230_c() == ModBlocks.rbmk_loader) {
            this.fillFluid(this.field_174879_c.func_177958_n() + 1, this.field_174879_c.func_177956_o() - 2, this.field_174879_c.func_177952_p(), tank);
            this.fillFluid(this.field_174879_c.func_177958_n() - 1, this.field_174879_c.func_177956_o() - 2, this.field_174879_c.func_177952_p(), tank);
            this.fillFluid(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 2, this.field_174879_c.func_177952_p() + 1, tank);
            this.fillFluid(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 2, this.field_174879_c.func_177952_p() - 1, tank);
            this.fillFluid(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p(), tank);
            this.fillFluid(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 3, this.field_174879_c.func_177952_p(), tank);
        }
    }

    public void fillFluid(int x, int y, int z, FluidTank tank) {
        FFUtils.fillFluid(this, tank, this.field_145850_b, new BlockPos(x, y, z), tank.getCapacity());
    }

    @Override
    public void onMelt(int reduce) {
        int count = 4 + this.field_145850_b.field_73012_v.nextInt(2);
        for (int i = 0; i < count; ++i) {
            this.spawnDebris(EntityRBMKDebris.DebrisType.BLANK);
        }
        super.onMelt(reduce);
    }

    @Override
    public TileEntityRBMKConsole.ColumnType getConsoleType() {
        return TileEntityRBMKConsole.ColumnType.OUTGASSER;
    }

    @Override
    public NBTTagCompound getNBTForConsole() {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74768_a("gas", this.gas.getFluidAmount());
        data.func_74768_a("maxGas", this.gas.getCapacity());
        data.func_74780_a("usedFlux", this.usedFlux);
        data.func_74780_a("progress", this.progress);
        data.func_74780_a("maxProgress", (double)this.duration);
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.progress = nbt.func_74769_h("progress");
        this.duration = nbt.func_74762_e("duration");
        this.gas.readFromNBT(nbt.func_74775_l("gas"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74780_a("progress", this.progress);
        nbt.func_74768_a("duration", this.duration);
        nbt.func_74782_a("gas", (NBTBase)this.gas.writeToNBT(new NBTTagCompound()));
        return nbt;
    }

    @Override
    public boolean isItemValidForSlot(int i, ItemStack itemStack) {
        return i == 0 && RBMKOutgasserRecipes.getOutput(itemStack) != null;
    }

    @Override
    public boolean canExtractItem(int i, ItemStack itemStack, int j) {
        return i == 1;
    }

    @Override
    public void recievePacket(NBTTagCompound[] tags) {
        if (tags.length == 1) {
            this.gas.readFromNBT(tags[0]);
        }
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.gas.getTankProperties();
    }

    public int fill(FluidStack resource, boolean doFill) {
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return this.gas.drain(resource, doDrain);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return this.gas.drain(maxDrain, doDrain);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean canLoad(ItemStack toLoad) {
        return toLoad != null && this.inventory.getStackInSlot(0).func_190926_b();
    }

    @Override
    public void load(ItemStack toLoad) {
        this.inventory.setStackInSlot(0, toLoad.func_77946_l());
        this.func_70296_d();
    }

    @Override
    public boolean canUnload() {
        return !this.inventory.getStackInSlot(1).func_190926_b();
    }

    @Override
    public ItemStack provideNext() {
        return this.inventory.getStackInSlot(1);
    }

    @Override
    public void unload() {
        this.inventory.setStackInSlot(1, ItemStack.field_190927_a);
        this.func_70296_d();
    }

    @Override
    public Map<String, DataValue> getQueryData() {
        Map<String, DataValue> data = super.getQueryData();
        data.put("gas", new DataValueFloat(this.gas.getFluidAmount()));
        data.put("progress", new DataValueFloat((float)this.progress));
        data.put("maxProgress", new DataValueFloat(this.duration));
        return data;
    }
}

