/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.util;

import com.hbm.interfaces.IKeypadHandler;
import com.hbm.packet.KeypadClientPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.util.KeypadClient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Keypad {
    public TileEntity te;
    public Button[] buttons = new Button[12];
    public byte successColorTicks = 0;
    public byte failColorTicks = 0;
    public boolean isActive = true;
    public int storedCode = -1;
    public byte[] code = new byte[]{-1, -1, -1, -1, -1, -1};
    public boolean isSettingCode = true;

    public Keypad(TileEntity te) {
        this.te = te;
        for (int i = 0; i < this.buttons.length; ++i) {
            this.buttons[i] = new Button();
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void update() {
        boolean active = false;
        for (Button b : this.buttons) {
            if (b.cooldown <= 0) continue;
            b.cooldown = (byte)(b.cooldown - 1);
            active = true;
        }
        if (this.successColorTicks > 0) {
            this.successColorTicks = (byte)(this.successColorTicks - 1);
            active = true;
        }
        if (this.failColorTicks > 0) {
            this.failColorTicks = (byte)(this.failColorTicks - 1);
            active = true;
        }
        if (this.isSettingCode) {
            active = true;
        }
        if (!this.te.func_145831_w().field_72995_K) {
            byte[] data = new byte[21];
            for (int i = 0; i < 12; ++i) {
                data[i] = this.buttons[i].cooldown;
            }
            data[12] = (byte)(this.isSettingCode ? 1 : 0);
            System.arraycopy(this.code, 0, data, 13, 6);
            data[19] = this.successColorTicks;
            data[20] = this.failColorTicks;
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new KeypadClientPacket(this.te.func_174877_v(), data), new NetworkRegistry.TargetPoint(this.te.func_145831_w().field_73011_w.getDimension(), (double)this.te.func_174877_v().func_177958_n(), (double)this.te.func_174877_v().func_177956_o(), (double)this.te.func_174877_v().func_177952_p(), 10.0));
        }
        this.isActive = active;
    }

    public void buttonClicked(int id) {
        if (this.buttons[id].cooldown == 0) {
            byte num;
            this.buttons[id].cooldown = (byte)20;
            switch (id) {
                case 9: {
                    int newCode = this.buildIntCode();
                    if (this.storedCode == newCode) {
                        this.isSettingCode = true;
                    }
                    this.clearCode();
                    return;
                }
                case 10: {
                    num = 0;
                    break;
                }
                case 11: {
                    int newCode = this.buildIntCode();
                    if (this.isSettingCode) {
                        this.storedCode = newCode;
                        this.successColorTicks = (byte)20;
                        this.isSettingCode = false;
                        if (this.te instanceof IKeypadHandler) {
                            ((IKeypadHandler)this.te).passwordSet();
                        }
                    } else if (this.storedCode == newCode) {
                        if (this.te instanceof IKeypadHandler) {
                            ((IKeypadHandler)this.te).keypadActivated();
                        }
                        this.successColorTicks = (byte)20;
                    } else {
                        this.failColorTicks = (byte)20;
                    }
                    this.clearCode();
                    return;
                }
                default: {
                    num = (byte)(id + 1);
                }
            }
            if (num < 10 && this.code[this.code.length - 1] < 0) {
                this.successColorTicks = 0;
                this.failColorTicks = 0;
                this.shiftCode();
                this.code[0] = num;
            }
        }
    }

    public void shiftCode() {
        for (int i = this.code.length - 1; i > 0; --i) {
            this.code[i] = this.code[i - 1];
            this.code[i - 1] = -1;
        }
    }

    public void clearCode() {
        for (int i = 0; i < this.code.length; ++i) {
            this.code[i] = -1;
        }
    }

    public int buildIntCode() {
        if (this.code[0] < 0) {
            return -1;
        }
        int num = 0;
        for (int i = this.code.length - 1; i >= 0; --i) {
            if (this.code[i] < 0) continue;
            num = num * 10 + this.code[i];
        }
        return num;
    }

    public NBTTagCompound writeToNbt(NBTTagCompound tag) {
        tag.func_74773_a("code", this.code);
        tag.func_74768_a("currentPassword", this.storedCode);
        tag.func_74757_a("isSettingCode", this.isSettingCode);
        tag.func_74774_a("successColorTicks", this.successColorTicks);
        tag.func_74774_a("failColorTicks", this.failColorTicks);
        byte[] cooldowns = new byte[12];
        for (int i = 0; i < 12; ++i) {
            cooldowns[i] = this.buttons[i].cooldown;
        }
        tag.func_74773_a("buttonCooldowns", cooldowns);
        return tag;
    }

    public void readFromNbt(NBTTagCompound tag) {
        byte[] readCode = tag.func_74770_j("code");
        if (readCode.length == 6) {
            this.code = readCode;
        }
        this.storedCode = tag.func_74762_e("currentPassword");
        this.isSettingCode = tag.func_74767_n("isSettingCode");
        this.successColorTicks = tag.func_74771_c("successColorTicks");
        this.failColorTicks = tag.func_74771_c("failColorTicks");
        byte[] buttonCooldowns = tag.func_74770_j("buttonCooldowns");
        if (buttonCooldowns.length == 12) {
            for (int i = 0; i < 12; ++i) {
                this.buttons[i].cooldown = buttonCooldowns[i];
            }
        }
        this.isActive = true;
    }

    @SideOnly(value=Side.CLIENT)
    public KeypadClient client() {
        return (KeypadClient)this;
    }

    public static class Button {
        public byte cooldown = 0;
    }
}

