/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.world.feature;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class OreLayer3D {
    public static int counter = 0;
    public int id;
    NoiseGeneratorPerlin noiseX;
    NoiseGeneratorPerlin noiseY;
    NoiseGeneratorPerlin noiseZ;
    double scaleH;
    double scaleV;
    double threshold;
    Block block;
    int dim = 0;

    public OreLayer3D(Block block) {
        this.block = block;
        this.id = counter++;
    }

    public OreLayer3D setDimension(int dim) {
        this.dim = dim;
        return this;
    }

    public OreLayer3D setScaleH(double scale) {
        this.scaleH = scale;
        return this;
    }

    public OreLayer3D setScaleV(double scale) {
        this.scaleV = scale;
        return this;
    }

    public OreLayer3D setThreshold(double threshold) {
        this.threshold = threshold;
        return this;
    }

    @SubscribeEvent
    public void onDecorate(DecorateBiomeEvent.Pre event) {
        World world = event.getWorld();
        if (world.field_73011_w.getDimension() != this.dim) {
            return;
        }
        if (this.noiseX == null) {
            this.noiseX = new NoiseGeneratorPerlin(new Random(world.func_72905_C() + 101L + (long)this.id), 4);
        }
        if (this.noiseY == null) {
            this.noiseY = new NoiseGeneratorPerlin(new Random(world.func_72905_C() + 102L + (long)this.id), 4);
        }
        if (this.noiseZ == null) {
            this.noiseZ = new NoiseGeneratorPerlin(new Random(world.func_72905_C() + 103L + (long)this.id), 4);
        }
        int cX = event.getChunkPos().field_77276_a * 16;
        int cZ = event.getChunkPos().field_77275_b * 16;
        for (int x = cX + 8; x < cX + 24; ++x) {
            for (int z = cZ + 8; z < cZ + 24; ++z) {
                for (int y = 64; y > 5; --y) {
                    IBlockState target;
                    double nZ;
                    double nY;
                    double nX = this.noiseX.func_151601_a((double)y * this.scaleV, (double)z * this.scaleH);
                    if (!(nX * (nY = this.noiseY.func_151601_a((double)x * this.scaleH, (double)z * this.scaleH)) * (nZ = this.noiseZ.func_151601_a((double)x * this.scaleH, (double)y * this.scaleV)) > this.threshold) || !(target = world.func_180495_p(new BlockPos(x, y, z))).func_185915_l() || target.func_185904_a() != Material.field_151576_e) continue;
                    world.func_175656_a(new BlockPos(x, y, z), this.block.func_176223_P());
                }
            }
        }
    }
}

