/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.generic;

import com.hbm.blocks.ModBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockChain
extends Block {
    public static final PropertyBool WALL = PropertyBool.func_177716_a((String)"wall");
    public static final PropertyBool END = PropertyBool.func_177716_a((String)"end");
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;

    public BlockChain(Material materialIn, String s) {
        super(materialIn);
        this.func_149663_c(s);
        this.setRegistryName(s);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)WALL, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)END, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        ModBlocks.ALL_BLOCKS.add(this);
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return true;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        float f = 0.125f;
        float minY = 0.0f;
        if (!source.isSideSolid(pos.func_177977_b(), EnumFacing.UP, false)) {
            minY = 0.25f;
        }
        int meta = ((EnumFacing)state.func_177229_b((IProperty)FACING)).ordinal();
        if (!((Boolean)state.func_177229_b((IProperty)WALL)).booleanValue()) {
            return new AxisAlignedBB((double)(3.0f * f), (double)minY, (double)(3.0f * f), (double)(5.0f * f), 1.0, (double)(5.0f * f));
        }
        if (meta == 2) {
            return new AxisAlignedBB((double)(3.0f * f), (double)minY, (double)(1.0f - f), (double)(5.0f * f), 1.0, 1.0);
        }
        if (meta == 3) {
            return new AxisAlignedBB((double)(3.0f * f), (double)minY, 0.0, (double)(5.0f * f), 1.0, (double)f);
        }
        if (meta == 4) {
            return new AxisAlignedBB((double)(1.0f - f), (double)minY, (double)(3.0f * f), 1.0, 1.0, (double)(5.0f * f));
        }
        if (meta == 5) {
            return new AxisAlignedBB(0.0, (double)minY, (double)(3.0f * f), (double)f, 1.0, (double)(5.0f * f));
        }
        return new AxisAlignedBB((double)(3.0f * f), (double)minY, (double)(3.0f * f), (double)(5.0f * f), 1.0, (double)(5.0f * f));
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        if (world.isSideSolid(pos.func_177984_a(), EnumFacing.DOWN) || world.func_180495_p(pos.func_177984_a()).func_177230_c() == this) {
            return true;
        }
        return world.isSideSolid(pos.func_177976_e(), EnumFacing.EAST) || world.isSideSolid(pos.func_177974_f(), EnumFacing.WEST) || world.isSideSolid(pos.func_177978_c(), EnumFacing.SOUTH) || world.isSideSolid(pos.func_177968_d(), EnumFacing.NORTH);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        boolean end;
        int j1 = meta;
        if (facing.ordinal() == 2 && world.isSideSolid(pos.func_177968_d(), EnumFacing.NORTH)) {
            j1 = 2;
        }
        if (facing.ordinal() == 3 && world.isSideSolid(pos.func_177978_c(), EnumFacing.SOUTH)) {
            j1 = 3;
        }
        if (facing.ordinal() == 4 && world.isSideSolid(pos.func_177974_f(), EnumFacing.WEST)) {
            j1 = 4;
        }
        if (facing.ordinal() == 5 && world.isSideSolid(pos.func_177976_e(), EnumFacing.EAST)) {
            j1 = 5;
        }
        boolean bl = (world.func_180495_p(pos.func_177977_b()).func_177230_c() != this || j1 != 0 != (Boolean)world.func_180495_p(pos.func_177977_b()).func_177229_b((IProperty)WALL)) && !world.isSideSolid(pos.func_177977_b(), EnumFacing.UP) ? true : (end = false);
        if (j1 == 0) {
            if (world.func_180495_p(pos.func_177984_a()).func_177230_c() == this) {
                return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)((EnumFacing)world.func_180495_p(pos.func_177984_a()).func_177229_b((IProperty)FACING))).func_177226_a((IProperty)WALL, (Comparable)((Boolean)world.func_180495_p(pos.func_177984_a()).func_177229_b((IProperty)WALL))).func_177226_a((IProperty)END, (Comparable)Boolean.valueOf(end));
            }
            if (world.isSideSolid(pos.func_177984_a(), EnumFacing.DOWN)) {
                return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)WALL, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)END, (Comparable)Boolean.valueOf(end));
            }
        }
        if (j1 == 0) {
            if (world.isSideSolid(pos.func_177968_d(), EnumFacing.NORTH)) {
                j1 = 2;
            }
            if (world.isSideSolid(pos.func_177978_c(), EnumFacing.SOUTH)) {
                j1 = 3;
            }
            if (world.isSideSolid(pos.func_177974_f(), EnumFacing.WEST)) {
                j1 = 4;
            }
            if (world.isSideSolid(pos.func_177976_e(), EnumFacing.EAST)) {
                j1 = 5;
            }
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)(j1 > 0 ? EnumFacing.field_82609_l[j1] : EnumFacing.NORTH)).func_177226_a((IProperty)WALL, (Comparable)Boolean.valueOf(j1 != 0)).func_177226_a((IProperty)END, (Comparable)Boolean.valueOf(end));
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        int l = ((EnumFacing)state.func_177229_b((IProperty)FACING)).ordinal();
        boolean flag = false;
        if (world.func_180495_p(pos.func_177977_b()).func_177230_c() == this && world.func_180495_p(pos).func_177229_b((IProperty)WALL) == world.func_180495_p(pos.func_177977_b()).func_177229_b((IProperty)WALL) || world.isSideSolid(pos.func_177977_b(), EnumFacing.UP)) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)END, (Comparable)Boolean.valueOf(false)));
        } else {
            world.func_175656_a(pos, state.func_177226_a((IProperty)END, (Comparable)Boolean.valueOf(true)));
        }
        if (world.func_180495_p(pos.func_177984_a()).func_177230_c() == this && world.func_180495_p(pos).func_177229_b((IProperty)WALL) == world.func_180495_p(pos.func_177984_a()).func_177229_b((IProperty)WALL)) {
            return;
        }
        if (world.isSideSolid(pos.func_177984_a(), EnumFacing.DOWN) && !((Boolean)world.func_180495_p(pos).func_177229_b((IProperty)WALL)).booleanValue()) {
            return;
        }
        if (l == 2 && world.isSideSolid(pos.func_177968_d(), EnumFacing.NORTH)) {
            flag = true;
        }
        if (l == 3 && world.isSideSolid(pos.func_177978_c(), EnumFacing.SOUTH)) {
            flag = true;
        }
        if (l == 4 && world.isSideSolid(pos.func_177974_f(), EnumFacing.WEST)) {
            flag = true;
        }
        if (l == 5 && world.isSideSolid(pos.func_177976_e(), EnumFacing.EAST)) {
            flag = true;
        }
        if (!flag) {
            world.func_175655_b(pos, true);
        }
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{WALL, END, FACING});
    }

    public int func_176201_c(IBlockState state) {
        int wall = (Boolean)state.func_177229_b((IProperty)WALL) != false ? 1 : 0;
        int end = (Boolean)state.func_177229_b((IProperty)END) != false ? 1 : 0;
        int facing = ((EnumFacing)state.func_177229_b((IProperty)FACING)).ordinal() - 2;
        return wall << 3 | end << 2 | facing;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)WALL, (Comparable)Boolean.valueOf((meta >> 3 & 1) > 0)).func_177226_a((IProperty)END, (Comparable)Boolean.valueOf((meta >> 2 & 1) > 0)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.field_82609_l[(meta & 2) + 2]);
    }
}

