/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import api.hbm.block.ICrucibleAcceptor;
import com.hbm.blocks.BlockDummyable;
import com.hbm.inventory.material.Mats;
import com.hbm.items.machine.ItemScraps;
import com.hbm.lib.ForgeDirection;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.TileEntityProxyInventory;
import com.hbm.tileentity.machine.TileEntityCrucible;
import java.util.ArrayList;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;

public class MachineCrucible
extends BlockDummyable
implements ICrucibleAcceptor {
    protected static final AxisAlignedBB AABB_BIG_BOX = new AxisAlignedBB(-0.75, 0.0, -0.75, 1.75, 1.5, 1.75);
    protected static final AxisAlignedBB AABB_FLOOR = new AxisAlignedBB(-1.5, 0.0, -1.5, 2.5, 0.5, 2.5);

    public MachineCrucible(Material materialIn, String s) {
        super(materialIn, s);
        this.bounding.add(new AxisAlignedBB(-1.5, 0.0, -1.5, 1.5, 0.5, 1.5));
        this.bounding.add(new AxisAlignedBB(-1.25, 0.5, -1.25, 1.25, 1.5, -1.0));
        this.bounding.add(new AxisAlignedBB(-1.25, 0.5, -1.25, -1.0, 1.5, 1.25));
        this.bounding.add(new AxisAlignedBB(-1.25, 0.5, 1.0, 1.25, 1.5, 1.25));
        this.bounding.add(new AxisAlignedBB(1.0, 0.5, -1.25, 1.25, 1.5, 1.25));
        field_185505_j.func_186666_e(0.999);
    }

    public TileEntity func_149915_a(World world, int meta) {
        if (meta >= 12) {
            return new TileEntityCrucible();
        }
        return new TileEntityProxyInventory();
    }

    public boolean hasShovelInHand(EntityPlayer player, EnumHand hand) {
        return player.func_184586_b(hand) != null && player.func_184586_b(hand).func_77973_b() instanceof ItemTool && ((ItemTool)player.func_184586_b(hand).func_77973_b()).getToolClasses(player.func_184586_b(hand)).contains("shovel");
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (!player.func_70093_af()) {
            BlockPos p = this.findCore((IBlockAccess)world, pos);
            if (p == null) {
                return false;
            }
            if (this.hasShovelInHand(player, hand)) {
                TileEntityCrucible crucible = (TileEntityCrucible)world.func_175625_s(p);
                ArrayList<Mats.MaterialStack> stacks = new ArrayList<Mats.MaterialStack>();
                stacks.addAll(crucible.recipeStack);
                stacks.addAll(crucible.wasteStack);
                for (Mats.MaterialStack stack : stacks) {
                    ItemStack scrap = ItemScraps.create(new Mats.MaterialStack(stack.material, stack.amount));
                    if (player.field_71071_by.func_70441_a(scrap)) continue;
                    player.func_71019_a(scrap, false);
                }
                crucible.recipeStack.clear();
                crucible.wasteStack.clear();
                crucible.func_70296_d();
            } else {
                FMLNetworkHandler.openGui((EntityPlayer)player, (Object)MainRegistry.instance, (int)0, (World)world, (int)p.func_177958_n(), (int)p.func_177956_o(), (int)p.func_177952_p());
            }
            return true;
        }
        return true;
    }

    @Override
    public int[] getDimensions() {
        return new int[]{1, 0, 1, 1, 1, 1};
    }

    @Override
    public int getOffset() {
        return 1;
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityCrucible) {
            TileEntityCrucible crucible = (TileEntityCrucible)te;
            ArrayList<Mats.MaterialStack> stacks = new ArrayList<Mats.MaterialStack>();
            stacks.addAll(crucible.recipeStack);
            stacks.addAll(crucible.wasteStack);
            for (Mats.MaterialStack stack : stacks) {
                world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, ItemScraps.create(new Mats.MaterialStack(stack.material, stack.amount))));
            }
            crucible.recipeStack.clear();
            crucible.wasteStack.clear();
        }
        super.func_180663_b(world, pos, state);
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (this.func_176201_c(state) >= 12) {
            return AABB_BIG_BOX;
        }
        BlockPos p = this.findCore(world, pos);
        if (p != null) {
            return AABB_BIG_BOX.func_72317_d((double)(p.func_177958_n() - pos.func_177958_n()), (double)(p.func_177956_o() - pos.func_177956_o()), (double)(p.func_177952_p() - pos.func_177952_p()));
        }
        return field_185505_j;
    }

    @Override
    public boolean canAcceptPartialPour(World world, BlockPos p, double dX, double dY, double dZ, ForgeDirection side, Mats.MaterialStack stack) {
        BlockPos pos = this.findCore((IBlockAccess)world, p);
        if (pos == null) {
            return false;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof TileEntityCrucible)) {
            return false;
        }
        TileEntityCrucible crucible = (TileEntityCrucible)tile;
        return crucible.canAcceptPartialPour(world, p, dX, dY, dZ, side, stack);
    }

    @Override
    public Mats.MaterialStack pour(World world, BlockPos p, double dX, double dY, double dZ, ForgeDirection side, Mats.MaterialStack stack) {
        BlockPos pos = this.findCore((IBlockAccess)world, p);
        if (pos == null) {
            return stack;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof TileEntityCrucible)) {
            return stack;
        }
        TileEntityCrucible crucible = (TileEntityCrucible)tile;
        return crucible.pour(world, p, dX, dY, dZ, side, stack);
    }

    @Override
    public boolean canAcceptPartialFlow(World world, BlockPos p, ForgeDirection side, Mats.MaterialStack stack) {
        return false;
    }

    @Override
    public Mats.MaterialStack flow(World world, BlockPos p, ForgeDirection side, Mats.MaterialStack stack) {
        return null;
    }
}

