/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.effect;

import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.generic.WasteLeaves;
import com.hbm.blocks.generic.WasteLog;
import com.hbm.config.BombConfig;
import com.hbm.config.CompatibilityConfig;
import com.hbm.config.VersatileConfig;
import com.hbm.entity.effect.EntityFalloutRain;
import com.hbm.entity.logic.EntityChunky;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockGravel;
import net.minecraft.block.BlockHugeMushroom;
import net.minecraft.block.BlockIce;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.BlockSnowBlock;
import net.minecraft.block.BlockStone;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EntityFalloutUnderGround
extends EntityChunky {
    private static final DataParameter<Integer> SCALE = EntityDataManager.func_187226_a(EntityFalloutUnderGround.class, (DataSerializer)DataSerializers.field_187192_b);
    public boolean done;
    private int maxSamples;
    private int currentSample;
    private int radius;
    private double s0;
    private double s1;
    private double s2;
    private double s3;
    private double s4;
    private double s5;
    private double s6;
    private double s7;
    private double phi;
    public int falloutRainRadius1 = 0;
    public int falloutRainRadius2 = 0;
    public boolean falloutRainDoFallout = false;
    public boolean falloutRainDoFlood = false;
    int age = 0;
    IBlockState b;
    Block bblock;

    public EntityFalloutUnderGround(World p_i1582_1_) {
        super(p_i1582_1_);
        this.func_70105_a(4.0f, 20.0f);
        this.field_70158_ak = false;
        this.field_70178_ae = true;
        this.phi = Math.PI * (3.0 - Math.sqrt(5.0));
        this.done = false;
        this.currentSample = 0;
    }

    public EntityFalloutUnderGround(World p_i1582_1_, int maxage) {
        super(p_i1582_1_);
        this.func_70105_a(4.0f, 20.0f);
        this.field_70178_ae = true;
        this.phi = (float)(Math.PI * (3.0 - Math.sqrt(5.0)));
        this.done = false;
        this.currentSample = 0;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SCALE, (Object)0);
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            if (!CompatibilityConfig.isWarDim(this.field_70170_p)) {
                this.done = true;
                this.func_70106_y();
                return;
            }
            ++this.age;
            if (this.age == 1200) {
                this.age = 0;
            }
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            int rayCounter = 0;
            long start = System.currentTimeMillis();
            for (int sample = this.currentSample; sample < this.maxSamples; ++sample) {
                this.currentSample = sample;
                if (rayCounter % 50 == 0 && System.currentTimeMillis() + 1L > start + (long)BombConfig.mk5) break;
                double fy = 2.0 * (double)sample / ((double)this.maxSamples - 1.0) - 1.0;
                double fr = Math.sqrt(1.0 - fy * fy);
                double theta = this.phi * (double)sample;
                this.stompRadRay(pos, Math.cos(theta) * fr, fy, Math.sin(theta) * fr);
                ++rayCounter;
            }
            if (this.currentSample >= this.maxSamples - 1) {
                if (this.falloutRainRadius1 > 0) {
                    EntityFalloutRain falloutRain = new EntityFalloutRain(this.field_70170_p);
                    falloutRain.doFallout = this.falloutRainDoFallout;
                    falloutRain.doFlood = this.falloutRainDoFlood;
                    falloutRain.field_70165_t = this.field_70165_t;
                    falloutRain.field_70163_u = this.field_70163_u;
                    falloutRain.field_70161_v = this.field_70161_v;
                    falloutRain.setScale(this.falloutRainRadius1, this.falloutRainRadius2);
                    this.field_70170_p.func_72838_d((Entity)falloutRain);
                }
                this.func_70106_y();
            }
        }
    }

    private void stompRadRay(BlockPos.MutableBlockPos pos, double directionX, double directionY, double directionZ) {
        for (int l = 0; l < this.radius; ++l) {
            BlockDirt.DirtType meta;
            pos.func_189532_c(this.field_70165_t + directionX * (double)l, this.field_70163_u + directionY * (double)l, this.field_70161_v + directionZ * (double)l);
            if (pos.func_177956_o() < 0 || pos.func_177956_o() > 255) {
                return;
            }
            if (this.field_70170_p.func_175623_d((BlockPos)pos)) continue;
            this.b = this.field_70170_p.func_180495_p((BlockPos)pos);
            this.bblock = this.b.func_177230_c();
            if (this.bblock instanceof BlockStone || this.bblock == Blocks.field_150347_e) {
                double ranDist = (double)l * (1.0 + this.field_70170_p.field_73012_v.nextDouble() * 0.1);
                if (ranDist > this.s1) {
                    this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.sellafield_slaked.func_176203_a(this.field_70170_p.field_73012_v.nextInt(4)));
                } else if (ranDist > this.s2) {
                    this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.sellafield_0.func_176203_a(this.field_70170_p.field_73012_v.nextInt(4)));
                } else if (ranDist > this.s3) {
                    this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.sellafield_1.func_176203_a(this.field_70170_p.field_73012_v.nextInt(4)));
                } else if (ranDist > this.s4) {
                    this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.sellafield_2.func_176203_a(this.field_70170_p.field_73012_v.nextInt(4)));
                } else if (ranDist > this.s5) {
                    this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.sellafield_3.func_176203_a(this.field_70170_p.field_73012_v.nextInt(4)));
                } else if (ranDist > this.s6) {
                    this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.sellafield_4.func_176203_a(this.field_70170_p.field_73012_v.nextInt(4)));
                } else if (ranDist <= this.s6) {
                    this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.sellafield_core.func_176203_a(this.field_70170_p.field_73012_v.nextInt(4)));
                }
                return;
            }
            if (this.bblock == Blocks.field_150357_h || this.bblock == ModBlocks.ore_bedrock_oil || this.bblock == ModBlocks.ore_bedrock_block) {
                if (this.field_70170_p.func_175623_d(pos.func_177984_a())) {
                    this.field_70170_p.func_175656_a(pos.func_177984_a(), ModBlocks.toxic_block.func_176223_P());
                }
                return;
            }
            Block ranDist = this.bblock;
            if (ranDist instanceof BlockLeaves) {
                BlockLeaves bLeaf = (BlockLeaves)ranDist;
                if (!(this.bblock instanceof WasteLeaves)) {
                    if ((double)l > this.s1) {
                        BlockPlanks.EnumType type = null;
                        try {
                            type = bLeaf.func_176233_b(bLeaf.func_176201_c(this.b));
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {
                            // empty catch block
                        }
                        if (type == null) {
                            type = BlockPlanks.EnumType.OAK;
                        }
                        this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.waste_leaves.func_176223_P().func_177226_a(WasteLeaves.VARIANT, (Comparable)type));
                        continue;
                    }
                    this.field_70170_p.func_175698_g((BlockPos)pos);
                    continue;
                }
            }
            if (this.bblock instanceof BlockBush) {
                if (this.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150458_ak) {
                    this.placeBlockFromDist(l, ModBlocks.waste_dirt, pos.func_177977_b());
                    this.placeBlockFromDist(l, ModBlocks.waste_grass_tall, (BlockPos)pos);
                    continue;
                }
                if (this.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockGrass) {
                    this.placeBlockFromDist(l, ModBlocks.waste_earth, pos.func_177977_b());
                    this.placeBlockFromDist(l, ModBlocks.waste_grass_tall, (BlockPos)pos);
                    continue;
                }
                if (this.field_70170_p.func_180495_p(pos.func_177977_b()).func_177230_c() != Blocks.field_150391_bh) continue;
                this.placeBlockFromDist(l, ModBlocks.waste_mycelium, pos.func_177977_b());
                this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.mush.func_176223_P());
                continue;
            }
            if (this.bblock instanceof BlockGrass) {
                this.placeBlockFromDist(l, ModBlocks.waste_earth, (BlockPos)pos);
                return;
            }
            if (this.bblock instanceof BlockDirt) {
                meta = (BlockDirt.DirtType)this.b.func_177229_b((IProperty)BlockDirt.field_176386_a);
                if (meta == BlockDirt.DirtType.DIRT) {
                    this.placeBlockFromDist(l, ModBlocks.waste_dirt, (BlockPos)pos);
                } else if (meta == BlockDirt.DirtType.COARSE_DIRT) {
                    this.placeBlockFromDist(l, ModBlocks.waste_gravel, (BlockPos)pos);
                } else if (meta == BlockDirt.DirtType.PODZOL) {
                    this.placeBlockFromDist(l, ModBlocks.waste_mycelium, (BlockPos)pos);
                }
                return;
            }
            if (this.bblock == Blocks.field_150458_ak) {
                this.placeBlockFromDist(l, ModBlocks.waste_dirt, (BlockPos)pos);
                continue;
            }
            if (this.bblock instanceof BlockSnow) {
                this.placeBlockFromDist(l, ModBlocks.waste_snow, (BlockPos)pos);
                continue;
            }
            if (this.bblock instanceof BlockSnowBlock) {
                this.placeBlockFromDist(l, ModBlocks.waste_snow_block, (BlockPos)pos);
                continue;
            }
            if (this.bblock instanceof BlockIce) {
                this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.waste_ice.func_176223_P());
                continue;
            }
            if (this.bblock == Blocks.field_150391_bh) {
                this.placeBlockFromDist(l, ModBlocks.waste_mycelium, (BlockPos)pos);
                return;
            }
            if (this.bblock instanceof BlockGravel) {
                this.placeBlockFromDist(l, ModBlocks.waste_gravel, (BlockPos)pos);
                return;
            }
            if (this.bblock == Blocks.field_150322_A) {
                this.placeBlockFromDist(l, ModBlocks.waste_sandstone, (BlockPos)pos);
                return;
            }
            if (this.bblock == Blocks.field_180395_cM) {
                this.placeBlockFromDist(l, ModBlocks.waste_sandstone_red, (BlockPos)pos);
                return;
            }
            if (this.bblock == Blocks.field_150405_ch || this.bblock == Blocks.field_150406_ce) {
                this.placeBlockFromDist(l, ModBlocks.waste_terracotta, (BlockPos)pos);
                return;
            }
            if (this.bblock instanceof BlockSand) {
                meta = (BlockSand.EnumType)this.b.func_177229_b((IProperty)BlockSand.field_176504_a);
                if (this.field_70146_Z.nextInt(60) == 0) {
                    this.placeBlockFromDist(l, meta == BlockSand.EnumType.SAND ? ModBlocks.waste_trinitite : ModBlocks.waste_trinitite_red, (BlockPos)pos);
                } else {
                    this.placeBlockFromDist(l, meta == BlockSand.EnumType.SAND ? ModBlocks.waste_sand : ModBlocks.waste_sand_red, (BlockPos)pos);
                }
                return;
            }
            if (this.bblock == Blocks.field_150435_aG) {
                this.field_70170_p.func_175656_a((BlockPos)pos, Blocks.field_150405_ch.func_176223_P());
                return;
            }
            if (this.bblock == Blocks.field_150341_Y) {
                this.field_70170_p.func_175656_a((BlockPos)pos, Blocks.field_150365_q.func_176223_P());
                return;
            }
            if (this.bblock == Blocks.field_150365_q) {
                if ((double)l < this.s6) {
                    int ra = this.field_70146_Z.nextInt(150);
                    if (ra < 7) {
                        this.field_70170_p.func_175656_a((BlockPos)pos, Blocks.field_150482_ag.func_176223_P());
                    } else if (ra < 10) {
                        this.field_70170_p.func_175656_a((BlockPos)pos, Blocks.field_150412_bA.func_176223_P());
                    }
                }
                return;
            }
            if (this.bblock == Blocks.field_150420_aW || this.bblock == Blocks.field_150419_aX) {
                if ((double)l < this.s0) {
                    meta = (BlockHugeMushroom.EnumType)this.b.func_177229_b((IProperty)BlockHugeMushroom.field_176380_a);
                    if (meta == BlockHugeMushroom.EnumType.STEM) {
                        this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.mush_block_stem.func_176223_P());
                    } else {
                        this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.mush_block.func_176223_P());
                    }
                }
                return;
            }
            if (this.bblock instanceof BlockLog) {
                if ((double)l < this.s0) {
                    this.field_70170_p.func_175656_a((BlockPos)pos, ((WasteLog)ModBlocks.waste_log).getSameRotationState(this.b));
                }
                return;
            }
            if (this.b.func_185904_a() == Material.field_151575_d && this.bblock != ModBlocks.waste_log && this.bblock != ModBlocks.waste_planks) {
                if ((double)l < this.s0) {
                    this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.waste_planks.func_176223_P());
                }
                return;
            }
            if (this.b.func_177230_c() == Blocks.field_150395_bd) {
                this.field_70170_p.func_175698_g((BlockPos)pos);
                continue;
            }
            if (this.bblock == ModBlocks.ore_uranium) {
                if ((double)l <= this.s6) {
                    if (this.field_70146_Z.nextInt(1 + VersatileConfig.getSchrabOreChance()) == 0 || (double)l < this.s7) {
                        this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.ore_schrabidium.func_176223_P());
                    } else {
                        this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.ore_uranium_scorched.func_176223_P());
                    }
                }
                return;
            }
            if (this.bblock == ModBlocks.ore_nether_uranium) {
                if ((double)l <= this.s5) {
                    if (this.field_70146_Z.nextInt(1 + VersatileConfig.getSchrabOreChance()) == 0) {
                        this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.ore_nether_schrabidium.func_176223_P());
                    } else {
                        this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.ore_nether_uranium_scorched.func_176223_P());
                    }
                }
                return;
            }
            if (this.bblock == ModBlocks.ore_gneiss_uranium) {
                if ((double)l <= this.s4) {
                    if (this.field_70146_Z.nextInt(1 + VersatileConfig.getSchrabOreChance() / 2) == 0) {
                        this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.ore_gneiss_schrabidium.func_176223_P());
                    } else {
                        this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.ore_gneiss_uranium_scorched.func_176223_P());
                    }
                }
                return;
            }
            if (this.bblock == ModBlocks.brick_concrete) {
                if (this.field_70146_Z.nextInt(60) == 0) {
                    this.field_70170_p.func_175656_a((BlockPos)pos, ModBlocks.brick_concrete_broken.func_176223_P());
                }
                return;
            }
            if (this.b.func_185904_a() != Material.field_151576_e && this.b.func_185904_a() != Material.field_151573_f) continue;
            return;
        }
    }

    public void placeBlockFromDist(double dist, Block b, BlockPos pos) {
        double ranDist = dist * (1.0 + this.field_70170_p.field_73012_v.nextDouble() * 0.2);
        if (ranDist > this.s1) {
            this.field_70170_p.func_175656_a(pos, b.func_176203_a(0));
        } else if (ranDist > this.s2) {
            this.field_70170_p.func_175656_a(pos, b.func_176203_a(1));
        } else if (ranDist > this.s3) {
            this.field_70170_p.func_175656_a(pos, b.func_176203_a(2));
        } else if (ranDist > this.s4) {
            this.field_70170_p.func_175656_a(pos, b.func_176203_a(3));
        } else if (ranDist > this.s5) {
            this.field_70170_p.func_175656_a(pos, b.func_176203_a(4));
        } else if (ranDist > this.s6) {
            this.field_70170_p.func_175656_a(pos, b.func_176203_a(5));
        } else if (ranDist <= this.s6) {
            this.field_70170_p.func_175656_a(pos, b.func_176203_a(6));
        }
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbt) {
        this.setScale(nbt.func_74762_e("scale"));
        this.currentSample = nbt.func_74762_e("currentSample");
        this.falloutRainRadius1 = nbt.func_74762_e("fR1");
        this.falloutRainRadius2 = nbt.func_74762_e("fR2");
        this.falloutRainDoFallout = nbt.func_74767_n("fRfallout");
        this.falloutRainDoFlood = nbt.func_74767_n("fRflood");
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74768_a("scale", this.getScale());
        nbt.func_74768_a("currentSample", this.currentSample);
        nbt.func_74768_a("fR1", this.falloutRainRadius1);
        nbt.func_74768_a("fR2", this.falloutRainRadius2);
        nbt.func_74757_a("fRfallout", this.falloutRainDoFallout);
        nbt.func_74757_a("fRflood", this.falloutRainDoFlood);
    }

    public void setScale(int i) {
        this.field_70180_af.func_187227_b(SCALE, (Object)i);
        this.s0 = 0.84 * (double)i;
        this.s1 = 0.74 * (double)i;
        this.s2 = 0.64 * (double)i;
        this.s3 = 0.54 * (double)i;
        this.s4 = 0.44 * (double)i;
        this.s5 = 0.34 * (double)i;
        this.s6 = 0.24 * (double)i;
        this.s7 = 0.05 * (double)i;
        this.radius = i;
        this.maxSamples = (int)(Math.PI * Math.pow(i, 2.0));
    }

    public int getScale() {
        int scale = (Integer)this.field_70180_af.func_187225_a(SCALE);
        return scale == 0 ? 1 : scale;
    }
}

