/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.mob;

import com.hbm.config.CompatibilityConfig;
import com.hbm.interfaces.IRadiationImmune;
import com.hbm.items.ModItems;
import com.hbm.render.amlfrom1710.Vec3;
import com.hbm.util.ContaminationUtil;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOcelotAttack;
import net.minecraft.entity.ai.EntityAIOcelotSit;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;

public class EntityThermonuclearCat
extends EntityOcelot
implements IRadiationImmune {
    public static final int catCount = 16;
    public static final int effectRadius = 16;
    public EntityAITempt aiTemptThermo;

    public EntityThermonuclearCat(World worldIn) {
        super(worldIn);
        this.field_70178_ae = true;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111128_a(5.0);
    }

    @NotNull
    public Item getTemptItem() {
        return ModItems.billet_nuclear_waste;
    }

    protected void func_184651_r() {
        this.field_70911_d = new EntityAISit((EntityTameable)this);
        this.aiTemptThermo = new EntityAITempt((EntityCreature)this, 0.6, this.getTemptItem(), true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiTemptThermo);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFollowOwner((EntityTameable)this, 1.0, 20.0f, 5.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIOcelotSit((EntityOcelot)this, 0.8));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.3f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIOcelotAttack((EntityLiving)this));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 0.8));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.8, 1.0000001E-5f));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 10.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityMob.class, 10, false, false, null));
    }

    public EntityThermonuclearCat createChild(EntityAgeable ageable) {
        EntityThermonuclearCat entitycat = new EntityThermonuclearCat(this.field_70170_p);
        if (this.func_70909_n()) {
            entitycat.func_184754_b(this.func_184753_b());
            entitycat.func_70903_f(true);
            entitycat.setTameSkin(this.func_70913_u(), true);
        }
        return entitycat;
    }

    public boolean func_70878_b(EntityAnimal otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (!this.func_70909_n()) {
            return false;
        }
        if (!(otherAnimal instanceof EntityThermonuclearCat)) {
            return false;
        }
        EntityThermonuclearCat entityocelot = (EntityThermonuclearCat)otherAnimal;
        if (!entityocelot.func_70909_n()) {
            return false;
        }
        return this.func_70880_s() && entityocelot.func_70880_s();
    }

    public String func_70005_c_() {
        if (this.func_145818_k_()) {
            return this.func_95999_t();
        }
        return this.func_70909_n() ? I18n.func_74838_a((String)"entity.entity_thermo_cat_tamed.name") : super.func_70005_c_();
    }

    public boolean func_70652_k(Entity entityIn) {
        return entityIn.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), this.getCatDmg(this.func_70631_g_(), this.isLegendary()));
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (this.func_70909_n()) {
            if (!this.field_70170_p.field_72995_K && this.func_152114_e((EntityLivingBase)player) && !this.func_70877_b(itemstack)) {
                this.field_70911_d.func_75270_a(!this.func_70906_o());
            }
        } else if ((this.aiTemptThermo == null || this.aiTemptThermo.func_75277_f()) && itemstack.func_77973_b() == this.getTemptItem() && player.func_70068_e((Entity)this) < 9.0) {
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70146_Z.nextInt(3) == 0 && !ForgeEventFactory.onAnimalTame((EntityAnimal)this, (EntityPlayer)player)) {
                    this.func_193101_c(player);
                    this.func_70912_b(EntityThermonuclearCat.rollTameSkin(this.field_70170_p.field_73012_v));
                    this.func_70908_e(true);
                    this.field_70911_d.func_75270_a(true);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                } else {
                    this.func_70908_e(false);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                }
            }
            return true;
        }
        if (itemstack.func_77973_b() == Items.field_151115_aP) {
            return false;
        }
        return super.func_184645_a(player, hand);
    }

    public static int rollTameSkin(Random rand) {
        float chance = rand.nextFloat();
        if ((double)chance > 0.2) {
            return 1 + rand.nextInt(10);
        }
        return 11 + rand.nextInt(5);
    }

    public void func_70912_b(int skinId) {
        this.setTameSkin(skinId, this.func_70631_g_());
    }

    public void setTameSkin(int skinId, boolean isChild) {
        super.func_70912_b(skinId);
        int catHP = this.getCatHP(isChild, skinId > 10);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)catHP);
        this.func_70606_j(catHP);
        if (skinId > 10) {
            this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(20.0);
            this.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111128_a(10.0);
        }
    }

    public float getCatRad(boolean isChild, boolean isLegendary) {
        return (isChild ? 2 : 20) * (isLegendary ? 2 : 1);
    }

    public int getCatHP(boolean isChild, boolean isLegendary) {
        return (isChild ? 10 : 100) * (isLegendary ? 2 : 1);
    }

    public float getCatDmg(boolean isChild, boolean isLegendary) {
        return (isChild ? 4 : 10) * (isLegendary ? 2 : 1);
    }

    public boolean isLegendary() {
        return this.func_70913_u() > 10;
    }

    public void func_70636_d() {
        if (CompatibilityConfig.isWarDim(this.field_70170_p)) {
            ContaminationUtil.radiate(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 16.0, this.getCatRad(this.func_70631_g_(), this.isLegendary()));
        }
        super.func_70636_d();
    }

    public static void convertInRadiusToThermo(World world, double x, double y, double z, double radius) {
        List entities = world.func_72872_a(EntityOcelot.class, new AxisAlignedBB(x, y, z, x, y, z).func_72314_b(radius, radius, radius));
        for (EntityOcelot e : entities) {
            Vec3 vec;
            double len;
            if (e instanceof EntityThermonuclearCat || !((len = (vec = Vec3.createVectorHelper(e.field_70165_t - x, e.field_70163_u + (double)e.func_70047_e() - y, e.field_70161_v - z)).length()) < radius)) continue;
            EntityThermonuclearCat.convertToThermo(world, e);
        }
    }

    public static void convertToThermo(World world, EntityOcelot ocel) {
        if (ocel instanceof EntityThermonuclearCat || ocel.field_70128_L) {
            return;
        }
        EntityThermonuclearCat cat = new EntityThermonuclearCat(world);
        cat.func_70012_b(ocel.field_70165_t, ocel.field_70163_u, ocel.field_70161_v, ocel.field_70177_z, ocel.field_70125_A);
        cat.func_96094_a(ocel.func_95999_t());
        cat.func_70873_a(ocel.func_70874_b());
        cat.func_98054_a(ocel.func_70631_g_());
        cat.func_70903_f(ocel.func_70909_n());
        if (cat.func_70909_n()) {
            cat.func_70912_b(EntityThermonuclearCat.rollTameSkin(world.field_73012_v));
        } else {
            cat.func_70912_b(0);
        }
        cat.func_184754_b(ocel.func_184753_b());
        cat.func_70904_g(ocel.func_70906_o());
        cat.field_70911_d.func_75270_a(ocel.func_70906_o());
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)cat);
        }
        ocel.func_70106_y();
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == ModItems.powder_balefire;
    }

    protected boolean func_70692_ba() {
        return !this.func_70909_n() && this.field_70173_aa > 24000;
    }

    protected int func_70693_a(EntityPlayer player) {
        return 200;
    }

    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, DamageSource source) {
        super.func_184610_a(wasRecentlyHit, lootingModifier, source);
        this.func_145779_a(ModItems.nuclear_waste, Math.max(1, lootingModifier));
    }
}

