/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.projectile;

import com.hbm.config.CompatibilityConfig;
import com.hbm.explosion.ExplosionChaos;
import com.hbm.items.ModItems;
import com.hbm.lib.ModDamageSource;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketChangeGameState;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityFire
extends Entity
implements IProjectile {
    private static final DataParameter<Boolean> CRITICAL = EntityDataManager.func_187226_a(EntityFire.class, (DataSerializer)DataSerializers.field_187198_h);
    private int field_145791_d = -1;
    private int field_145792_e = -1;
    private int field_145789_f = -1;
    public double gravity = 0.0;
    private Block field_145790_g;
    private int inData;
    private boolean inGround;
    public int canBePickedUp;
    public int arrowShake;
    public Entity shootingEntity;
    private int ticksInGround;
    private int ticksInAir;
    public int maxAge = 20;
    private double damage = 2.0;
    private int knockbackStrength;

    public EntityFire(World worldIn) {
        super(worldIn);
        if (worldIn.field_72995_K) {
            EntityFire.func_184227_b((double)10.0);
        }
        this.func_70105_a(0.5f, 0.5f);
    }

    public EntityFire(World w, double x, double y, double z) {
        this(w);
        this.func_70107_b(x, y, z);
    }

    public EntityFire(World w, EntityLivingBase shooter, EntityLivingBase shootingAt, float velocity, float inaccuracy) {
        this(w);
        this.shootingEntity = shooter;
        if (shooter instanceof EntityPlayer) {
            this.canBePickedUp = 1;
        }
        this.field_70163_u = shooter.field_70163_u + (double)shooter.func_70047_e() - (double)0.1f;
        double d0 = shootingAt.field_70165_t - shooter.field_70165_t;
        double d1 = shootingAt.func_174813_aQ().field_72338_b + (double)(shootingAt.field_70131_O / 3.0f) - this.field_70163_u;
        double d2 = shootingAt.field_70161_v - shooter.field_70161_v;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        if (d3 >= 1.0E-7) {
            float f2 = (float)(Math.atan2(d2, d0) * 180.0 / Math.PI) - 90.0f;
            float f3 = (float)(-(Math.atan2(d1, d3) * 180.0 / Math.PI));
            double d4 = d0 / d3;
            double d5 = d2 / d3;
            this.func_70012_b(shooter.field_70165_t + d4, this.field_70163_u, shooter.field_70161_v + d5, f2, f3);
            float f4 = (float)d3 * 0.2f;
            this.func_70186_c(d0, d1 + (double)f4, d2, velocity, inaccuracy);
        }
    }

    public EntityFire(World w, EntityLivingBase shooter, float velocity, EnumHand hand) {
        this(w);
        this.shootingEntity = shooter;
        if (shooter instanceof EntityPlayer) {
            this.canBePickedUp = 1;
        }
        this.func_70105_a(0.5f, 0.5f);
        this.func_70012_b(shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e(), shooter.field_70161_v, shooter.field_70177_z, shooter.field_70125_A);
        if (hand == EnumHand.MAIN_HAND) {
            this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
            this.field_70163_u -= (double)0.1f;
            this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        } else {
            this.field_70165_t += (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
            this.field_70163_u -= (double)0.1f;
            this.field_70161_v += (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f);
        }
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, velocity * 1.5f, 1.0f);
    }

    public EntityFire(World world, int x, int y, int z, double mx, double my, double mz, double grav) {
        this(world);
        this.field_70165_t = (float)x + 0.5f;
        this.field_70163_u = (float)y + 0.5f;
        this.field_70161_v = (float)z + 0.5f;
        this.field_70159_w = mx;
        this.field_70181_x = my;
        this.field_70179_y = mz;
        this.gravity = grav;
    }

    public void func_70071_h_() {
        AxisAlignedBB axisalignedbb;
        BlockPos pos;
        IBlockState blockstate;
        super.func_70071_h_();
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
        }
        if ((blockstate = this.field_70170_p.func_180495_p(pos = new BlockPos(this.field_145791_d, this.field_145792_e, this.field_145789_f))).func_185904_a() != Material.field_151579_a && (axisalignedbb = blockstate.func_185890_d((IBlockAccess)this.field_70170_p, pos)) != null && axisalignedbb.func_186670_a(pos).func_72318_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v))) {
            this.inGround = true;
        }
        if (this.arrowShake > 0) {
            --this.arrowShake;
        }
        if (this.inGround) {
            this.func_70106_y();
            int i = 3;
            if (!this.field_70170_p.field_72995_K) {
                ExplosionChaos.burn(this.field_70170_p, new BlockPos((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v), i);
                ExplosionChaos.flameDeath(this.field_70170_p, new BlockPos((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v), i * 2);
            }
        } else {
            float f1;
            ++this.ticksInAir;
            Vec3d vec31 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            Vec3d vec3 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            RayTraceResult movingobjectposition = this.field_70170_p.func_147447_a(vec31, vec3, false, true, false);
            vec31 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            vec3 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            if (movingobjectposition != null) {
                vec3 = new Vec3d(movingobjectposition.field_72307_f.field_72450_a, movingobjectposition.field_72307_f.field_72448_b, movingobjectposition.field_72307_f.field_72449_c);
            }
            Entity entity = null;
            List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0));
            double d0 = 0.0;
            for (int i = 0; i < list.size(); ++i) {
                double d1;
                Entity entity1 = (Entity)list.get(i);
                if (!entity1.func_70067_L() || entity1 == this.shootingEntity && this.ticksInAir < 5) continue;
                f1 = 0.3f;
                AxisAlignedBB axisalignedbb1 = entity1.func_174813_aQ().func_186662_g((double)f1);
                RayTraceResult movingobjectposition1 = axisalignedbb1.func_72327_a(vec31, vec3);
                if (movingobjectposition1 == null || !((d1 = vec31.func_72438_d(movingobjectposition1.field_72307_f)) < d0) && d0 != 0.0) continue;
                entity = entity1;
                d0 = d1;
            }
            if (entity != null) {
                movingobjectposition = new RayTraceResult(entity);
            }
            if (movingobjectposition != null && movingobjectposition.field_72308_g != null && movingobjectposition.field_72308_g instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)movingobjectposition.field_72308_g;
                if (entityplayer.field_71075_bZ.field_75102_a || this.shootingEntity instanceof EntityPlayer && !((EntityPlayer)this.shootingEntity).func_96122_a(entityplayer)) {
                    movingobjectposition = null;
                }
            }
            if (movingobjectposition != null && CompatibilityConfig.isWarDim(this.field_70170_p)) {
                if (movingobjectposition.field_72308_g != null) {
                    float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
                    int k = MathHelper.func_76143_f((double)((double)f2 * this.damage));
                    if (this.getIsCritical()) {
                        k += this.field_70146_Z.nextInt(k / 2 + 2);
                    }
                    DamageSource damagesource = null;
                    damagesource = this.shootingEntity == null ? DamageSource.field_76377_j : ModDamageSource.causeFireDamage(this, this.shootingEntity);
                    if (!(movingobjectposition.field_72308_g instanceof EntityEnderman) && this.field_70173_aa >= 5) {
                        movingobjectposition.field_72308_g.func_70015_d(10);
                    }
                    if (movingobjectposition.field_72308_g.func_70097_a(damagesource, (float)k)) {
                        if (movingobjectposition.field_72308_g instanceof EntityLivingBase) {
                            float f4;
                            EntityLivingBase entitylivingbase = (EntityLivingBase)movingobjectposition.field_72308_g;
                            if (this.knockbackStrength > 0 && (f4 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y))) > 0.0f) {
                                movingobjectposition.field_72308_g.func_70024_g(this.field_70159_w * (double)this.knockbackStrength * (double)0.6f / (double)f4, 0.1, this.field_70179_y * (double)this.knockbackStrength * (double)0.6f / (double)f4);
                            }
                            if (this.shootingEntity != null && this.shootingEntity instanceof EntityLivingBase) {
                                EnchantmentHelper.func_151384_a((EntityLivingBase)entitylivingbase, (Entity)this.shootingEntity);
                                EnchantmentHelper.func_151385_b((EntityLivingBase)((EntityLivingBase)this.shootingEntity), (Entity)entitylivingbase);
                            }
                            if (this.shootingEntity != null && movingobjectposition.field_72308_g != this.shootingEntity && movingobjectposition.field_72308_g instanceof EntityPlayer && this.shootingEntity instanceof EntityPlayerMP) {
                                ((EntityPlayerMP)this.shootingEntity).field_71135_a.func_147359_a((Packet)new SPacketChangeGameState(6, 0.0f));
                            }
                        }
                        if (!(movingobjectposition.field_72308_g instanceof EntityEnderman) && !this.field_70170_p.field_72995_K && movingobjectposition.field_72308_g instanceof EntityLivingBase) {
                            movingobjectposition.field_72308_g.func_70097_a(damagesource, 5.0f);
                        }
                    }
                } else {
                    this.field_145791_d = movingobjectposition.func_178782_a().func_177958_n();
                    this.field_145792_e = movingobjectposition.func_178782_a().func_177956_o();
                    this.field_145789_f = movingobjectposition.func_178782_a().func_177952_p();
                    BlockPos newPos = new BlockPos(this.field_145791_d, this.field_145792_e, this.field_145789_f);
                    IBlockState st = this.field_70170_p.func_180495_p(newPos);
                    this.field_145790_g = st.func_177230_c();
                    this.inData = st.func_177230_c().func_176201_c(st);
                    this.field_70159_w = (float)(movingobjectposition.field_72307_f.field_72450_a - this.field_70165_t);
                    this.field_70181_x = (float)(movingobjectposition.field_72307_f.field_72448_b - this.field_70163_u);
                    this.field_70179_y = (float)(movingobjectposition.field_72307_f.field_72449_c - this.field_70161_v);
                    float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
                    this.field_70165_t -= this.field_70159_w / (double)f2 * (double)0.05f;
                    this.field_70163_u -= this.field_70181_x / (double)f2 * (double)0.05f;
                    this.field_70161_v -= this.field_70179_y / (double)f2 * (double)0.05f;
                    this.inGround = true;
                    this.arrowShake = 7;
                    this.setIsCritical(false);
                    if (st.func_185904_a() != Material.field_151579_a) {
                        this.field_145790_g.func_180634_a(this.field_70170_p, newPos, st, (Entity)this);
                    }
                }
            }
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
            f1 = 0.05f;
            if (this.func_70090_H()) {
                for (int l = 0; l < 4; ++l) {
                    float f4 = 0.25f;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t - this.field_70159_w * (double)f4, this.field_70163_u - this.field_70181_x * (double)f4, this.field_70161_v - this.field_70179_y * (double)f4, this.field_70159_w, this.field_70181_x + 0.2, this.field_70179_y, new int[0]);
                }
                this.func_70106_y();
            }
            if (this.func_70026_G()) {
                this.damage *= (double)0.8f;
            }
            float f3 = 0.8f;
            this.field_70159_w *= (double)f3;
            this.field_70181_x *= (double)f3;
            this.field_70179_y *= (double)f3;
            this.field_70181_x -= this.gravity;
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.func_145775_I();
        }
        if (this.field_70173_aa > this.maxAge) {
            this.func_70106_y();
        }
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        float f2 = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f2;
        y /= (double)f2;
        z /= (double)f2;
        x += this.field_70146_Z.nextGaussian() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)inaccuracy;
        y += this.field_70146_Z.nextGaussian() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)inaccuracy;
        z += this.field_70146_Z.nextGaussian() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * (double)0.0075f * (double)inaccuracy;
        this.field_70159_w = x *= (double)velocity;
        this.field_70181_x = y *= (double)velocity;
        this.field_70179_y = z *= (double)velocity;
        float f3 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(x, z) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(y, f3) * 180.0 / Math.PI);
        this.ticksInGround = 0;
    }

    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.func_70107_b(x, y, z);
        this.func_70101_b(yaw, pitch);
    }

    public void func_70016_h(double x, double y, double z) {
        this.field_70159_w = x;
        this.field_70181_x = y;
        this.field_70179_y = z;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(x, z) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(y, f) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
            this.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            this.ticksInGround = 0;
        }
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(CRITICAL, (Object)false);
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.field_145791_d = compound.func_74765_d("xTile");
        this.field_145792_e = compound.func_74765_d("yTile");
        this.field_145789_f = compound.func_74765_d("zTile");
        this.ticksInGround = compound.func_74765_d("life");
        this.field_145790_g = Block.func_149729_e((int)(compound.func_74771_c("inTile") & 0xFF));
        this.inData = compound.func_74771_c("inData") & 0xFF;
        this.arrowShake = compound.func_74771_c("shake") & 0xFF;
        boolean bl = this.inGround = compound.func_74771_c("inGround") == 1;
        if (compound.func_150297_b("damage", 99)) {
            this.damage = compound.func_74769_h("damage");
        }
        if (compound.func_150297_b("pickup", 99)) {
            this.canBePickedUp = compound.func_74771_c("pickup");
        } else if (compound.func_150297_b("player", 99)) {
            this.canBePickedUp = compound.func_74767_n("player") ? 1 : 0;
        }
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74777_a("xTile", (short)this.field_145791_d);
        compound.func_74777_a("yTile", (short)this.field_145792_e);
        compound.func_74777_a("zTile", (short)this.field_145789_f);
        compound.func_74777_a("life", (short)this.ticksInGround);
        compound.func_74774_a("inTile", (byte)Block.func_149682_b((Block)this.field_145790_g));
        compound.func_74774_a("inData", (byte)this.inData);
        compound.func_74774_a("shake", (byte)this.arrowShake);
        compound.func_74774_a("inGround", (byte)(this.inGround ? 1 : 0));
        compound.func_74774_a("pickup", (byte)this.canBePickedUp);
        compound.func_74780_a("damage", this.damage);
    }

    public void func_70100_b_(EntityPlayer entityIn) {
        if (!this.field_70170_p.field_72995_K && this.inGround && this.arrowShake <= 0) {
            boolean flag;
            boolean bl = flag = this.canBePickedUp == 1 || this.canBePickedUp == 2 && entityIn.field_71075_bZ.field_75098_d;
            if (this.canBePickedUp == 1 && !entityIn.field_71071_by.func_70441_a(new ItemStack(ModItems.ammo_rocket, 1))) {
                flag = false;
            }
            if (flag) {
                entityIn.func_71001_a((Entity)this, 1);
                this.func_70106_y();
            }
        }
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void setDamage(double damage) {
        this.damage = damage;
    }

    public double getDamage() {
        return this.damage;
    }

    public void setKnockbackStrength(int knockbackStrength) {
        this.knockbackStrength = knockbackStrength;
    }

    public boolean func_70075_an() {
        return false;
    }

    public void setIsCritical(boolean crit) {
        this.func_184212_Q().func_187227_b(CRITICAL, (Object)crit);
    }

    public boolean getIsCritical() {
        return (Boolean)this.func_184212_Q().func_187225_a(CRITICAL);
    }

    public float func_70013_c() {
        return 1.0f;
    }

    public int func_70070_b() {
        return 0xF000F0;
    }
}

