/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.entity.projectile;

import com.hbm.items.ModItems;
import com.hbm.render.amlfrom1710.Vec3;
import com.hbm.tileentity.machine.rbmk.RBMKDials;
import com.hbm.util.ContaminationUtil;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ReportedException;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityRBMKDebris
extends Entity {
    public static final DataParameter<Integer> TYPE_ID = EntityDataManager.func_187226_a(EntityRBMKDebris.class, (DataSerializer)DataSerializers.field_187192_b);
    public float rot;
    public float lastRot;
    private boolean hasSizeSet = false;

    public EntityRBMKDebris(World world) {
        super(world);
    }

    public EntityRBMKDebris(World world, double x, double y, double z, DebrisType type) {
        super(world);
        this.func_70107_b(x, y, z);
        this.setType(type);
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(TYPE_ID, (Object)0);
        this.rot = this.lastRot = this.field_70146_Z.nextFloat() * 360.0f;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            switch (this.getType()) {
                case BLANK: {
                    if (!player.field_71071_by.func_70441_a(new ItemStack(ModItems.debris_metal))) break;
                    this.func_70106_y();
                    break;
                }
                case ELEMENT: {
                    if (!player.field_71071_by.func_70441_a(new ItemStack(ModItems.debris_metal))) break;
                    this.func_70106_y();
                    break;
                }
                case FUEL: {
                    if (!player.field_71071_by.func_70441_a(new ItemStack(ModItems.debris_fuel))) break;
                    this.func_70106_y();
                    break;
                }
                case GRAPHITE: {
                    if (!player.field_71071_by.func_70441_a(new ItemStack(ModItems.debris_graphite))) break;
                    this.func_70106_y();
                    break;
                }
                case LID: {
                    if (!player.field_71071_by.func_70441_a(new ItemStack(ModItems.rbmk_lid))) break;
                    this.func_70106_y();
                    break;
                }
                case ROD: {
                    if (!player.field_71071_by.func_70441_a(new ItemStack(ModItems.debris_metal))) break;
                    this.func_70106_y();
                }
            }
            player.field_71069_bz.func_75142_b();
        }
        return false;
    }

    public void func_70071_h_() {
        if (!this.hasSizeSet) {
            switch (this.getType()) {
                case BLANK: {
                    this.func_70105_a(0.5f, 0.5f);
                    break;
                }
                case ELEMENT: {
                    this.func_70105_a(1.0f, 1.0f);
                    break;
                }
                case FUEL: {
                    this.func_70105_a(0.25f, 0.25f);
                    break;
                }
                case GRAPHITE: {
                    this.func_70105_a(0.25f, 0.25f);
                    break;
                }
                case LID: {
                    this.func_70105_a(1.0f, 0.5f);
                    break;
                }
                case ROD: {
                    this.func_70105_a(0.75f, 0.5f);
                }
            }
            this.hasSizeSet = true;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70181_x > 0.0) {
                Vec3 pos = Vec3.createVectorHelper(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                Vec3 next = Vec3.createVectorHelper(this.field_70165_t + this.field_70159_w * 2.0, this.field_70163_u + this.field_70181_x * 2.0, this.field_70161_v + this.field_70179_y * 2.0);
                RayTraceResult mop = this.field_70170_p.func_147447_a(pos.toVec3d(), next.toVec3d(), false, false, false);
                if (mop != null && mop.field_72313_a == RayTraceResult.Type.BLOCK) {
                    int x = mop.func_178782_a().func_177958_n();
                    int y = mop.func_178782_a().func_177956_o();
                    int z = mop.func_178782_a().func_177952_p();
                    for (int i = -1; i <= 1; ++i) {
                        for (int j = -1; j <= 1; ++j) {
                            for (int k = -1; k <= 1; ++k) {
                                int rn = Math.abs(i) + Math.abs(j) + Math.abs(k);
                                if (rn > 1 && this.field_70146_Z.nextInt(rn) != 0) continue;
                                this.field_70170_p.func_175698_g(new BlockPos(x + i, y + j, z + k));
                            }
                        }
                    }
                    this.func_70106_y();
                }
            }
            if (this.getType() == DebrisType.FUEL) {
                ContaminationUtil.radiate(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, 16.0, 100.0f);
            }
            if (!RBMKDials.getPermaScrap(this.field_70170_p) && this.field_70173_aa > this.getLifetime() + this.func_145782_y() % 50) {
                this.func_70106_y();
            }
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.field_70181_x -= 0.04;
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.lastRot = this.rot;
        if (this.field_70122_E) {
            this.field_70159_w *= 0.85;
            this.field_70179_y *= 0.85;
            this.field_70181_x *= -0.5;
        } else {
            this.rot += 10.0f;
            if (this.rot >= 360.0f) {
                this.rot -= 360.0f;
                this.lastRot -= 360.0f;
            }
        }
    }

    private int getLifetime() {
        switch (this.getType()) {
            case BLANK: {
                return 36000;
            }
            case ELEMENT: {
                return 36000;
            }
            case FUEL: {
                return 120000;
            }
            case GRAPHITE: {
                return 180000;
            }
            case LID: {
                return 6000;
            }
            case ROD: {
                return 12000;
            }
        }
        return 0;
    }

    public void setType(DebrisType type) {
        this.func_184212_Q().func_187227_b(TYPE_ID, (Object)type.ordinal());
    }

    public DebrisType getType() {
        return DebrisType.values()[Math.abs((Integer)this.func_184212_Q().func_187225_a(TYPE_ID)) % DebrisType.values().length];
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.func_184212_Q().func_187227_b(TYPE_ID, (Object)nbt.func_74762_e("debtype"));
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74768_a("debtype", ((Integer)this.func_184212_Q().func_187225_a(TYPE_ID)).intValue());
    }

    public void func_70091_d(MoverType type, double moX, double moY, double moZ) {
        int j;
        this.field_70170_p.field_72984_F.func_76320_a("move");
        if (this.field_70134_J) {
            this.field_70134_J = false;
        }
        double initMoX = moX;
        double initMoY = moY;
        double initMoZ = moZ;
        List list = this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ().func_72321_a(moX, moY, moZ));
        for (int i = 0; i < list.size(); ++i) {
            moY = ((AxisAlignedBB)list.get(i)).func_72323_b(this.func_174813_aQ(), moY);
        }
        this.func_174826_a(this.func_174813_aQ().func_72317_d(0.0, moY, 0.0));
        if (initMoY != moY) {
            moZ = 0.0;
            moY = 0.0;
            moX = 0.0;
        }
        boolean isGoingDown = this.field_70122_E || initMoY != moY && initMoY < 0.0;
        for (j = 0; j < list.size(); ++j) {
            moX = ((AxisAlignedBB)list.get(j)).func_72316_a(this.func_174813_aQ(), moX);
        }
        this.func_174826_a(this.func_174813_aQ().func_72317_d(moX, 0.0, 0.0));
        for (j = 0; j < list.size(); ++j) {
            moZ = ((AxisAlignedBB)list.get(j)).func_72322_c(this.func_174813_aQ(), moZ);
        }
        this.func_174826_a(this.func_174813_aQ().func_72317_d(0.0, 0.0, moZ));
        if (this.field_70138_W > 0.0f && isGoingDown && (initMoX != moX || initMoZ != moZ)) {
            int k;
            double d12 = moX;
            double d10 = moY;
            double d11 = moZ;
            moX = initMoX;
            moY = this.field_70138_W;
            moZ = initMoZ;
            AxisAlignedBB axisalignedbb1 = this.func_174813_aQ();
            list = this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ().func_72321_a(initMoX, moY, initMoZ));
            for (k = 0; k < list.size(); ++k) {
                moY = ((AxisAlignedBB)list.get(k)).func_72323_b(this.func_174813_aQ(), moY);
            }
            this.func_174826_a(this.func_174813_aQ().func_72317_d(0.0, moY, 0.0));
            for (k = 0; k < list.size(); ++k) {
                moX = ((AxisAlignedBB)list.get(k)).func_72316_a(this.func_174813_aQ(), moX);
            }
            this.func_174826_a(this.func_174813_aQ().func_72317_d(moX, 0.0, 0.0));
            for (k = 0; k < list.size(); ++k) {
                moZ = ((AxisAlignedBB)list.get(k)).func_72322_c(this.func_174813_aQ(), moZ);
            }
            this.func_174826_a(this.func_174813_aQ().func_72317_d(0.0, 0.0, moZ));
            moY = -this.field_70138_W;
            for (k = 0; k < list.size(); ++k) {
                moY = ((AxisAlignedBB)list.get(k)).func_72323_b(this.func_174813_aQ(), moY);
            }
            this.func_174826_a(this.func_174813_aQ().func_72317_d(0.0, moY, 0.0));
            if (d12 * d12 + d11 * d11 >= moX * moX + moZ * moZ) {
                moX = d12;
                moY = d10;
                moZ = d11;
                this.func_174826_a(axisalignedbb1);
            }
        }
        this.field_70170_p.field_72984_F.func_76319_b();
        this.field_70170_p.field_72984_F.func_76320_a("rest");
        this.field_70165_t = (this.func_174813_aQ().field_72340_a + this.func_174813_aQ().field_72336_d) / 2.0;
        this.field_70163_u = this.func_174813_aQ().field_72338_b + this.func_70033_W();
        this.field_70161_v = (this.func_174813_aQ().field_72339_c + this.func_174813_aQ().field_72334_f) / 2.0;
        this.field_70123_F = initMoX != moX || initMoZ != moZ;
        this.field_70124_G = initMoY != moY;
        this.field_70122_E = initMoY != moY && initMoY < 0.0;
        this.field_70132_H = this.field_70123_F || this.field_70124_G;
        int j6 = MathHelper.func_76128_c((double)this.field_70165_t);
        int i1 = MathHelper.func_76128_c((double)(this.field_70163_u - (double)0.2f));
        int k6 = MathHelper.func_76128_c((double)this.field_70161_v);
        BlockPos blockpos = new BlockPos(j6, i1, k6);
        IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
        this.func_184231_a(moY, this.field_70122_E, iblockstate, blockpos);
        if (initMoX != moX) {
            this.field_70159_w *= -0.75;
        }
        if (initMoY != moY) {
            this.field_70181_x = 0.0;
        }
        if (initMoZ != moZ) {
            this.field_70179_y *= -0.75;
        }
        try {
            this.func_145775_I();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Checking entity block collision");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Entity being checked for collision");
            this.func_85029_a(crashreportcategory);
            throw new ReportedException(crashreport);
        }
        this.field_70170_p.field_72984_F.func_76319_b();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double dist) {
        int range = 128;
        return dist < (double)(range * range);
    }

    public static enum DebrisType {
        BLANK,
        ELEMENT,
        FUEL,
        ROD,
        GRAPHITE,
        LID;

    }
}

