/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler;

import com.hbm.capability.HbmLivingProps;
import com.hbm.config.GeneralConfig;
import com.hbm.config.RadiationConfig;
import com.hbm.entity.mob.EntityDuck;
import com.hbm.entity.mob.EntityNuclearCreeper;
import com.hbm.entity.mob.EntityQuackos;
import com.hbm.entity.mob.EntityRADBeast;
import com.hbm.handler.RadiationWorldHandler;
import com.hbm.hazard.HazardSystem;
import com.hbm.interfaces.IRadResistantBlock;
import com.hbm.lib.ModDamageSource;
import com.hbm.main.AdvancementManager;
import com.hbm.main.MainRegistry;
import com.hbm.packet.AuxParticlePacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.saveddata.AuxSavedData;
import com.hbm.saveddata.RadiationSavedData;
import com.hbm.util.ContaminationUtil;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityZombieHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Mod.EventBusSubscriber(modid="hbm")
public class RadiationSystemNT {
    public static float minRadRate = 5.0E-6f;
    private static Map<World, WorldRadiationData> worldMap = new HashMap<World, WorldRadiationData>();
    private static int ticks;
    private static RadPocket[] pocketsByBlock;
    private static Queue<BlockPos> stack;

    public static void incrementRad(World world, BlockPos pos, float amount, float max) {
        if (pos.func_177956_o() < 0 || pos.func_177956_o() > 255 || !world.func_175667_e(pos)) {
            return;
        }
        RadPocket p = RadiationSystemNT.getPocket(world, pos);
        if (p.radiation < max) {
            p.radiation += amount;
        }
        if (amount > 0.0f) {
            WorldRadiationData data = RadiationSystemNT.getWorldRadData(world);
            data.addActivePocket(p);
        }
    }

    public static void decrementRad(World world, BlockPos pos, float amount) {
        if (pos.func_177956_o() < 0 || pos.func_177956_o() > 255 || !RadiationSystemNT.isSubChunkLoaded(world, pos)) {
            return;
        }
        RadPocket p = RadiationSystemNT.getPocket(world, pos);
        p.radiation -= Math.max(amount, 0.0f);
        if (p.radiation < 0.0f) {
            p.radiation = 0.0f;
        }
    }

    public static void setRadForCoord(World world, BlockPos pos, float amount) {
        RadPocket p = RadiationSystemNT.getPocket(world, pos);
        p.radiation = Math.max(amount, 0.0f);
        if (amount > 0.0f) {
            WorldRadiationData data = RadiationSystemNT.getWorldRadData(world);
            data.addActivePocket(p);
        }
    }

    public static float getRadForCoord(World world, BlockPos pos) {
        if (!RadiationSystemNT.isSubChunkLoaded(world, pos)) {
            return 0.0f;
        }
        if (RadiationSystemNT.getPocket(world, pos) == null) {
            return 0.0f;
        }
        return RadiationSystemNT.getPocket((World)world, (BlockPos)pos).radiation;
    }

    public static void jettisonData(World world) {
        WorldRadiationData data = RadiationSystemNT.getWorldRadData(world);
        data.data.clear();
        data.clearActivePockets();
    }

    public static RadPocket getPocket(World world, BlockPos pos) {
        return RadiationSystemNT.getSubChunkStorage(world, pos).getPocket(pos);
    }

    public static Collection<RadPocket> getActiveCollection(World world) {
        return RadiationSystemNT.getWorldRadData(world).getActivePockets();
    }

    public static boolean isSubChunkLoaded(World world, BlockPos pos) {
        if (pos.func_177956_o() > 255 || pos.func_177956_o() < 0) {
            return false;
        }
        WorldRadiationData worldRadData = worldMap.get(world);
        if (worldRadData == null) {
            return false;
        }
        ChunkRadiationStorage st = worldRadData.data.get(new ChunkPos(pos));
        if (st == null) {
            return false;
        }
        SubChunkRadiationStorage sc = st.getForYLevel(pos.func_177956_o());
        return sc != null;
    }

    public static SubChunkRadiationStorage getSubChunkStorage(World world, BlockPos pos) {
        ChunkRadiationStorage st = RadiationSystemNT.getChunkStorage(world, pos);
        SubChunkRadiationStorage sc = st.getForYLevel(pos.func_177956_o());
        if (sc == null) {
            RadiationSystemNT.rebuildChunkPockets(world.func_175726_f(pos), pos.func_177956_o() >> 4);
        }
        sc = st.getForYLevel(pos.func_177956_o());
        return sc;
    }

    public static ChunkRadiationStorage getChunkStorage(World world, BlockPos pos) {
        WorldRadiationData worldRadData = RadiationSystemNT.getWorldRadData(world);
        ChunkRadiationStorage st = worldRadData.data.get(new ChunkPos(pos));
        if (st == null) {
            st = new ChunkRadiationStorage(worldRadData, world.func_175726_f(pos));
            worldRadData.data.put(new ChunkPos(pos), st);
        }
        return st;
    }

    private static WorldRadiationData getWorldRadData(World world) {
        WorldRadiationData worldRadData = worldMap.get(world);
        if (worldRadData == null) {
            worldRadData = new WorldRadiationData(world);
            worldMap.put(world, worldRadData);
        }
        return worldRadData;
    }

    private static void updateRadSaveData(World world) {
        RadiationSavedData data = RadiationSavedData.getData(world);
        if (data.worldObj == null) {
            data.worldObj = world;
        }
        if (GeneralConfig.enableDebugMode) {
            MainRegistry.logger.info("[Debug] Updated system for entity contamination processing at worldtime " + world.func_82737_E());
        }
        data.updateSystem();
    }

    private static void updateEntityContamination(World world, boolean updateData) {
        if (world != null && !world.field_72995_K && GeneralConfig.enableRads) {
            int thunder;
            if (GeneralConfig.enableDebugMode) {
                MainRegistry.logger.info("[Debug] Starting entity contamination processing");
            }
            if ((thunder = AuxSavedData.getThunder(world)) > 0) {
                AuxSavedData.setThunder(world, thunder - 1);
            }
            if (!world.field_72996_f.isEmpty()) {
                RadiationSavedData data = RadiationSavedData.getData(world);
                if (data.worldObj == null) {
                    data.worldObj = world;
                }
                if (world.func_82737_E() % 20L == 15L && updateData) {
                    RadiationSystemNT.updateRadSaveData(world);
                }
                ArrayList oList = new ArrayList(world.field_72996_f);
                for (Object e : oList) {
                    if (e instanceof EntityLivingBase) {
                        float eRad;
                        EntityLivingBase entity = (EntityLivingBase)e;
                        if (entity instanceof EntityPlayer) {
                            EntityPlayer player = (EntityPlayer)entity;
                            if (RadiationConfig.neutronActivation) {
                                double recievedRadiation = ContaminationUtil.getNoNeutronPlayerRads((EntityLivingBase)player) * 4.0E-5 - 4.0E-5 * (double)RadiationConfig.neutronActivationThreshold;
                                float neutronRads = ContaminationUtil.getPlayerNeutronRads(player);
                                if (neutronRads > 0.0f) {
                                    ContaminationUtil.contaminate((EntityLivingBase)player, ContaminationUtil.HazardType.NEUTRON, ContaminationUtil.ContaminationType.CREATIVE, neutronRads * 0.05f);
                                } else {
                                    HbmLivingProps.setNeutron(entity, 0.0f);
                                }
                                if (recievedRadiation > (double)minRadRate) {
                                    ContaminationUtil.neutronActivateInventory(player, (float)recievedRadiation, 1.0f);
                                    player.field_71069_bz.func_75142_b();
                                }
                            }
                            if (player.field_71075_bZ.field_75098_d || player.func_175149_v()) continue;
                        }
                        if ((eRad = HbmLivingProps.getRadiation(entity)) >= 200.0f && entity.func_110143_aJ() > 0.0f && entity instanceof EntityCreeper) {
                            if (world.field_73012_v.nextInt(3) == 0) {
                                EntityNuclearCreeper creep = new EntityNuclearCreeper(world);
                                creep.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
                                if (!entity.field_70128_L) {
                                    world.func_72838_d((Entity)creep);
                                }
                                entity.func_70106_y();
                                continue;
                            }
                            entity.func_70097_a(ModDamageSource.radiation, 100.0f);
                            continue;
                        }
                        if (eRad >= 500.0f && entity instanceof EntityCow && !(entity instanceof EntityMooshroom)) {
                            EntityMooshroom creep = new EntityMooshroom(world);
                            creep.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
                            if (!entity.field_70128_L) {
                                world.func_72838_d((Entity)creep);
                            }
                            entity.func_70106_y();
                            continue;
                        }
                        if (eRad >= 600.0f && entity instanceof EntityVillager) {
                            EntityVillager vil = (EntityVillager)entity;
                            EntityZombieVillager creep = new EntityZombieVillager(world);
                            creep.func_190733_a(vil.func_70946_n());
                            creep.setForgeProfession(vil.getProfessionForge());
                            creep.func_82227_f(vil.func_70631_g_());
                            creep.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
                            if (!entity.field_70128_L) {
                                world.func_72838_d((Entity)creep);
                            }
                            entity.func_70106_y();
                            continue;
                        }
                        if (eRad >= 700.0f && entity instanceof EntityBlaze) {
                            EntityRADBeast creep = new EntityRADBeast(world);
                            creep.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
                            if (!entity.field_70128_L) {
                                world.func_72838_d((Entity)creep);
                            }
                            entity.func_70106_y();
                            continue;
                        }
                        if (eRad >= 800.0f && entity instanceof EntityHorse) {
                            EntityHorse horsie = (EntityHorse)entity;
                            EntityZombieHorse zomhorsie = new EntityZombieHorse(world);
                            zomhorsie.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
                            zomhorsie.func_70873_a(horsie.func_70874_b());
                            zomhorsie.func_110238_s(horsie.func_110252_cg());
                            zomhorsie.func_110251_o(horsie.func_110257_ck());
                            zomhorsie.func_110234_j(horsie.func_110248_bS());
                            zomhorsie.func_184779_b(horsie.func_184780_dh());
                            zomhorsie.func_190687_dF();
                            if (!entity.field_70128_L) {
                                world.func_72838_d((Entity)zomhorsie);
                            }
                            entity.func_70106_y();
                            continue;
                        }
                        if (eRad >= 900.0f && entity.getClass().equals(EntityDuck.class)) {
                            EntityQuackos quacc = new EntityQuackos(world);
                            quacc.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
                            if (!entity.field_70128_L) {
                                world.func_72838_d((Entity)quacc);
                            }
                            entity.func_70106_y();
                            continue;
                        }
                        if (eRad > 2500000.0f) {
                            HbmLivingProps.setRadiation(entity, 2500000.0f);
                        }
                        if (eRad >= 1000.0f) {
                            entity.func_70097_a(ModDamageSource.radiation, 1000.0f);
                            HbmLivingProps.setRadiation(entity, 0.0f);
                            if (entity.func_110143_aJ() > 0.0f) {
                                entity.func_70606_j(0.0f);
                                entity.func_70645_a(ModDamageSource.radiation);
                            }
                            if (!(entity instanceof EntityPlayerMP)) continue;
                            AdvancementManager.grantAchievement((EntityPlayerMP)entity, AdvancementManager.achRadDeath);
                            continue;
                        }
                        if (eRad >= 800.0f) {
                            if (world.field_73012_v.nextInt(300) == 0) {
                                entity.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 150, 0));
                            }
                            if (world.field_73012_v.nextInt(300) == 0) {
                                entity.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 200, 2));
                            }
                            if (world.field_73012_v.nextInt(300) == 0) {
                                entity.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 200, 2));
                            }
                            if (world.field_73012_v.nextInt(500) == 0) {
                                entity.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 60, 2));
                            }
                            if (world.field_73012_v.nextInt(700) == 0) {
                                entity.func_70690_d(new PotionEffect(MobEffects.field_82731_v, 60, 1));
                            }
                            if (world.field_73012_v.nextInt(300) == 0) {
                                entity.func_70690_d(new PotionEffect(MobEffects.field_76438_s, 100, 3));
                            }
                            if (world.field_73012_v.nextInt(300) != 0) continue;
                            entity.func_70690_d(new PotionEffect(MobEffects.field_76419_f, 100, 3));
                            continue;
                        }
                        if (eRad >= 600.0f) {
                            if (world.field_73012_v.nextInt(300) == 0) {
                                entity.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 150, 0));
                            }
                            if (world.field_73012_v.nextInt(300) == 0) {
                                entity.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 200, 2));
                            }
                            if (world.field_73012_v.nextInt(300) == 0) {
                                entity.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 200, 2));
                            }
                            if (world.field_73012_v.nextInt(500) == 0) {
                                entity.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 60, 1));
                            }
                            if (world.field_73012_v.nextInt(300) == 0) {
                                entity.func_70690_d(new PotionEffect(MobEffects.field_76438_s, 60, 3));
                            }
                            if (world.field_73012_v.nextInt(400) != 0) continue;
                            entity.func_70690_d(new PotionEffect(MobEffects.field_76419_f, 120, 2));
                            continue;
                        }
                        if (eRad >= 400.0f) {
                            if (world.field_73012_v.nextInt(300) == 0) {
                                entity.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 150, 0));
                            }
                            if (world.field_73012_v.nextInt(500) == 0) {
                                entity.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 100, 0));
                            }
                            if (world.field_73012_v.nextInt(300) == 0) {
                                entity.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 100, 1));
                            }
                            if (world.field_73012_v.nextInt(500) == 0) {
                                entity.func_70690_d(new PotionEffect(MobEffects.field_76438_s, 60, 2));
                            }
                            if (world.field_73012_v.nextInt(600) != 0) continue;
                            entity.func_70690_d(new PotionEffect(MobEffects.field_76419_f, 80, 1));
                            continue;
                        }
                        if (eRad >= 200.0f) {
                            if (world.field_73012_v.nextInt(300) == 0) {
                                entity.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 100, 0));
                            }
                            if (world.field_73012_v.nextInt(500) == 0) {
                                entity.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 100, 0));
                            }
                            if (world.field_73012_v.nextInt(700) == 0) {
                                entity.func_70690_d(new PotionEffect(MobEffects.field_76438_s, 60, 2));
                            }
                            if (world.field_73012_v.nextInt(800) != 0) continue;
                            entity.func_70690_d(new PotionEffect(MobEffects.field_76419_f, 80, 0));
                            continue;
                        }
                        if (!(eRad >= 100.0f)) continue;
                        if (world.field_73012_v.nextInt(800) == 0) {
                            entity.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 40, 0));
                        }
                        if (world.field_73012_v.nextInt(1000) == 0) {
                            entity.func_70690_d(new PotionEffect(MobEffects.field_76419_f, 20, 0));
                        }
                        if (!(entity instanceof EntityPlayerMP)) continue;
                        AdvancementManager.grantAchievement((EntityPlayerMP)entity, AdvancementManager.achRadPoison);
                        continue;
                    }
                    if (!(e instanceof EntityItem)) continue;
                    HazardSystem.updateDroppedItem((EntityItem)e);
                }
            }
            if (GeneralConfig.enableDebugMode) {
                MainRegistry.logger.info("[Debug] Finished entity contamination processing");
            }
        }
    }

    public static void markChunkForRebuild(World world, BlockPos pos) {
        if (!GeneralConfig.advancedRadiation) {
            return;
        }
        BlockPos chunkPos = new BlockPos(pos.func_177958_n() >> 4, pos.func_177956_o() >> 4, pos.func_177952_p() >> 4);
        WorldRadiationData r = RadiationSystemNT.getWorldRadData(world);
        if (GeneralConfig.enableDebugMode) {
            MainRegistry.logger.info("[Debug] Marking chunk dirty at " + chunkPos);
        }
        if (r.iteratingDirty) {
            r.dirtyChunks2.add(chunkPos);
        } else {
            r.dirtyChunks.add(chunkPos);
        }
    }

    private static void rebuildDirty() {
        for (WorldRadiationData r : worldMap.values()) {
            boolean hadDirty = false;
            r.iteratingDirty = true;
            for (BlockPos dirtyChunkPos : r.dirtyChunks) {
                if (GeneralConfig.enableDebugMode) {
                    MainRegistry.logger.info("[Debug] Rebuilding chunk pockets for dirty chunk at " + dirtyChunkPos);
                }
                RadiationSystemNT.rebuildChunkPockets(r.world.func_72964_e(dirtyChunkPos.func_177958_n(), dirtyChunkPos.func_177952_p()), dirtyChunkPos.func_177956_o());
                hadDirty = true;
            }
            r.iteratingDirty = false;
            r.dirtyChunks.clear();
            r.dirtyChunks.addAll(r.dirtyChunks2);
            r.dirtyChunks2.clear();
        }
    }

    @SubscribeEvent
    public static void onWorldUpdate(TickEvent.WorldTickEvent e) {
        boolean allowUpdate;
        if (GeneralConfig.enableDebugMode) {
            MainRegistry.logger.info("[Debug] onWorldUpdate called for RadSys tick " + ticks);
        }
        boolean bl = allowUpdate = e.phase == TickEvent.Phase.START;
        if (allowUpdate) {
            RadiationWorldHandler.handleWorldDestruction(e.world);
        }
        RadiationSystemNT.updateEntityContamination(e.world, allowUpdate);
    }

    @SubscribeEvent
    public static void onUpdate(TickEvent.ServerTickEvent e) {
        if (!GeneralConfig.enableRads || !GeneralConfig.advancedRadiation) {
            return;
        }
        if (GeneralConfig.enableDebugMode) {
            MainRegistry.logger.info("[Debug] onUpdate called for RadSys tick " + ticks);
        }
        if (e.phase == TickEvent.Phase.END && ++ticks % 20 == 17) {
            RadiationSystemNT.updateRadiation();
        }
        RadiationSystemNT.rebuildDirty();
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload e) {
        if (!GeneralConfig.enableRads || !GeneralConfig.advancedRadiation) {
            return;
        }
        if (!e.getWorld().field_72995_K) {
            WorldRadiationData data = RadiationSystemNT.getWorldRadData(e.getWorld());
            if (data.data.containsKey(e.getChunk().func_76632_l())) {
                data.data.get(e.getChunk().func_76632_l()).unload();
                data.data.remove(e.getChunk().func_76632_l());
            }
        }
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkDataEvent.Load e) {
        if (!GeneralConfig.enableRads || !GeneralConfig.advancedRadiation) {
            return;
        }
        if (!e.getWorld().field_72995_K && e.getData().func_74764_b("hbmRadDataNT")) {
            WorldRadiationData data = RadiationSystemNT.getWorldRadData(e.getWorld());
            ChunkRadiationStorage cData = new ChunkRadiationStorage(data, e.getChunk());
            cData.readFromNBT(e.getData().func_74775_l("hbmRadDataNT"));
            data.data.put(e.getChunk().func_76632_l(), cData);
        }
    }

    @SubscribeEvent
    public static void onChunkSave(ChunkDataEvent.Save e) {
        if (!GeneralConfig.enableRads || !GeneralConfig.advancedRadiation) {
            return;
        }
        if (!e.getWorld().field_72995_K) {
            WorldRadiationData data = RadiationSystemNT.getWorldRadData(e.getWorld());
            if (data.data.containsKey(e.getChunk().func_76632_l())) {
                NBTTagCompound tag = new NBTTagCompound();
                data.data.get(e.getChunk().func_76632_l()).writeToNBT(tag);
                e.getData().func_74782_a("hbmRadDataNT", (NBTBase)tag);
            }
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load e) {
        if (!GeneralConfig.enableRads || !GeneralConfig.advancedRadiation) {
            return;
        }
        if (!e.getWorld().field_72995_K) {
            worldMap.put(e.getWorld(), new WorldRadiationData(e.getWorld()));
        }
    }

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload e) {
        if (!GeneralConfig.enableRads || !GeneralConfig.advancedRadiation) {
            return;
        }
        if (!e.getWorld().field_72995_K) {
            worldMap.remove(e.getWorld());
        }
    }

    public static void updateRadiation() {
        long time = System.currentTimeMillis();
        if (GeneralConfig.enableDebugMode) {
            MainRegistry.logger.info("[Debug] Started updating radiation");
        }
        for (WorldRadiationData w : worldMap.values()) {
            ArrayList<RadPocket> itrActive = new ArrayList<RadPocket>(w.getActivePockets());
            Iterator itr = itrActive.iterator();
            while (itr.hasNext()) {
                RadPocket p = (RadPocket)itr.next();
                BlockPos pos = p.parent.parent.getWorldPos(p.parent.yLevel);
                PlayerChunkMapEntry entry = ((WorldServer)w.world).func_184164_w().func_187301_b(((ChunkRadiationStorage)p.parent.parent).chunk.field_76635_g, ((ChunkRadiationStorage)p.parent.parent).chunk.field_76647_h);
                if (entry == null || entry.getWatchingPlayers().isEmpty()) {
                    ((WorldServer)w.world).func_72863_F().func_189549_a(p.parent.parent.chunk);
                }
                p.radiation *= 0.999f;
                p.radiation -= 0.05f;
                p.parent.parent.chunk.func_76630_e();
                if (p.radiation <= 0.0f) {
                    p.radiation = 0.0f;
                    p.accumulatedRads = 0.0f;
                    itr.remove();
                    p.parent.parent.chunk.func_76630_e();
                    continue;
                }
                if (p.radiation > (float)RadiationConfig.fogRad && w.world != null && w.world.field_73012_v.nextInt(RadiationConfig.fogCh) == 0) {
                    for (int i = 0; i < 10; ++i) {
                        BlockPos randPos = new BlockPos(w.world.field_73012_v.nextInt(16), w.world.field_73012_v.nextInt(16), w.world.field_73012_v.nextInt(16));
                        if (p.parent.pocketsByBlock != null && p.parent.pocketsByBlock[randPos.func_177958_n() * 16 * 16 + randPos.func_177956_o() * 16 + randPos.func_177952_p()] != p) continue;
                        randPos = randPos.func_177971_a((Vec3i)p.parent.parent.getWorldPos(p.parent.yLevel));
                        IBlockState state = w.world.func_180495_p(randPos);
                        Vec3d rPos = new Vec3d((double)randPos.func_177958_n() + 0.5, (double)randPos.func_177956_o() + 0.5, (double)randPos.func_177952_p() + 0.5);
                        RayTraceResult trace = w.world.func_72933_a(rPos, rPos.func_72441_c(0.0, -6.0, 0.0));
                        if (!state.func_177230_c().isAir(state, (IBlockAccess)w.world, randPos) || trace == null || trace.field_72313_a != RayTraceResult.Type.BLOCK) continue;
                        PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacket((float)randPos.func_177958_n() + 0.5f, (float)randPos.func_177956_o() + 0.5f, (float)randPos.func_177952_p() + 0.5f, 3), new NetworkRegistry.TargetPoint(w.world.field_73011_w.getDimension(), (double)randPos.func_177958_n(), (double)randPos.func_177956_o(), (double)randPos.func_177952_p(), 100.0));
                        break;
                    }
                }
                float count = 0.0f;
                for (EnumFacing e : EnumFacing.field_82609_l) {
                    count += (float)p.connectionIndices[e.ordinal()].size();
                }
                float amountPer = 0.7f / count;
                if (count == 0.0f || p.radiation < 1.0f) {
                    amountPer = 0.0f;
                }
                if (GeneralConfig.enableDebugMode) {
                    BlockPos chunkPos = new BlockPos(p.getSubChunkPos().func_177958_n() / 16, p.getSubChunkPos().func_177956_o() / 16, p.getSubChunkPos().func_177952_p() / 16);
                    MainRegistry.logger.info("[Debug] Pocket " + p.index + " has " + count + " connections to other pockets at chunk " + chunkPos);
                    if (amountPer > 0.0f) {
                        MainRegistry.logger.info("[Debug] Pocket " + p.index + " will spread " + amountPer + " rads to each adjacent pocket");
                    }
                }
                if (p.radiation > 0.0f && amountPer > 0.0f) {
                    for (EnumFacing e : EnumFacing.field_82609_l) {
                        BlockPos nPos = pos.func_177967_a(e, 16);
                        if (!p.parent.parent.chunk.func_177412_p().func_175667_e(nPos) || nPos.func_177956_o() < 0 || nPos.func_177956_o() > 255) continue;
                        if (p.connectionIndices[e.ordinal()].size() == 1 && p.connectionIndices[e.ordinal()].get(0) == -1) {
                            RadiationSystemNT.rebuildChunkPockets(p.parent.parent.chunk.func_177412_p().func_175726_f(nPos), nPos.func_177956_o() >> 4);
                            continue;
                        }
                        SubChunkRadiationStorage sc2 = RadiationSystemNT.getSubChunkStorage(p.parent.parent.chunk.func_177412_p(), nPos);
                        for (int idx : p.connectionIndices[e.ordinal()]) {
                            if (sc2.pockets[idx].isSealed()) continue;
                            sc2.pockets[idx].accumulatedRads += p.radiation * amountPer;
                            w.addActivePocket(sc2.pockets[idx]);
                        }
                    }
                }
                if (amountPer != 0.0f) {
                    p.accumulatedRads += p.radiation * 0.3f;
                }
                if (System.currentTimeMillis() - time <= 20L) continue;
                break;
            }
            ArrayList<RadPocket> itrActiveCheck = new ArrayList<RadPocket>(w.getActivePockets());
            itr = itrActiveCheck.iterator();
            while (itr.hasNext()) {
                RadPocket act = (RadPocket)itr.next();
                act.radiation = act.accumulatedRads;
                act.accumulatedRads = 0.0f;
                if (!(act.radiation <= 0.0f)) continue;
                w.removeActivePocket(act);
                itr.remove();
            }
        }
        if (GeneralConfig.enableDebugMode) {
            MainRegistry.logger.info("[Debug] Finished updating radiation");
        }
        if (System.currentTimeMillis() - time > 50L) {
            System.out.println("Rads took too long: " + (System.currentTimeMillis() - time));
        }
    }

    public static boolean isRadResistant(World world, Block block, BlockPos pos) {
        if (block instanceof IRadResistantBlock) {
            IRadResistantBlock radBlock = (IRadResistantBlock)block;
            return radBlock.isRadResistant(world, pos);
        }
        return block.func_149638_a(null) >= 2160000.0f;
    }

    private static void rebuildChunkPockets(Chunk chunk, int yIndex) {
        BlockPos subChunkPos = new BlockPos(chunk.func_76632_l().field_77276_a << 4, yIndex << 4, chunk.func_76632_l().field_77275_b << 4);
        if (GeneralConfig.enableDebugMode) {
            MainRegistry.logger.info("[Debug] Starting rebuild of chunk at " + new BlockPos(chunk.func_76632_l().field_77276_a, yIndex, chunk.func_76632_l().field_77275_b));
        }
        ArrayList<RadPocket> pockets = new ArrayList<RadPocket>();
        ExtendedBlockStorage blocks = chunk.func_76587_i()[yIndex];
        if (pocketsByBlock == null) {
            pocketsByBlock = new RadPocket[4096];
        } else {
            Arrays.fill(pocketsByBlock, null);
        }
        ChunkRadiationStorage st = RadiationSystemNT.getChunkStorage(chunk.func_177412_p(), subChunkPos);
        SubChunkRadiationStorage subChunk = new SubChunkRadiationStorage(st, subChunkPos.func_177956_o(), null, null);
        if (blocks != null) {
            for (int x = 0; x < 16; ++x) {
                for (int y = 0; y < 16; ++y) {
                    for (int z = 0; z < 16; ++z) {
                        if (pocketsByBlock[x * 16 * 16 + y * 16 + z] != null) continue;
                        Block block = blocks.func_177485_a(x, y, z).func_177230_c();
                        if (RadiationSystemNT.isRadResistant(chunk.func_177412_p(), block, new BlockPos(x, y, z).func_177971_a((Vec3i)subChunkPos))) continue;
                        if (GeneralConfig.enableDebugMode) {
                            MainRegistry.logger.info("[Debug] Block " + block + " at " + new BlockPos(x, y, z).func_177971_a((Vec3i)subChunkPos) + " was not rad resistant; add pocket");
                        }
                        pockets.add(RadiationSystemNT.buildPocket(subChunk, chunk.func_177412_p(), new BlockPos(x, y, z), subChunkPos, blocks, pocketsByBlock, pockets.size()));
                    }
                }
            }
        } else {
            RadPocket pocket = new RadPocket(subChunk, 0);
            for (int x = 0; x < 16; ++x) {
                for (int y = 0; y < 16; ++y) {
                    RadiationSystemNT.doEmptyChunk(chunk, subChunkPos, new BlockPos(x, 0, y), pocket, EnumFacing.DOWN);
                    RadiationSystemNT.doEmptyChunk(chunk, subChunkPos, new BlockPos(x, 15, y), pocket, EnumFacing.UP);
                    RadiationSystemNT.doEmptyChunk(chunk, subChunkPos, new BlockPos(x, y, 0), pocket, EnumFacing.NORTH);
                    RadiationSystemNT.doEmptyChunk(chunk, subChunkPos, new BlockPos(x, y, 15), pocket, EnumFacing.SOUTH);
                    RadiationSystemNT.doEmptyChunk(chunk, subChunkPos, new BlockPos(0, y, x), pocket, EnumFacing.WEST);
                    RadiationSystemNT.doEmptyChunk(chunk, subChunkPos, new BlockPos(15, y, x), pocket, EnumFacing.EAST);
                }
            }
            pockets.add(pocket);
        }
        RadPocket[] radPocketArray = subChunk.pocketsByBlock = pockets.size() == 1 ? null : pocketsByBlock;
        if (GeneralConfig.enableDebugMode) {
            if (pockets.size() == 1) {
                MainRegistry.logger.info("[Debug] There was only a single pocket for subchunk at " + new BlockPos(chunk.func_76632_l().field_77276_a, yIndex, chunk.func_76632_l().field_77275_b));
            } else {
                MainRegistry.logger.info("[Debug] There was " + pockets.size() + " pockets for subchunk at " + new BlockPos(chunk.func_76632_l().field_77276_a, yIndex, chunk.func_76632_l().field_77275_b));
            }
        }
        if (subChunk.pocketsByBlock != null) {
            pocketsByBlock = null;
        }
        subChunk.pockets = pockets.toArray(new RadPocket[0]);
        st.setForYLevel(yIndex << 4, subChunk);
        if (GeneralConfig.enableDebugMode) {
            MainRegistry.logger.info("[Debug] Finished rebuild of chunk at " + new BlockPos(chunk.func_76632_l().field_77276_a, yIndex, chunk.func_76632_l().field_77275_b));
        }
    }

    private static void doEmptyChunk(Chunk chunk, BlockPos subChunkPos, BlockPos pos, RadPocket pocket, EnumFacing facing) {
        BlockPos newPos = pos.func_177972_a(facing);
        BlockPos outPos = newPos.func_177971_a((Vec3i)subChunkPos);
        Block block = chunk.func_177412_p().func_180495_p(outPos).func_177230_c();
        if (!RadiationSystemNT.isRadResistant(chunk.func_177412_p(), block, outPos)) {
            if (!RadiationSystemNT.isSubChunkLoaded(chunk.func_177412_p(), outPos)) {
                if (!pocket.connectionIndices[facing.ordinal()].contains(-1)) {
                    pocket.connectionIndices[facing.ordinal()].add(-1);
                }
            } else {
                RadPocket outPocket = RadiationSystemNT.getPocket(chunk.func_177412_p(), outPos);
                if (!pocket.connectionIndices[facing.ordinal()].contains(outPocket.index)) {
                    pocket.connectionIndices[facing.ordinal()].add(outPocket.index);
                }
            }
        }
    }

    private static RadPocket buildPocket(SubChunkRadiationStorage subChunk, World world, BlockPos start, BlockPos subChunkWorldPos, ExtendedBlockStorage chunk, RadPocket[] pocketsByBlock, int index) {
        BlockPos chunkPos;
        RadPocket pocket = new RadPocket(subChunk, index);
        if (GeneralConfig.enableDebugMode) {
            chunkPos = new BlockPos(pocket.getSubChunkPos().func_177958_n() / 16, pocket.getSubChunkPos().func_177956_o() / 16, pocket.getSubChunkPos().func_177952_p() / 16);
            MainRegistry.logger.info("[Debug] Starting build of pocket of index " + index + " for chunk at " + chunkPos + ", at local position " + start);
        }
        stack.clear();
        stack.add(start);
        while (!stack.isEmpty()) {
            BlockPos pos = stack.poll();
            Block block = chunk.func_177485_a(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()).func_177230_c();
            if (pocketsByBlock[pos.func_177958_n() * 16 * 16 + pos.func_177956_o() * 16 + pos.func_177952_p()] != null || RadiationSystemNT.isRadResistant(world, block, pos.func_177971_a((Vec3i)subChunkWorldPos))) continue;
            pocketsByBlock[pos.func_177958_n() * 16 * 16 + pos.func_177956_o() * 16 + pos.func_177952_p()] = pocket;
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                BlockPos newPos = pos.func_177972_a(facing);
                if (Math.max(Math.max(newPos.func_177958_n(), newPos.func_177956_o()), newPos.func_177952_p()) > 15 || Math.min(Math.min(newPos.func_177958_n(), newPos.func_177956_o()), newPos.func_177952_p()) < 0) {
                    BlockPos outPos = newPos.func_177971_a((Vec3i)subChunkWorldPos);
                    if (outPos.func_177956_o() < 0 || outPos.func_177956_o() > 255 || RadiationSystemNT.isRadResistant(world, block = world.func_180495_p(outPos).func_177230_c(), outPos)) continue;
                    if (!RadiationSystemNT.isSubChunkLoaded(world, outPos)) {
                        if (pocket.connectionIndices[facing.ordinal()].contains(-1)) continue;
                        pocket.connectionIndices[facing.ordinal()].add(-1);
                        continue;
                    }
                    RadPocket outPocket = RadiationSystemNT.getPocket(world, outPos);
                    if (pocket.connectionIndices[facing.ordinal()].contains(outPocket.index)) continue;
                    pocket.connectionIndices[facing.ordinal()].add(outPocket.index);
                    continue;
                }
                stack.add(newPos);
            }
        }
        if (GeneralConfig.enableDebugMode) {
            chunkPos = new BlockPos(pocket.getSubChunkPos().func_177958_n() / 16, pocket.getSubChunkPos().func_177956_o() / 16, pocket.getSubChunkPos().func_177952_p() / 16);
            MainRegistry.logger.info("[Debug] Finished build of pocket of index " + index + " for chunk at " + chunkPos + ", at local position " + start);
        }
        return pocket;
    }

    static {
        pocketsByBlock = null;
        stack = new ArrayDeque<BlockPos>(1024);
    }

    public static class RadPocket {
        public SubChunkRadiationStorage parent;
        public int index;
        public float radiation;
        private float accumulatedRads = 0.0f;
        public List<Integer>[] connectionIndices = new List[EnumFacing.field_82609_l.length];

        public RadPocket(SubChunkRadiationStorage parent, int index) {
            this.parent = parent;
            this.index = index;
            for (int i = 0; i < EnumFacing.field_82609_l.length; ++i) {
                this.connectionIndices[i] = new ArrayList<Integer>(1);
            }
        }

        protected void remove(World world, BlockPos pos) {
            for (EnumFacing e : EnumFacing.field_82609_l) {
                this.connectionIndices[e.ordinal()].clear();
            }
            this.parent.parent.parent.removeActivePocket(this);
        }

        public BlockPos getSubChunkPos() {
            return this.parent.parent.getWorldPos(this.parent.yLevel);
        }

        public boolean isSealed() {
            float count = 0.0f;
            for (EnumFacing e : EnumFacing.field_82609_l) {
                count += (float)this.connectionIndices[e.ordinal()].size();
            }
            return count == 0.0f;
        }
    }

    public static class WorldRadiationData {
        public World world;
        private Set<BlockPos> dirtyChunks = new HashSet<BlockPos>();
        private Set<BlockPos> dirtyChunks2 = new HashSet<BlockPos>();
        private boolean iteratingDirty = false;
        private Set<RadPocket> activePockets = new HashSet<RadPocket>();
        public Map<ChunkPos, ChunkRadiationStorage> data = new HashMap<ChunkPos, ChunkRadiationStorage>();

        public WorldRadiationData(World world) {
            this.world = world;
        }

        public Set<RadPocket> getActivePockets() {
            if (GeneralConfig.enableDebugMode) {
                MainRegistry.logger.info("[Debug] Queried active pockets for world " + this.world);
            }
            return this.activePockets;
        }

        public void addActivePocket(RadPocket radPocket) {
            this.activePockets.add(radPocket);
            if (GeneralConfig.enableDebugMode) {
                BlockPos chunkPos = new BlockPos(radPocket.getSubChunkPos().func_177958_n() / 16, radPocket.getSubChunkPos().func_177956_o() / 16, radPocket.getSubChunkPos().func_177952_p() / 16);
                MainRegistry.logger.info("[Debug] Added active pocket " + radPocket.index + " (radiation: " + radPocket.radiation + ", accumulatedRads: " + radPocket.accumulatedRads + ", sealed: " + radPocket.isSealed() + ") at " + radPocket.getSubChunkPos() + " (Chunk:" + chunkPos + ") for world " + this.world);
            }
        }

        public void removeActivePocket(RadPocket radPocket) {
            this.activePockets.remove(radPocket);
            if (GeneralConfig.enableDebugMode) {
                BlockPos chunkPos = new BlockPos(radPocket.getSubChunkPos().func_177958_n() / 16, radPocket.getSubChunkPos().func_177956_o() / 16, radPocket.getSubChunkPos().func_177952_p() / 16);
                MainRegistry.logger.info("[Debug] Removed active pocket " + radPocket.index + " (radiation: " + radPocket.radiation + ", accumulatedRads: " + radPocket.accumulatedRads + ", sealed: " + radPocket.isSealed() + ") at " + radPocket.getSubChunkPos() + " (Chunk:" + chunkPos + ") for world " + this.world);
            }
        }

        public void clearActivePockets() {
            this.activePockets.clear();
            if (GeneralConfig.enableDebugMode) {
                MainRegistry.logger.info("[Debug] Cleared active pockets for world " + this.world);
            }
        }
    }

    public static class SubChunkRadiationStorage {
        public ChunkRadiationStorage parent;
        public int yLevel;
        public RadPocket[] pocketsByBlock;
        public RadPocket[] pockets;

        public SubChunkRadiationStorage(ChunkRadiationStorage parent, int yLevel, RadPocket[] pocketsByBlock, RadPocket[] pockets) {
            this.parent = parent;
            this.yLevel = yLevel;
            this.pocketsByBlock = pocketsByBlock;
            this.pockets = pockets;
        }

        public RadPocket getPocket(BlockPos pos) {
            int z;
            int y;
            if (this.pocketsByBlock == null) {
                return this.pockets[0];
            }
            int x = pos.func_177958_n() & 0xF;
            RadPocket p = this.pocketsByBlock[x * 16 * 16 + (y = pos.func_177956_o() & 0xF) * 16 + (z = pos.func_177952_p() & 0xF)];
            if (p == null) {
                if (this.pockets != null && this.pockets.length > 0 && this.pockets[0] != null) {
                    return this.pockets[0];
                }
                p = new RadPocket(this, 0);
                p.radiation = 0.0f;
                if (this.pockets == null || this.pockets.length == 0) {
                    this.pockets = new RadPocket[1];
                }
                this.pockets[0] = p;
                return p;
            }
            return p;
        }

        public void setRad(SubChunkRadiationStorage other) {
            float total = 0.0f;
            for (RadPocket p : other.pockets) {
                if (p.isSealed()) continue;
                total += p.radiation;
            }
            float radPer = total / (float)this.pockets.length;
            for (RadPocket p : this.pockets) {
                p.radiation = radPer;
                if (!(radPer > 0.0f)) continue;
                p.parent.parent.parent.addActivePocket(p);
            }
        }

        public void remove(World world, BlockPos pos) {
            for (RadPocket radPocket : this.pockets) {
                radPocket.remove(world, pos);
            }
            for (RadPocket radPocket : EnumFacing.field_82609_l) {
                world.func_180495_p(pos.func_177967_a((EnumFacing)radPocket, 16));
                if (!RadiationSystemNT.isSubChunkLoaded(world, pos.func_177967_a((EnumFacing)radPocket, 16))) continue;
                SubChunkRadiationStorage sc = RadiationSystemNT.getSubChunkStorage(world, pos.func_177967_a((EnumFacing)radPocket, 16));
                for (RadPocket p : sc.pockets) {
                    p.connectionIndices[radPocket.func_176734_d().ordinal()].clear();
                }
            }
        }

        public void add(World world, BlockPos pos) {
            for (EnumFacing e : EnumFacing.field_82609_l) {
                world.func_180495_p(pos.func_177967_a(e, 16));
                if (!RadiationSystemNT.isSubChunkLoaded(world, pos.func_177967_a(e, 16))) continue;
                SubChunkRadiationStorage sc = RadiationSystemNT.getSubChunkStorage(world, pos.func_177967_a(e, 16));
                for (RadPocket p : sc.pockets) {
                    p.connectionIndices[e.func_176734_d().ordinal()].clear();
                }
                for (RadPocket p : this.pockets) {
                    List<Integer> indc = p.connectionIndices[e.ordinal()];
                    for (int idx : indc) {
                        sc.pockets[idx].connectionIndices[e.func_176734_d().ordinal()].add(p.index);
                    }
                }
            }
        }
    }

    public static class ChunkRadiationStorage {
        private static ByteBuffer buf = ByteBuffer.allocate(524288);
        public WorldRadiationData parent;
        private Chunk chunk;
        private SubChunkRadiationStorage[] chunks = new SubChunkRadiationStorage[16];

        public ChunkRadiationStorage(WorldRadiationData parent, Chunk chunk) {
            this.parent = parent;
            this.chunk = chunk;
        }

        public SubChunkRadiationStorage getForYLevel(int y) {
            int idx = y >> 4;
            if (idx < 0 || idx > this.chunks.length) {
                return null;
            }
            return this.chunks[y >> 4];
        }

        public BlockPos getWorldPos(int y) {
            return new BlockPos(this.chunk.func_76632_l().field_77276_a << 4, y, this.chunk.func_76632_l().field_77275_b << 4);
        }

        public void setForYLevel(int y, SubChunkRadiationStorage sc) {
            if (this.chunks[y >> 4] != null) {
                this.chunks[y >> 4].remove(this.chunk.func_177412_p(), this.getWorldPos(y));
                if (sc != null) {
                    sc.setRad(this.chunks[y >> 4]);
                }
            }
            if (sc != null) {
                sc.add(this.chunk.func_177412_p(), this.getWorldPos(y));
            }
            this.chunks[y >> 4] = sc;
        }

        public void unload() {
            for (int y = 0; y < this.chunks.length; ++y) {
                if (this.chunks[y] == null) continue;
                for (RadPocket p : this.chunks[y].pockets) {
                    this.parent.removeActivePocket(p);
                }
                this.chunks[y] = null;
            }
        }

        public NBTTagCompound writeToNBT(NBTTagCompound tag) {
            for (SubChunkRadiationStorage st : this.chunks) {
                if (st == null) {
                    buf.put((byte)0);
                    continue;
                }
                buf.put((byte)1);
                buf.putShort((short)st.yLevel);
                buf.putShort((short)st.pockets.length);
                for (RadPocket p : st.pockets) {
                    this.writePocket(buf, p);
                }
                if (st.pocketsByBlock == null) {
                    buf.put((byte)0);
                    continue;
                }
                buf.put((byte)1);
                for (RadPocket p : st.pocketsByBlock) {
                    buf.putShort(this.arrayIndex(p, st.pockets));
                }
            }
            buf.flip();
            byte[] data = new byte[buf.limit()];
            buf.get(data);
            tag.func_74773_a("chunkRadData", data);
            buf.clear();
            return tag;
        }

        public short arrayIndex(RadPocket p, RadPocket[] pockets) {
            for (short i = 0; i < pockets.length; i = (short)(i + 1)) {
                if (p != pockets[i]) continue;
                return i;
            }
            return -1;
        }

        public void writePocket(ByteBuffer buf, RadPocket p) {
            buf.putInt(p.index);
            buf.putFloat(p.radiation);
            for (EnumFacing e : EnumFacing.field_82609_l) {
                List<Integer> indc = p.connectionIndices[e.ordinal()];
                buf.putShort((short)indc.size());
                for (int idx : indc) {
                    buf.putShort((short)idx);
                }
            }
        }

        public void readFromNBT(NBTTagCompound tag) {
            ByteBuffer data = ByteBuffer.wrap(tag.func_74770_j("chunkRadData"));
            for (int i = 0; i < this.chunks.length; ++i) {
                boolean subChunkExists;
                boolean bl = subChunkExists = data.get() == 1;
                if (subChunkExists) {
                    boolean perBlockDataExists;
                    short yLevel = data.getShort();
                    SubChunkRadiationStorage st = new SubChunkRadiationStorage(this, yLevel, null, null);
                    int pocketsLength = data.getShort();
                    st.pockets = new RadPocket[pocketsLength];
                    for (int j = 0; j < pocketsLength; ++j) {
                        st.pockets[j] = this.readPocket(data, st);
                        if (!(st.pockets[j].radiation > 0.0f)) continue;
                        this.parent.addActivePocket(st.pockets[j]);
                    }
                    boolean bl2 = perBlockDataExists = data.get() == 1;
                    if (perBlockDataExists) {
                        st.pocketsByBlock = new RadPocket[4096];
                        for (int j = 0; j < 4096; ++j) {
                            short idx = data.getShort();
                            if (idx < 0) continue;
                            st.pocketsByBlock[j] = st.pockets[idx];
                        }
                    }
                    this.chunks[i] = st;
                    continue;
                }
                this.chunks[i] = null;
            }
        }

        public RadPocket readPocket(ByteBuffer buf, SubChunkRadiationStorage parent) {
            int index = buf.getInt();
            RadPocket p = new RadPocket(parent, index);
            p.radiation = buf.getFloat();
            for (EnumFacing e : EnumFacing.field_82609_l) {
                List<Integer> indc = p.connectionIndices[e.ordinal()];
                int size = buf.getShort();
                for (int i = 0; i < size; ++i) {
                    indc.add(Integer.valueOf(buf.getShort()));
                }
            }
            return p;
        }
    }
}

