/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.crt;

import com.hbm.inventory.RecipesCommon;
import com.hbm.main.MainRegistry;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.IngredientStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.oredict.IOreDictEntry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class NTMCraftTweaker {
    public static final List<IAction> postInitActions = new ArrayList<IAction>();

    public static void applyPostInitActions() {
        try {
            postInitActions.forEach(CraftTweakerAPI::apply);
        }
        catch (Throwable t) {
            MainRegistry.logger.info("CraftTweaker integration decativated");
        }
    }

    @Nullable
    public static RecipesCommon.AStack IIngredientToAStack(IIngredient ingredient) {
        if (ingredient instanceof IItemStack) {
            return new RecipesCommon.ComparableStack(CraftTweakerMC.getItemStack((IItemStack)((IItemStack)ingredient)));
        }
        if (ingredient instanceof IOreDictEntry) {
            return new RecipesCommon.OreDictStack(((IOreDictEntry)ingredient).getName());
        }
        if (ingredient instanceof IngredientStack) {
            IIngredient ingredient2 = (IIngredient)ingredient.getInternal();
            if (ingredient2 instanceof IItemStack) {
                return new RecipesCommon.ComparableStack(CraftTweakerMC.getItemStack((IItemStack)((IItemStack)ingredient2)));
            }
            if (ingredient2 instanceof IOreDictEntry) {
                return new RecipesCommon.OreDictStack(((IOreDictEntry)ingredient2).getName(), ingredient.getAmount());
            }
        }
        CraftTweakerAPI.logError((String)("ERROR: Unknown ingredient type: " + ingredient.getClass().getName()));
        return null;
    }

    public static RecipesCommon.AStack[] IIngredientsToAStack(IIngredient[] ingredients) {
        RecipesCommon.AStack[] result = new RecipesCommon.AStack[ingredients.length];
        for (int i = 0; i < ingredients.length; ++i) {
            result[i] = NTMCraftTweaker.IIngredientToAStack(ingredients[i]);
        }
        return result;
    }
}

