/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.handler.crt;

import com.hbm.handler.crt.NTMCraftTweaker;
import com.hbm.inventory.ShredderRecipes;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.minecraft.CraftTweakerMC;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.ntm.Shredder")
public class Shredder {
    @ZenMethod
    public static void addRecipe(IItemStack input, IItemStack output) {
        NTMCraftTweaker.postInitActions.add(new ActionAddRecipe(input, output));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack input) {
        NTMCraftTweaker.postInitActions.add(new ActionRemoveRecipe(input));
    }

    private static class ActionAddRecipe
    implements IAction {
        private ItemStack input;
        private ItemStack output;

        public ActionAddRecipe(IItemStack input, IItemStack output) {
            this.input = CraftTweakerMC.getItemStack((IItemStack)input);
            this.output = CraftTweakerMC.getItemStack((IItemStack)output);
        }

        public void apply() {
            if (this.input == null || this.input.func_190926_b()) {
                CraftTweakerAPI.logError((String)"ERROR Shredder recipe input item can not be an empty/air stack!");
                return;
            }
            if (this.output == null || this.output.func_190926_b()) {
                CraftTweakerAPI.logError((String)"ERROR Shredder recipe output item can not be an empty/air stack!");
                return;
            }
            ShredderRecipes.setRecipe(this.input, this.output);
        }

        public String describe() {
            return "Adding NTM shredder recipe (" + this.input + " -> " + this.output + ")";
        }
    }

    public static class ActionRemoveRecipe
    implements IAction {
        private ItemStack input;

        public ActionRemoveRecipe(IItemStack input) {
            this.input = CraftTweakerMC.getItemStack((IItemStack)input);
        }

        public void apply() {
            if (this.input == null || this.input.func_190926_b()) {
                CraftTweakerAPI.logError((String)"ERROR Shredder input item can not be an empty/air stack!");
                return;
            }
            ShredderRecipes.removeRecipe(this.input);
        }

        public String describe() {
            return "Removing NTM shredder recipe for input " + this.input;
        }
    }
}

