/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.hazard;

import com.hbm.hazard.HazardData;
import com.hbm.hazard.HazardEntry;
import com.hbm.hazard.HazardRegistry;
import com.hbm.hazard.modifier.HazardModifier;
import com.hbm.hazard.transformer.HazardTransformerBase;
import com.hbm.hazard.type.HazardTypeBase;
import com.hbm.interfaces.Untested;
import com.hbm.inventory.RecipesCommon;
import com.hbm.util.ContaminationUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

@Untested
public class HazardSystem {
    public static final HashMap<String, HazardData> oreMap = new HashMap();
    public static final HashMap<Item, HazardData> itemMap = new HashMap();
    public static final HashMap<RecipesCommon.ComparableStack, HazardData> stackMap = new HashMap();
    public static final HashSet<RecipesCommon.ComparableStack> stackBlacklist = new HashSet();
    public static final HashSet<String> dictBlacklist = new HashSet();
    public static final List<HazardTransformerBase> trafos = new ArrayList<HazardTransformerBase>();
    public static final HashMap<String, HazardData> fluidMap = new HashMap();

    public static void registerFluid(String o, HazardData data) {
        if (o != null) {
            fluidMap.put(o, data);
        }
    }

    public static void register(Object o, HazardData data) {
        if (o instanceof String) {
            oreMap.put((String)o, data);
        }
        if (o instanceof Item) {
            itemMap.put((Item)o, data);
        }
        if (o instanceof Block) {
            itemMap.put(Item.func_150898_a((Block)((Block)o)), data);
        }
        if (o instanceof ItemStack) {
            stackMap.put(new RecipesCommon.ComparableStack((ItemStack)o), data);
        }
        if (o instanceof RecipesCommon.ComparableStack) {
            stackMap.put((RecipesCommon.ComparableStack)o, data);
        }
    }

    public static HazardData getHaz(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return oreMap.get((String)o);
        }
        if (o instanceof Item) {
            return itemMap.get((Item)o);
        }
        if (o instanceof Block) {
            return itemMap.get(Item.func_150898_a((Block)((Block)o)));
        }
        if (o instanceof ItemStack) {
            return stackMap.get(new RecipesCommon.ComparableStack((ItemStack)o));
        }
        if (o instanceof RecipesCommon.ComparableStack) {
            return stackMap.get((RecipesCommon.ComparableStack)o);
        }
        return null;
    }

    public static void blacklist(Object o) {
        if (o instanceof ItemStack) {
            stackBlacklist.add(new RecipesCommon.ComparableStack((ItemStack)o).makeSingular());
        } else if (o instanceof String) {
            dictBlacklist.add((String)o);
        }
    }

    public static boolean isItemBlacklisted(ItemStack stack) {
        int[] ids;
        if (stackBlacklist.contains(new RecipesCommon.ComparableStack(stack).makeSingular())) {
            return true;
        }
        for (int id : ids = OreDictionary.getOreIDs((ItemStack)stack)) {
            String name = OreDictionary.getOreName((int)id);
            if (!dictBlacklist.contains(name)) continue;
            return true;
        }
        return false;
    }

    public static List<HazardEntry> getHazardsFromFluid(String f) {
        ArrayList<HazardEntry> chronological = new ArrayList<HazardEntry>();
        if (fluidMap.containsKey(f)) {
            chronological.addAll(HazardSystem.fluidMap.get((Object)f).entries);
        }
        return chronological;
    }

    public static List<HazardEntry> getHazardsFromStack(ItemStack stack) {
        RecipesCommon.ComparableStack comp;
        int[] ids;
        if (stack == null || stack.func_190926_b() || HazardSystem.isItemBlacklisted(stack)) {
            return new ArrayList<HazardEntry>();
        }
        ArrayList<HazardData> chronological = new ArrayList<HazardData>();
        for (int id : ids = OreDictionary.getOreIDs((ItemStack)stack)) {
            String name = OreDictionary.getOreName((int)id);
            if (!oreMap.containsKey(name)) continue;
            chronological.add(oreMap.get(name));
        }
        if (itemMap.containsKey(stack.func_77973_b())) {
            chronological.add(itemMap.get(stack.func_77973_b()));
        }
        if (stackMap.containsKey(comp = new RecipesCommon.ComparableStack(stack).makeSingular())) {
            chronological.add(stackMap.get(comp));
        }
        ArrayList<HazardEntry> entries = new ArrayList<HazardEntry>();
        for (HazardTransformerBase trafo : trafos) {
            trafo.transformPre(stack, entries);
        }
        int mutex = 0;
        for (HazardData data : chronological) {
            if (data.doesOverride) {
                entries.clear();
            }
            if ((data.getMutex() & mutex) != 0) continue;
            entries.addAll(data.entries);
            mutex |= data.getMutex();
        }
        for (HazardTransformerBase trafo : trafos) {
            trafo.transformPost(stack, entries);
        }
        return entries;
    }

    public static float getHazardLevelFromStack(ItemStack stack, HazardTypeBase hazard) {
        List<HazardEntry> entries = HazardSystem.getHazardsFromStack(stack);
        for (HazardEntry entry : entries) {
            if (entry.type != hazard) continue;
            return HazardModifier.evalAllModifiers(stack, null, entry.baseLevel, entry.mods);
        }
        return 0.0f;
    }

    public static float getRawRadsFromBlock(Block b) {
        return HazardSystem.getHazardLevelFromStack(new ItemStack(Item.func_150898_a((Block)b)), HazardRegistry.RADIATION);
    }

    public static float getRawRadsFromStack(ItemStack stack) {
        return HazardSystem.getHazardLevelFromStack(stack, HazardRegistry.RADIATION);
    }

    public static float getTotalRadsFromStack(ItemStack stack) {
        return HazardSystem.getHazardLevelFromStack(stack, HazardRegistry.RADIATION) + ContaminationUtil.getNeutronRads(stack);
    }

    public static void applyHazards(Block b, EntityLivingBase entity) {
        HazardSystem.applyHazards(new ItemStack(Item.func_150898_a((Block)b)), entity);
    }

    public static void applyHazards(ItemStack stack, EntityLivingBase entity) {
        List<HazardEntry> hazards = HazardSystem.getHazardsFromStack(stack);
        for (HazardEntry hazard : hazards) {
            hazard.applyHazard(stack, entity);
        }
    }

    public static void updatePlayerInventory(EntityPlayer player) {
        int inventorySize = player.field_71071_by.func_70302_i_();
        for (int i = 0; i < inventorySize; ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            HazardSystem.applyHazards(stack, (EntityLivingBase)player);
            if (stack.func_190916_E() != 0) continue;
            player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
        }
        player.field_71069_bz.func_75142_b();
    }

    public static void updateLivingInventory(EntityLivingBase entity) {
        for (EntityEquipmentSlot i : EntityEquipmentSlot.values()) {
            ItemStack stack = entity.func_184582_a(i);
            if (stack.func_190926_b()) continue;
            HazardSystem.applyHazards(stack, entity);
        }
    }

    public static void updateDroppedItem(EntityItem entity) {
        if (entity.field_70128_L) {
            return;
        }
        ItemStack stack = entity.func_92059_d();
        if (stack.func_190926_b() || stack.func_190916_E() <= 0) {
            return;
        }
        List<HazardEntry> hazards = HazardSystem.getHazardsFromStack(stack);
        for (HazardEntry entry : hazards) {
            entry.type.updateEntity(entity, HazardModifier.evalAllModifiers(stack, null, entry.baseLevel, entry.mods));
        }
    }

    public static void addHazardInfo(ItemStack stack, EntityPlayer player, List<String> list, ITooltipFlag flagIn) {
        List<HazardEntry> hazards = HazardSystem.getHazardsFromStack(stack);
        for (HazardEntry hazard : hazards) {
            hazard.type.addHazardInformation(player, list, hazard.baseLevel, stack, hazard.mods);
        }
    }
}

