/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.hazard.type;

import com.hbm.config.GeneralConfig;
import com.hbm.hazard.modifier.HazardModifier;
import com.hbm.hazard.type.HazardTypeBase;
import com.hbm.items.ModItems;
import com.hbm.lib.Library;
import com.hbm.util.ContaminationUtil;
import com.hbm.util.I18nUtil;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class HazardTypeRadiation
extends HazardTypeBase {
    @Override
    public void onUpdate(EntityLivingBase target, float level, ItemStack stack) {
        if (ContaminationUtil.isRadImmune((Entity)target)) {
            return;
        }
        boolean reacher = false;
        if (target instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)target;
            if (!GeneralConfig.enable528) {
                boolean bl = reacher = Library.checkForHeld(player, ModItems.reacher) || Library.checkForBauble(player, ModItems.reacher);
            }
        }
        if (level > 0.0f) {
            float rad = level * (float)stack.func_190916_E() / 20.0f;
            if (reacher) {
                rad = (float)Math.min(Math.sqrt(rad), (double)rad);
            }
            ContaminationUtil.contaminate(target, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.CREATIVE, rad);
        }
    }

    @Override
    public void updateEntity(EntityItem item, float level) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addHazardInformation(EntityPlayer player, List<String> list, float level, ItemStack stack, List<HazardModifier> modifiers) {
        if ((level = HazardModifier.evalAllModifiers(stack, (EntityLivingBase)player, level, modifiers)) == 0.0f) {
            return;
        }
        list.add("\u00a7a[" + I18nUtil.resolveKey("trait.radioactive", new Object[0]) + "]");
        list.add(" \u00a7e" + Library.roundFloat(HazardTypeRadiation.getNewValue(level), 3) + HazardTypeRadiation.getSuffix(level) + " " + I18nUtil.resolveKey("desc.rads", new Object[0]));
        if (stack.func_190916_E() > 1) {
            float stackRad = level * (float)stack.func_190916_E();
            list.add(" \u00a7e" + I18nUtil.resolveKey("desc.stack", new Object[0]) + " " + Library.roundFloat(HazardTypeRadiation.getNewValue(stackRad), 3) + HazardTypeRadiation.getSuffix(stackRad) + " " + I18nUtil.resolveKey("desc.rads", new Object[0]));
        }
    }

    public static float getNewValue(float radiation) {
        if (radiation < 1000000.0f) {
            return radiation;
        }
        if (radiation < 1.0E9f) {
            return radiation * 1.0E-6f;
        }
        return radiation * 1.0E-9f;
    }

    public static String getSuffix(float radiation) {
        if (radiation < 1000000.0f) {
            return "";
        }
        if (radiation < 1.0E9f) {
            return I18nUtil.resolveKey("desc.mil", new Object[0]);
        }
        return I18nUtil.resolveKey("desc.bil", new Object[0]);
    }
}

