/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.hfr.render.loader;

import com.hbm.hfr.render.loader.HFRWavefrontObject;
import com.hbm.hfr.render.loader.S_Face;
import com.hbm.hfr.render.loader.S_GroupObject;
import com.hbm.render.amlfrom1710.IModelCustom;
import com.hbm.render.amlfrom1710.Tessellator;
import com.hbm.render.amlfrom1710.TextureCoordinate;
import com.hbm.render.amlfrom1710.Vertex;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;

public class WavefrontObjVBO
implements IModelCustom {
    List<VBOBufferData> groups = new ArrayList<VBOBufferData>();
    static int VERTEX_SIZE = 3;
    static int UV_SIZE = 3;

    public WavefrontObjVBO(HFRWavefrontObject obj) {
        for (S_GroupObject g : obj.groupObjects) {
            VBOBufferData data = new VBOBufferData();
            data.name = g.name;
            FloatBuffer vertexData = BufferUtils.createFloatBuffer((int)(g.faces.size() * 3 * VERTEX_SIZE));
            FloatBuffer uvData = BufferUtils.createFloatBuffer((int)(g.faces.size() * 3 * UV_SIZE));
            FloatBuffer normalData = BufferUtils.createFloatBuffer((int)(g.faces.size() * 3 * VERTEX_SIZE));
            for (S_Face face : g.faces) {
                for (int i = 0; i < face.vertices.length; ++i) {
                    Vertex vert = face.vertices[i];
                    TextureCoordinate tex = new TextureCoordinate(0.0f, 0.0f);
                    Vertex normal = face.vertexNormals[i];
                    if (face.textureCoordinates != null && face.textureCoordinates.length > 0) {
                        tex = face.textureCoordinates[i];
                    }
                    ++data.vertices;
                    vertexData.put(new float[]{vert.x, vert.y, vert.z});
                    uvData.put(new float[]{tex.u, tex.v, tex.w});
                    normalData.put(new float[]{normal.x, normal.y, normal.z});
                }
            }
            vertexData.flip();
            uvData.flip();
            normalData.flip();
            data.vertexHandle = GL15.glGenBuffers();
            GL15.glBindBuffer((int)34962, (int)data.vertexHandle);
            GL15.glBufferData((int)34962, (FloatBuffer)vertexData, (int)35044);
            GL15.glBindBuffer((int)34962, (int)0);
            data.uvHandle = GL15.glGenBuffers();
            GL15.glBindBuffer((int)34962, (int)data.uvHandle);
            GL15.glBufferData((int)34962, (FloatBuffer)uvData, (int)35044);
            GL15.glBindBuffer((int)34962, (int)0);
            data.normalHandle = GL15.glGenBuffers();
            GL15.glBindBuffer((int)34962, (int)data.normalHandle);
            GL15.glBufferData((int)34962, (FloatBuffer)normalData, (int)35044);
            GL15.glBindBuffer((int)34962, (int)0);
            this.groups.add(data);
        }
    }

    @Override
    public String getType() {
        return "obj_vbo";
    }

    private void renderVBO(VBOBufferData data) {
        GL15.glBindBuffer((int)34962, (int)data.vertexHandle);
        GL11.glVertexPointer((int)VERTEX_SIZE, (int)5126, (int)0, (long)0L);
        GL15.glBindBuffer((int)34962, (int)data.uvHandle);
        GL11.glTexCoordPointer((int)UV_SIZE, (int)5126, (int)0, (long)0L);
        GL15.glBindBuffer((int)34962, (int)data.normalHandle);
        GL11.glNormalPointer((int)5126, (int)0, (long)0L);
        GL11.glEnableClientState((int)32884);
        GL11.glEnableClientState((int)32888);
        GL11.glEnableClientState((int)32885);
        GL11.glDrawArrays((int)4, (int)0, (int)data.vertices);
        GL11.glDisableClientState((int)32884);
        GL11.glDisableClientState((int)32888);
        GL11.glDisableClientState((int)32885);
        GL15.glBindBuffer((int)34962, (int)0);
    }

    @Override
    public void renderAll() {
        for (VBOBufferData data : this.groups) {
            this.renderVBO(data);
        }
    }

    @Override
    public void renderOnly(String ... groupNames) {
        for (VBOBufferData data : this.groups) {
            for (String name : groupNames) {
                if (!data.name.equalsIgnoreCase(name)) continue;
                this.renderVBO(data);
            }
        }
    }

    @Override
    public void renderPart(String partName) {
        for (VBOBufferData data : this.groups) {
            if (!data.name.equalsIgnoreCase(partName)) continue;
            this.renderVBO(data);
        }
    }

    @Override
    public void renderAllExcept(String ... excludedGroupNames) {
        for (VBOBufferData data : this.groups) {
            boolean skip = false;
            for (String name : excludedGroupNames) {
                if (!data.name.equalsIgnoreCase(name)) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            this.renderVBO(data);
        }
    }

    @Override
    public void tessellateAll(Tessellator tes) {
        throw new RuntimeException("Tessellate not supported on HFR model");
    }

    @Override
    public void tessellatePart(Tessellator tes, String name) {
        throw new RuntimeException("Tessellate not supported on HFR model");
    }

    @Override
    public void tessellateOnly(Tessellator tes, String ... names) {
        throw new RuntimeException("Tessellate not supported on HFR model");
    }

    @Override
    public void tessellateAllExcept(Tessellator tes, String ... excluded) {
        throw new RuntimeException("Tessellate not supported on HFR model");
    }

    class VBOBufferData {
        String name;
        int vertices = 0;
        int vertexHandle;
        int uvHandle;
        int normalHandle;

        VBOBufferData() {
        }
    }
}

