/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.control_panel;

import com.hbm.main.ResourceManager;
import com.hbm.render.RenderHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import org.lwjgl.opengl.GL11;

public class ItemList {
    public float posX;
    public float posY;
    public float width;
    public int textColor = -5263441;
    public float r = 0.5f;
    public float g = 0.5f;
    public float b = 0.5f;
    public float alpha = 0.5f;
    public List<String> itemNames = new ArrayList<String>();
    public Function<String, ItemList> action;
    public ItemList child;
    public boolean isClosed;

    public ItemList(float posX, float posY, float width, Function<String, ItemList> a) {
        this.posX = posX;
        this.posY = posY;
        this.width = width;
        this.action = a;
        this.isClosed = false;
    }

    public ItemList addItems(String ... items) {
        this.itemNames.addAll(Arrays.asList(items));
        return this;
    }

    public void render(float mouseX, float mouseY) {
        if (this.isClosed) {
            return;
        }
        if (this.child != null) {
            this.child.render(mouseX, mouseY);
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(ResourceManager.white);
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder buf = tes.func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        RenderHelper.drawGuiRectBatchedColor(this.posX, this.posY, 0.0f, 0.0f, this.width, this.itemNames.size() * 6 + 4, 1.0f, 1.0f, this.r, this.g, this.b, this.alpha);
        int idx = this.getMouseoverIndex(mouseX, mouseY);
        if (idx != -1) {
            RenderHelper.drawGuiRectBatchedColor(this.posX, this.posY + (float)(idx * 6) + 2.0f, 0.0f, 0.0f, this.width, 5.0f, 1.0f, 1.0f, this.r + 0.1f, this.g + 0.1f, this.b + 0.1f, this.alpha);
        }
        tes.func_78381_a();
        GlStateManager.func_179084_k();
        GL11.glPushMatrix();
        GL11.glTranslated((double)this.posX, (double)this.posY, (double)0.0);
        GL11.glScaled((double)0.4, (double)0.4, (double)1.0);
        GL11.glTranslated((double)(-this.posX), (double)(-this.posY), (double)0.0);
        float y = this.posY + 7.0f;
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        for (String s : this.itemNames) {
            if (s.startsWith("{expandable}")) {
                font.func_175065_a(">", this.posX + this.width * 2.0f - 6.0f, y, this.textColor, false);
                s = s.substring(12);
            }
            font.func_175065_a(s, this.posX + 2.0f, y, this.textColor, false);
            y += 15.0f;
        }
        GL11.glPopMatrix();
    }

    public boolean mouseClicked(float x, float y) {
        if (this.isClosed) {
            return false;
        }
        boolean didAction = false;
        if (this.child != null && RenderHelper.intersects2DBox(x, y, this.child.getBoundingBox())) {
            return this.child.mouseClicked(x, y);
        }
        if (this.child != null) {
            this.child.close();
            this.child = null;
        }
        float yPos = this.posY + 2.0f;
        for (String s : this.itemNames) {
            if (x > this.posX && x < this.posX + this.width && y > yPos && y < yPos + 6.0f) {
                ItemList newList = this.action.apply(s);
                if (newList != null) {
                    newList.posX = this.posX + this.width;
                    newList.posY = yPos;
                    this.child = newList;
                } else {
                    didAction = true;
                }
            }
            yPos += 6.0f;
        }
        return didAction;
    }

    public int getMouseoverIndex(float x, float y) {
        float yPos = this.posY + 2.0f;
        for (int i = 0; i < this.itemNames.size(); ++i) {
            if (x > this.posX && x < this.posX + this.width && y > yPos && y < yPos + 5.0f) {
                return i;
            }
            yPos += 6.0f;
        }
        return -1;
    }

    public float[] getBoundingBox() {
        if (this.child != null) {
            float[] box = this.child.getBoundingBox();
            return new float[]{Math.min(this.posX, box[0]), Math.min(this.posY, box[1]), Math.max(this.posX + this.width, box[2]), Math.max(this.posY + (float)(this.itemNames.size() * 6) + 4.0f, box[3])};
        }
        return new float[]{this.posX, this.posY, this.posX + this.width, this.posY + (float)(this.itemNames.size() * 6) + 4.0f};
    }

    public void close() {
        this.isClosed = true;
    }

    public void open() {
        this.isClosed = false;
    }
}

